/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.model;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleLiteral;
import org.eclipse.rdf4j.sail.nativerdf.ValueStoreRevision;
import org.eclipse.rdf4j.sail.nativerdf.model.NativeValue;

public class NativeLiteral
extends SimpleLiteral
implements NativeValue {
    private static final long serialVersionUID = 5198968663650168819L;
    private volatile ValueStoreRevision revision;
    private volatile int internalID;

    protected NativeLiteral(ValueStoreRevision revision, int internalID) {
        this.setInternalID(internalID, revision);
    }

    public NativeLiteral(ValueStoreRevision revision, String label) {
        this(revision, label, -1);
    }

    public NativeLiteral(ValueStoreRevision revision, String label, int internalID) {
        super(label);
        this.setInternalID(internalID, revision);
    }

    public NativeLiteral(ValueStoreRevision revision, String label, String lang) {
        this(revision, label, lang, -1);
    }

    public NativeLiteral(ValueStoreRevision revision, String label, String lang, int internalID) {
        super(label, lang);
        this.setInternalID(internalID, revision);
    }

    public NativeLiteral(ValueStoreRevision revision, String label, IRI datatype) {
        this(revision, label, datatype, -1);
    }

    public NativeLiteral(ValueStoreRevision revision, String label, IRI datatype, int internalID) {
        super(label, datatype);
        this.setInternalID(internalID, revision);
    }

    @Override
    public void setInternalID(int internalID, ValueStoreRevision revision) {
        this.internalID = internalID;
        this.revision = revision;
    }

    @Override
    public ValueStoreRevision getValueStoreRevision() {
        return this.revision;
    }

    @Override
    public int getInternalID() {
        return this.internalID;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NativeLiteral && this.internalID != -1) {
            NativeLiteral otherNativeLiteral = (NativeLiteral)o;
            if (otherNativeLiteral.internalID != -1 && this.revision.equals(otherNativeLiteral.revision)) {
                return this.internalID == otherNativeLiteral.internalID;
            }
        }
        return super.equals(o);
    }
}

