/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UpdateContext;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailConnectionWrapper;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ConnectionHelper;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.ShaclSailValidationException;
import org.eclipse.rdf4j.sail.shacl.Stats;
import org.eclipse.rdf4j.sail.shacl.VerySimpleRdfsBackwardsChainingConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.results.ValidationReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclSailConnection
extends NotifyingSailConnectionWrapper
implements SailConnectionListener {
    private static final Logger logger = LoggerFactory.getLogger(ShaclSailConnection.class);
    private List<NodeShape> nodeShapes;
    private final NotifyingSailConnection previousStateConnection;
    private final NotifyingSailConnection serializableConnection;
    private final NotifyingSailConnection previousStateSerializableConnection;
    MemoryStore addedStatements;
    MemoryStore removedStatements;
    private HashSet<Statement> addedStatementsSet = new HashSet();
    private HashSet<Statement> removedStatementsSet = new HashSet();
    private boolean isShapeRefreshNeeded = false;
    private boolean shapesModifiedInCurrentTransaction = false;
    public final ShaclSail sail;
    private Stats stats;
    RdfsSubClassOfReasoner rdfsSubClassOfReasoner;
    private boolean preparedHasRun = false;
    private SailRepositoryConnection shapesRepoConnection;
    private long writeLockStamp;
    private boolean connectionListenerActive = false;
    private IsolationLevel currentIsolationLevel = null;

    ShaclSailConnection(ShaclSail sail, NotifyingSailConnection connection, NotifyingSailConnection previousStateConnection, NotifyingSailConnection serializableConnection, NotifyingSailConnection previousStateSerializableConnection, SailRepositoryConnection shapesRepoConnection) {
        super(connection);
        this.previousStateConnection = previousStateConnection;
        this.serializableConnection = serializableConnection;
        this.previousStateSerializableConnection = previousStateSerializableConnection;
        this.shapesRepoConnection = shapesRepoConnection;
        this.sail = sail;
        this.setupConnectionListener();
    }

    @Override
    public void begin() throws SailException {
        this.begin(this.sail.getDefaultIsolationLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin(IsolationLevel level) throws SailException {
        this.currentIsolationLevel = level;
        assert (this.addedStatements == null);
        assert (this.removedStatements == null);
        this.stats = new Stats();
        ShaclSail shaclSail = this.sail;
        synchronized (shaclSail) {
            super.begin(level);
            this.hasStatement(null, null, null, false, new Resource[0]);
            this.shapesRepoConnection.begin(level);
            this.previousStateConnection.begin(level);
            this.previousStateConnection.hasStatement(null, null, null, false, new Resource[0]);
        }
        this.stats.setBaseSailEmpty(this.isEmpty());
        if (this.stats.isBaseSailEmpty()) {
            this.removeConnectionListener(this);
            this.connectionListenerActive = false;
        } else {
            this.setupConnectionListener();
        }
    }

    private void setupConnectionListener() {
        if (!this.connectionListenerActive && this.sail.isValidationEnabled()) {
            this.addConnectionListener(this);
        }
    }

    private MemoryStore getNewMemorySail() {
        MemoryStore sail = new MemoryStore();
        sail.setDefaultIsolationLevel(IsolationLevels.NONE);
        sail.init();
        return sail;
    }

    @Override
    public void commit() throws SailException {
        if (!this.preparedHasRun) {
            this.prepare();
        }
        long before = 0L;
        if (this.sail.isPerformanceLogging()) {
            before = System.currentTimeMillis();
        }
        this.previousStateConnection.commit();
        super.commit();
        this.shapesRepoConnection.commit();
        if (this.shapesModifiedInCurrentTransaction) {
            this.sail.setNodeShapes(this.nodeShapes);
        }
        if (this.sail.holdsWriteLock(this.writeLockStamp)) {
            this.writeLockStamp = this.sail.releaseExclusiveWriteLock(this.writeLockStamp);
        }
        if (this.sail.isPerformanceLogging()) {
            logger.info("commit() excluding validation and cleanup took {} ms", (Object)(System.currentTimeMillis() - before));
        }
        this.cleanup();
    }

    @Override
    public void addStatement(UpdateContext modify, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals(contexts[0])) {
            this.writeLockStamp = this.sail.acquireExclusiveWriteLock(this.writeLockStamp);
            this.shapesRepoConnection.add(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.addStatement(modify, subj, pred, obj, contexts);
        }
    }

    @Override
    public void removeStatement(UpdateContext modify, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals(contexts[0])) {
            this.writeLockStamp = this.sail.acquireExclusiveWriteLock(this.writeLockStamp);
            this.shapesRepoConnection.remove(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.removeStatement(modify, subj, pred, obj, contexts);
        }
    }

    @Override
    public void addStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals(contexts[0])) {
            this.writeLockStamp = this.sail.acquireExclusiveWriteLock(this.writeLockStamp);
            this.shapesRepoConnection.add(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.addStatement(subj, pred, obj, contexts);
        }
    }

    @Override
    public void removeStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals(contexts[0])) {
            this.writeLockStamp = this.sail.acquireExclusiveWriteLock(this.writeLockStamp);
            this.shapesRepoConnection.remove(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.removeStatements(subj, pred, obj, contexts);
        }
    }

    @Override
    public void clear(Resource ... contexts) throws SailException {
        if (Arrays.asList(contexts).contains(RDF4J.SHACL_SHAPE_GRAPH)) {
            this.shapesRepoConnection.clear(new Resource[0]);
            this.isShapeRefreshNeeded = true;
        }
        super.clear(contexts);
    }

    @Override
    public void rollback() throws SailException {
        this.previousStateConnection.rollback();
        this.shapesRepoConnection.rollback();
        super.rollback();
        if (this.shapesModifiedInCurrentTransaction || this.isShapeRefreshNeeded) {
            this.isShapeRefreshNeeded = true;
            this.refreshShapes();
            if (this.shapesModifiedInCurrentTransaction) {
                this.sail.setNodeShapes(this.nodeShapes);
            }
        }
        if (this.sail.holdsWriteLock(this.writeLockStamp)) {
            this.writeLockStamp = this.sail.releaseExclusiveWriteLock(this.writeLockStamp);
        }
        this.cleanup();
    }

    private void cleanup() {
        long before = 0L;
        if (this.sail.isPerformanceLogging()) {
            before = System.currentTimeMillis();
        }
        logger.debug("Cleanup");
        if (this.addedStatements != null) {
            if (this.addedStatements != this.sail.getBaseSail()) {
                this.addedStatements.shutDown();
            }
            this.addedStatements = null;
        }
        if (this.removedStatements != null) {
            this.removedStatements.shutDown();
            this.removedStatements = null;
        }
        this.addedStatementsSet.clear();
        this.removedStatementsSet.clear();
        this.stats = null;
        this.preparedHasRun = false;
        this.isShapeRefreshNeeded = false;
        this.shapesModifiedInCurrentTransaction = false;
        assert (this.writeLockStamp == 0L);
        this.currentIsolationLevel = null;
        if (this.sail.isPerformanceLogging()) {
            logger.info("cleanup() took {} ms", (Object)(System.currentTimeMillis() - before));
        }
    }

    private void refreshShapes() {
        if (this.isShapeRefreshNeeded) {
            this.nodeShapes = this.sail.refreshShapes(this.shapesRepoConnection);
            this.isShapeRefreshNeeded = false;
            this.shapesModifiedInCurrentTransaction = true;
        }
    }

    /*
     * Loose catch block
     */
    private List<Tuple> validate(List<NodeShape> nodeShapes, boolean validateEntireBaseSail) {
        try {
            if (!this.sail.isValidationEnabled()) {
                List<Tuple> list = Collections.emptyList();
                return list;
            }
            try (ConnectionsGroup connectionsGroup = this.getConnectionsGroup();){
                List<Tuple> list = ShaclSailConnection.performValidation(nodeShapes, validateEntireBaseSail, connectionsGroup);
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.rdfsSubClassOfReasoner = null;
        }
    }

    private void prepareValidation() {
        if (!this.sail.isValidationEnabled()) {
            return;
        }
        if (this.sail.isRdfsSubClassReasoning()) {
            this.rdfsSubClassOfReasoner = RdfsSubClassOfReasoner.createReasoner(this);
        }
        this.fillAddedAndRemovedStatementRepositories();
    }

    ConnectionsGroup getConnectionsGroup() {
        return new ConnectionsGroup(this.sail, new VerySimpleRdfsBackwardsChainingConnection(this, this.rdfsSubClassOfReasoner), this.previousStateConnection, this.addedStatements, this.removedStatements, this.stats, this::getRdfsSubClassOfReasoner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Tuple> performValidation(List<NodeShape> nodeShapes, boolean validateEntireBaseSail, ConnectionsGroup connectionsGroup) {
        long beforeValidation = 0L;
        ShaclSail sail = connectionsGroup.getSail();
        if (sail.isPerformanceLogging()) {
            beforeValidation = System.currentTimeMillis();
        }
        try {
            Stream planNodeStream = nodeShapes.stream().flatMap(nodeShape -> nodeShape.generatePlans(connectionsGroup, (NodeShape)nodeShape, sail.isLogValidationPlans(), validateEntireBaseSail));
            if (sail.isParallelValidation()) {
                planNodeStream = (Stream)planNodeStream.parallel();
            }
            List<Tuple> list = planNodeStream.filter(Objects::nonNull).flatMap(planNode -> {
                ValidationExecutionLogger validationExecutionLogger = new ValidationExecutionLogger();
                planNode.receiveLogger(validationExecutionLogger);
                try (Stream<Tuple> stream = Iterations.stream(planNode.iterator());){
                    boolean valid;
                    if (GlobalValidationExecutionLogging.loggingEnabled) {
                        PropertyShape propertyShape = ((EnrichWithShape)planNode).getPropertyShape();
                        logger.info("Start execution of plan " + propertyShape.getNodeShape().toString() + " : " + propertyShape.getId());
                    }
                    long before = 0L;
                    if (sail.isPerformanceLogging()) {
                        before = System.currentTimeMillis();
                    }
                    List collect = stream.collect(Collectors.toList());
                    validationExecutionLogger.flush();
                    if (sail.isPerformanceLogging()) {
                        long after = System.currentTimeMillis();
                        PropertyShape propertyShape = ((EnrichWithShape)planNode).getPropertyShape();
                        logger.info("Execution of plan took {} ms for {} : {}", new Object[]{after - before, propertyShape.getNodeShape().toString(), propertyShape.toString()});
                    }
                    if (GlobalValidationExecutionLogging.loggingEnabled) {
                        PropertyShape propertyShape = ((EnrichWithShape)planNode).getPropertyShape();
                        logger.info("Finished execution of plan {} : {}", (Object)propertyShape.getNodeShape().toString(), (Object)propertyShape.getId());
                    }
                    boolean bl = valid = collect.size() == 0;
                    if (!valid && sail.isLogValidationViolations()) {
                        PropertyShape propertyShape = ((EnrichWithShape)planNode).getPropertyShape();
                        logger.info("SHACL not valid. The following experimental debug results were produced: \n\tNodeShape: {}\n\tPropertyShape: {} \n\t\t{}", new Object[]{propertyShape.getNodeShape().getId(), propertyShape.getId(), collect.stream().map(a -> a.toString() + " -cause-> " + a.getCause()).collect(Collectors.joining("\n\t\t"))});
                    }
                    Stream stream2 = collect.stream();
                    return stream2;
                }
            }).collect(Collectors.toList());
            return list;
        }
        finally {
            if (sail.isPerformanceLogging()) {
                logger.info("Actual validation and generating plans took {} ms", (Object)(System.currentTimeMillis() - beforeValidation));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void fillAddedAndRemovedStatementRepositories() {
        long before;
        block28: {
            block29: {
                before = 0L;
                if (this.sail.isPerformanceLogging()) {
                    before = System.currentTimeMillis();
                }
                if (!this.stats.isBaseSailEmpty()) break block29;
                this.flush();
                if ((this.rdfsSubClassOfReasoner == null || this.rdfsSubClassOfReasoner.isEmpty()) && this.sail.getBaseSail() instanceof MemoryStore && this.getIsolationLevel() == IsolationLevels.NONE) {
                    this.addedStatements = (MemoryStore)this.sail.getBaseSail();
                    this.removedStatements = this.getNewMemorySail();
                    break block28;
                } else {
                    this.addedStatements = this.getNewMemorySail();
                    this.removedStatements = this.getNewMemorySail();
                    try (Stream<? extends Statement> stream = Iterations.stream(this.getStatements(null, null, null, false, new Resource[0]));
                         NotifyingSailConnection connection = this.addedStatements.getConnection();){
                        connection.begin(IsolationLevels.NONE);
                        stream.flatMap(statement -> this.rdfsSubClassOfReasoner == null ? Stream.of(statement) : this.rdfsSubClassOfReasoner.forwardChain((Statement)statement)).forEach(statement -> connection.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getContext()));
                        connection.commit();
                        break block28;
                    }
                }
            }
            ((Stream)Stream.of(this.addedStatementsSet, this.removedStatementsSet).parallel()).forEach(set -> {
                MemoryStore repository;
                HashSet<Statement> otherSet;
                if (set == this.addedStatementsSet) {
                    otherSet = this.removedStatementsSet;
                    if (this.addedStatements != null && this.addedStatements != this.sail.getBaseSail()) {
                        this.addedStatements.shutDown();
                    }
                    repository = this.addedStatements = this.getNewMemorySail();
                    set.forEach(this.stats::added);
                } else {
                    otherSet = this.addedStatementsSet;
                    if (this.removedStatements != null) {
                        this.removedStatements.shutDown();
                        this.removedStatements = null;
                    }
                    repository = this.removedStatements = this.getNewMemorySail();
                    set.forEach(this.stats::removed);
                }
                try (NotifyingSailConnection connection = repository.getConnection();){
                    connection.begin(IsolationLevels.NONE);
                    set.stream().filter(statement -> !otherSet.contains(statement)).flatMap(statement -> this.rdfsSubClassOfReasoner == null ? Stream.of(statement) : this.rdfsSubClassOfReasoner.forwardChain((Statement)statement)).forEach(statement -> connection.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getContext()));
                    connection.commit();
                }
            });
        }
        if (this.sail.isPerformanceLogging()) {
            logger.info("fillAddedAndRemovedStatementRepositories() took {} ms", (Object)(System.currentTimeMillis() - before));
        }
    }

    private IsolationLevel getIsolationLevel() {
        return this.currentIsolationLevel;
    }

    @Override
    public synchronized void close() throws SailException {
        try {
            if (this.isActive()) {
                this.rollback();
            }
            this.shapesRepoConnection.close();
            this.previousStateConnection.close();
            this.serializableConnection.close();
            this.previousStateSerializableConnection.close();
            super.close();
        }
        finally {
            this.sail.closeConnection(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws SailException {
        this.flush();
        long readStamp = 0L;
        try {
            boolean useSerializableValidation;
            long before = 0L;
            if (this.sail.isPerformanceLogging()) {
                before = System.currentTimeMillis();
            }
            boolean bl = useSerializableValidation = this.sail.isSerializableValidation() && this.currentIsolationLevel == IsolationLevels.SNAPSHOT;
            if (useSerializableValidation) {
                if (!this.sail.holdsWriteLock(this.writeLockStamp)) {
                    this.writeLockStamp = this.sail.acquireExclusiveWriteLock(this.writeLockStamp);
                }
            } else if (!this.sail.holdsWriteLock(this.writeLockStamp)) {
                readStamp = this.sail.acquireReadlock();
            }
            this.loadCachedNodeShapes();
            List<NodeShape> nodeShapesBeforeRefresh = this.nodeShapes;
            this.refreshShapes();
            List<NodeShape> nodeShapesAfterRefresh = this.nodeShapes;
            if (this.addedStatementsSet.isEmpty() && this.removedStatementsSet.isEmpty() && !this.shapesModifiedInCurrentTransaction) {
                boolean currentBaseSailEmpty = this.isEmpty();
                if (!this.stats.isBaseSailEmpty() || currentBaseSailEmpty) {
                    logger.debug("Nothing has changed, nothing to validate.");
                    return;
                }
            }
            if (this.shapesModifiedInCurrentTransaction && this.addedStatementsSet.isEmpty() && this.removedStatementsSet.isEmpty()) {
                assert (nodeShapesBeforeRefresh != nodeShapesAfterRefresh);
                HashSet<NodeShape> nodeShapesBeforeRefreshSet = new HashSet<NodeShape>(nodeShapesBeforeRefresh);
                nodeShapesAfterRefresh = nodeShapesAfterRefresh.stream().filter(nodeShape -> !nodeShapesBeforeRefreshSet.contains(nodeShape)).collect(Collectors.toList());
            }
            this.prepareValidation();
            List<Tuple> invalidTuples = null;
            if (useSerializableValidation) {
                ShaclSail shaclSail = this.sail;
                synchronized (shaclSail) {
                    if (!this.sail.usesSingleConnection()) {
                        invalidTuples = this.serializableValidation(nodeShapesAfterRefresh);
                    }
                }
            }
            if (invalidTuples == null) {
                if (this.writeLockStamp != 0L) {
                    readStamp = this.sail.convertToReadLock(this.writeLockStamp);
                    this.writeLockStamp = 0L;
                }
                invalidTuples = this.validate(nodeShapesAfterRefresh, this.shapesModifiedInCurrentTransaction);
            }
            boolean valid = invalidTuples.isEmpty();
            if (this.sail.isPerformanceLogging()) {
                logger.info("prepare() including validation excluding locking and super.prepare() took {} ms", (Object)(System.currentTimeMillis() - before));
            }
            if (!valid) {
                throw new ShaclSailValidationException(invalidTuples);
            }
        }
        finally {
            this.preparedHasRun = true;
            if (readStamp != 0L && !this.sail.holdsWriteLock(this.writeLockStamp)) {
                readStamp = this.sail.releaseReadlock(readStamp);
            }
            this.previousStateConnection.prepare();
            super.prepare();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Tuple> serializableValidation(List<NodeShape> nodeShapesAfterRefresh) {
        List<Tuple> invalidTuples;
        try {
            try {
                try (ConnectionsGroup connectionsGroup = new ConnectionsGroup(this.sail, new VerySimpleRdfsBackwardsChainingConnection(this.serializableConnection, this.rdfsSubClassOfReasoner), this.previousStateSerializableConnection, this.addedStatements, this.removedStatements, this.stats, () -> this.getRdfsSubClassOfReasoner());){
                    SailConnection baseConnection;
                    connectionsGroup.getBaseConnection().begin(IsolationLevels.SNAPSHOT);
                    connectionsGroup.getBaseConnection().hasStatement(null, null, null, false, new Resource[0]);
                    connectionsGroup.getPreviousStateConnection().begin(IsolationLevels.SNAPSHOT);
                    connectionsGroup.getPreviousStateConnection().hasStatement(null, null, null, false, new Resource[0]);
                    this.stats.setBaseSailEmpty(ConnectionHelper.isEmpty(connectionsGroup.getBaseConnection()));
                    try (NotifyingSailConnection connection = this.addedStatements.getConnection();){
                        baseConnection = connectionsGroup.getBaseConnection();
                        ConnectionHelper.transferStatements(connection, (x$0, x$1, x$2, xva$3) -> baseConnection.addStatement(x$0, x$1, x$2, xva$3));
                    }
                    connection = this.removedStatements.getConnection();
                    var6_7 = null;
                    try {
                        baseConnection = connectionsGroup.getBaseConnection();
                        ConnectionHelper.transferStatements(connection, (x$0, x$1, x$2, xva$3) -> baseConnection.removeStatements(x$0, x$1, x$2, xva$3));
                    }
                    catch (Throwable throwable) {
                        var6_7 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (connection != null) {
                            if (var6_7 != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable) {
                                    var6_7.addSuppressed(throwable);
                                }
                            } else {
                                connection.close();
                            }
                        }
                    }
                    this.serializableConnection.flush();
                    invalidTuples = ShaclSailConnection.performValidation(nodeShapesAfterRefresh, this.shapesModifiedInCurrentTransaction, connectionsGroup);
                }
                finally {
                    this.serializableConnection.rollback();
                }
            }
            finally {
                this.previousStateSerializableConnection.rollback();
            }
        }
        finally {
            this.rdfsSubClassOfReasoner = null;
        }
        return invalidTuples;
    }

    private void loadCachedNodeShapes() {
        this.nodeShapes = this.sail.getNodeShapes();
    }

    @Override
    public void statementAdded(Statement statement) {
        if (this.preparedHasRun) {
            throw new IllegalStateException("Detected changes after prepare() has been called.");
        }
        boolean add = this.addedStatementsSet.add(statement);
        if (!add) {
            this.removedStatementsSet.remove(statement);
        }
    }

    @Override
    public void statementRemoved(Statement statement) {
        if (this.preparedHasRun) {
            throw new IllegalStateException("Detected changes after prepare() has been called.");
        }
        boolean add = this.removedStatementsSet.add(statement);
        if (!add) {
            this.addedStatementsSet.remove(statement);
        }
    }

    public RdfsSubClassOfReasoner getRdfsSubClassOfReasoner() {
        return this.rdfsSubClassOfReasoner;
    }

    @Override
    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals(contexts[0])) {
            return ConnectionHelper.getCloseableIteration(this.shapesRepoConnection.getStatements(subj, pred, obj, includeInferred, new Resource[0]));
        }
        return super.getStatements(subj, pred, obj, includeInferred, contexts);
    }

    @Override
    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals(contexts[0])) {
            return this.shapesRepoConnection.hasStatement(subj, pred, obj, includeInferred, new Resource[0]);
        }
        return super.hasStatement(subj, pred, obj, includeInferred, contexts);
    }

    private boolean isEmpty() {
        return ConnectionHelper.isEmpty(this);
    }

    public ValidationReport revalidate() {
        if (!this.isActive()) {
            throw new IllegalStateException("No active transaction!");
        }
        this.loadCachedNodeShapes();
        this.prepareValidation();
        List<Tuple> validate = this.validate(this.nodeShapes, true);
        return new ShaclSailValidationException(validate).getValidationReport();
    }
}

