package org.provarules.reference2.builtins;

import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.*;

import java.util.List;

public class ProvaSpawnImpl extends ProvaBuiltinImpl {

    public ProvaSpawnImpl(ProvaKnowledgeBase kb) {
        super(kb, "spawn");
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node,
                           ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        ProvaLiteral literal = goal.getGoal();
        return prova.getMessenger().spawn(literal, newLiterals, query);
    }

}
