/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.api2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.provarules.agent2.ProvaReagent;
import org.provarules.agent2.ProvaReagentImpl;
import org.provarules.api2.ProvaCommunicator;
import org.provarules.esb2.ProvaAgent;
import org.provarules.exchange.ProvaSolution;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.messaging.ProvaMessenger;
import org.provarules.parser2.ProvaParsingException;
import org.provarules.service.ProvaMiniService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaCommunicatorImpl
implements ProvaCommunicator {
    private static final Logger log = LoggerFactory.getLogger((String)"prova");
    public static final boolean ASYNC = true;
    public static final boolean SYNC = false;
    private ProvaReagent prova;
    private ProvaMessenger messenger;

    public ProvaCommunicatorImpl(String agent, String port, Object rules, boolean async) {
        String[] prot = port != null ? new String[]{"jade"} : null;
        this.prova = new ProvaReagentImpl(this, null, agent, port, prot, rules, async, null, null);
    }

    public ProvaCommunicatorImpl(String agent, String port, Object rules, boolean async, Map<String, Object> globals) {
        String[] prot = port != null ? new String[]{"jade"} : null;
        this.prova = new ProvaReagentImpl(this, null, agent, port, prot, rules, async, null, globals);
    }

    public ProvaCommunicatorImpl(String agent, String port, Object rules, boolean async, ProvaAgent esb, Map<String, Object> globals) {
        String[] prot = port != null ? new String[]{"jade"} : null;
        this.prova = new ProvaReagentImpl(this, null, agent, port, prot, rules, async, esb, globals);
    }

    public ProvaCommunicatorImpl(String agent, Object rules, boolean async) {
        this.prova = new ProvaReagentImpl(this, null, agent, null, null, rules, async, null, null);
        this.messenger = this.prova.getMessenger();
    }

    public ProvaCommunicatorImpl(ProvaMiniService service, String agent, String port, Object rules, boolean async, Map<String, Object> globals) {
        String[] prot = port != null ? new String[]{"jade"} : null;
        this.prova = new ProvaReagentImpl(this, service, agent, port, prot, rules, async, null, globals);
    }

    @Override
    public void stop() {
        if (this.prova != null) {
            this.prova.shutdown();
        }
    }

    @Override
    public List<ProvaSolution[]> getInitializationSolutions() {
        return this.prova.getInitializationSolutions();
    }

    @Override
    public List<ProvaSolution[]> consultSync(String src, String key, Object[] objects) throws Exception {
        Future<List<ProvaSolution[]>> list = this.prova.consultSync(src, key, objects);
        return list.get();
    }

    @Override
    public List<ProvaSolution[]> consultSync(BufferedReader in, String key, Object[] objects) {
        try {
            Future<List<ProvaSolution[]>> list = this.prova.consultSync(in, key, objects);
            return list.get();
        }
        catch (Exception e) {
            if (e.getCause() instanceof ProvaParsingException) {
                throw new RuntimeException(e.getCause());
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public void consultAsync(String src, String key, Object[] objects) throws Exception {
        this.prova.consultAsync(src, key, objects);
    }

    @Override
    public void consultAsync(BufferedReader in, String key, Object[] objects) throws Exception {
        this.prova.consultAsync(in, key, objects);
    }

    @Override
    public void setPrintWriter(PrintWriter printWriter) {
        this.prova.setPrintWriter(printWriter);
    }

    public Object sendMsg(String xid, String protocol, Object obj_receiver, String perf, String term, Object[] objs) {
        String sb = ":-sendMsg(" + xid + ',' + protocol + ',' + obj_receiver + ',' + perf + ',' + term + ").";
        BufferedReader in = new BufferedReader(new StringReader(sb));
        try {
            this.consultSync(in, "", objs);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 3) {
            ProvaCommunicatorImpl.usage();
        }
        String agent = args[0];
        String password = args[1];
        String rules = args[2];
        String[] prot = null;
        int timeout = 0;
        int i = 3;
        while (i < args.length) {
            if (args[i].equals("-p")) {
                if (i + 1 == args.length) {
                    ProvaCommunicatorImpl.usage();
                }
                prot = args[i + 1].split(",");
                i += 2;
                continue;
            }
            if (!args[i].equals("-t")) break;
            if (i + 1 == args.length) {
                ProvaCommunicatorImpl.usage();
            }
            timeout = Integer.parseInt(args[i + 1]);
            i += 2;
        }
        HashMap<String, Object> globals = new HashMap<String, Object>();
        int offset = i;
        while (i < args.length) {
            globals.put("$" + (i - offset), args[i]);
            ++i;
        }
        try {
            ProvaCommunicatorImpl comm = new ProvaCommunicatorImpl(agent, null, rules, false, globals);
            try {
                ProvaCommunicatorImpl provaCommunicatorImpl = comm;
                synchronized (provaCommunicatorImpl) {
                    if (timeout == 0) {
                        while (!comm.getReagent().canShutdown()) {
                            comm.wait(1000L);
                        }
                    } else if (timeout == -1) {
                        comm.wait();
                    } else {
                        comm.wait(timeout * 1000);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            comm.shutdown();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                log.error("IO error while reading from {}", (Object)rules);
            }
            log.error("Communicator error {}", (Object)e.getCause().toString());
        }
    }

    private static void usage() {
        System.out.println("Usage: prova <agent> <password> <rules file> [-t <timeout in seconds>] [-p <prot1,..,protN>] [arguments]");
        System.exit(1);
    }

    @Override
    public void shutdown() {
        this.prova.shutdown();
    }

    @Override
    public ProvaReagent getReagent() {
        return this.prova;
    }

    @Override
    public void addMsg(ProvaList terms) {
        this.messenger.addMsg(terms);
    }

    @Override
    public void addMsg(String xid, Map<String, Object> msg) {
        this.messenger.addMsg(xid, msg);
    }

    @Override
    public void addMsg(String xid, String agent, String verb, Object payload) {
        this.messenger.addMsg(xid, agent, verb, payload);
    }

    @Override
    public void unconsultSync(String src) {
        this.prova.unconsultSync(src);
    }

    @Override
    public void setGlobalConstant(String name, Object value) {
        this.prova.setGlobalConstant(name, value);
    }

    @Override
    public void setMessenger(ProvaMessenger messenger) {
        this.messenger = messenger;
    }
}

