/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.eventing;

import org.provarules.eventing.Aggregation;
import org.provarules.eventing.CountValue;
import org.provarules.eventing.ProvaBasicEventsAccumulatorImpl;

public class Aggregator
extends ProvaBasicEventsAccumulatorImpl {
    private static final long serialVersionUID = -6070105850518061308L;
    private CountValue agg;
    private Aggregation processor;

    Aggregator() {
        this.agg = new CountValue(0, 0.0);
        this.processor = new SumAggregation();
    }

    private Aggregator(Aggregator aggregator) {
        super(aggregator);
        this.agg = aggregator.agg;
        this.processor = aggregator.processor;
    }

    @Override
    public long totalCount() {
        return this.agg.count;
    }

    public CountValue process(double value) {
        this.processor.process(this.agg, value);
        return this.agg;
    }

    @Override
    public void clear() {
        this.agg.count = 0;
        this.agg.value = 0.0;
    }

    @Override
    public Aggregator clone() {
        return new Aggregator(this);
    }

    public String toString() {
        return "Aggregator [count=" + this.agg.count + ", value=" + this.agg.value + "]";
    }

    private static class SumAggregation
    implements Aggregation {
        private static final long serialVersionUID = -5934127748617778629L;

        private SumAggregation() {
        }

        @Override
        public void process(CountValue cv, double value) {
            ++cv.count;
            cv.value += value;
        }
    }
}

