/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.eventing;

import java.util.Map;
import java.util.TreeMap;
import org.provarules.eventing.Aggregation;
import org.provarules.eventing.CountValue;
import org.provarules.eventing.ProvaBasicEventsAccumulatorImpl;
import org.provarules.eventing.ProvaEventsAccumulator;

public class MapAggregator
extends ProvaBasicEventsAccumulatorImpl {
    private static final long serialVersionUID = -4644372132667191024L;
    private long totalCount;
    private Map<Object, CountValue> map;
    private Aggregation processor;
    private ProvaEventsAccumulator.AccumulationMode accumulationMode;

    public MapAggregator() {
        this.accumulationMode = ProvaEventsAccumulator.AccumulationMode.Clear;
        this.map = new TreeMap<Object, CountValue>();
        this.processor = new SumAggregation();
    }

    public MapAggregator(ProvaEventsAccumulator.AccumulationMode accumulationMode) {
        this.accumulationMode = accumulationMode;
        this.map = new TreeMap<Object, CountValue>();
        this.processor = new SumAggregation();
    }

    public MapAggregator(MapAggregator aggregator) {
        super(aggregator);
        this.totalCount = aggregator.totalCount;
        this.accumulationMode = aggregator.accumulationMode;
        this.map = new TreeMap<Object, CountValue>(aggregator.map);
        this.processor = aggregator.processor;
    }

    @Override
    public long totalCount() {
        return this.totalCount;
    }

    public Map<Object, CountValue> getMap() {
        return this.map;
    }

    public CountValue processAt(Object key, double value) {
        CountValue agg = this.map.get(key);
        if (agg == null) {
            agg = new CountValue(0, 0.0);
            this.map.put(key, agg);
        }
        this.processor.process(agg, value);
        ++this.totalCount;
        return agg;
    }

    @Override
    public void clear() {
        if (this.accumulationMode == ProvaEventsAccumulator.AccumulationMode.Clear) {
            this.totalCount = 0L;
            this.map.clear();
        }
    }

    @Override
    public MapAggregator clone() {
        return new MapAggregator(this);
    }

    public String toString() {
        return "MapAggregator [count=" + this.totalCount + ", map=" + this.map + "]";
    }

    private static class SumAggregation
    implements Aggregation {
        private static final long serialVersionUID = 6263950015116331352L;

        private SumAggregation() {
        }

        @Override
        public void process(CountValue cv, double value) {
            ++cv.count;
            cv.value += value;
        }
    }
}

