/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.eventing;

import java.util.Map;
import java.util.TreeMap;
import org.provarules.eventing.ProvaBasicEventsAccumulatorImpl;
import org.provarules.eventing.ProvaEventsAccumulator;

public class MapCounter
extends ProvaBasicEventsAccumulatorImpl {
    private static final long serialVersionUID = 7769272455398438735L;
    private long totalCount;
    private Map<Object, Long> map;
    private ProvaEventsAccumulator.AccumulationMode accumulationMode;

    public MapCounter() {
        this.accumulationMode = ProvaEventsAccumulator.AccumulationMode.Clear;
        this.map = new TreeMap<Object, Long>();
    }

    public MapCounter(ProvaEventsAccumulator.AccumulationMode accumulationMode) {
        this.accumulationMode = accumulationMode;
        this.map = new TreeMap<Object, Long>();
    }

    public MapCounter(MapCounter counter) {
        super(counter);
        this.totalCount = counter.totalCount;
        this.accumulationMode = counter.accumulationMode;
        this.map = new TreeMap<Object, Long>(counter.map);
    }

    @Override
    public long totalCount() {
        return this.totalCount;
    }

    public Map<Object, Long> getMap() {
        return this.map;
    }

    public long incrementAt(Object key) {
        Long count = this.map.get(key);
        if (count == null) {
            this.map.put(key, 1L);
            ++this.totalCount;
            return 1L;
        }
        count = count + 1L;
        this.map.put(key, count);
        ++this.totalCount;
        return count;
    }

    public long addAt(Object key, long delta) {
        Long count = this.map.get(key);
        if (count == null) {
            this.map.put(key, delta);
            this.totalCount += delta;
            return delta;
        }
        this.map.put(key, count + delta);
        this.totalCount += delta;
        return count + delta;
    }

    @Override
    public void clear() {
        if (this.accumulationMode == ProvaEventsAccumulator.AccumulationMode.Clear) {
            this.totalCount = 0L;
            this.map.clear();
        }
    }

    @Override
    public MapCounter clone() {
        return new MapCounter(this);
    }

    public String toString() {
        return "MapCounter [count=" + this.totalCount + ", map=" + this.map + "]";
    }
}

