/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.eventing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.provarules.eventing.Accumulation;
import org.provarules.eventing.ProvaBasicEventsAccumulatorImpl;
import org.provarules.eventing.ProvaEventsAccumulator;

public class SortedAccumulator
extends ProvaBasicEventsAccumulatorImpl {
    private static final long serialVersionUID = 8593913229446147787L;
    private TreeMap<Object, List<Object>> map;
    private Accumulation processor;
    private ProvaEventsAccumulator.AccumulationMode accumulationMode;

    public SortedAccumulator() {
        this.accumulationMode = ProvaEventsAccumulator.AccumulationMode.Clear;
        this.map = new TreeMap();
        this.processor = new AddAccumulation();
    }

    public SortedAccumulator(ProvaEventsAccumulator.AccumulationMode accumulationMode) {
        this.accumulationMode = accumulationMode;
        this.map = new TreeMap();
        this.processor = new AddAccumulation();
    }

    public SortedAccumulator(SortedAccumulator accumulator) {
        super(accumulator);
        this.accumulationMode = accumulator.accumulationMode;
        this.map = new TreeMap<Object, List<Object>>((SortedMap<Object, List<Object>>)accumulator.map);
        this.processor = accumulator.processor;
    }

    public List<Object> processAt(Object key, Object value) {
        List acc = this.map.computeIfAbsent(key, k -> new ArrayList());
        this.processor.process(acc, value);
        return acc;
    }

    @Override
    public long totalCount() {
        long total = 0L;
        for (List<Object> bucket : this.map.values()) {
            total += (long)bucket.size();
        }
        return total;
    }

    public List<Object> lowest(int n) {
        ArrayList<Object> results = new ArrayList<Object>();
        int count = 0;
        for (Map.Entry<Object, List<Object>> entry : this.map.entrySet()) {
            List<Object> objs = entry.getValue();
            for (Object obj : objs) {
                results.add(obj);
                if (++count != n) continue;
                return results;
            }
        }
        return results;
    }

    public List<Object> highest(int n) {
        ArrayList<Object> results = new ArrayList<Object>();
        int count = 0;
        for (Map.Entry entry : this.map.descendingMap().entrySet()) {
            List objs = (List)entry.getValue();
            for (Object obj : objs) {
                results.add(obj);
                if (++count != n) continue;
                return results;
            }
        }
        return results;
    }

    @Override
    public void clear() {
        if (this.accumulationMode == ProvaEventsAccumulator.AccumulationMode.Clear) {
            this.map.clear();
        }
    }

    @Override
    public SortedAccumulator clone() {
        return new SortedAccumulator(this);
    }

    public String toString() {
        return "SortedAccumulator [totalCount=" + this.totalCount() + " ,map=" + this.map + "]";
    }

    private class AddAccumulation
    implements Accumulation {
        private AddAccumulation() {
        }

        @Override
        public void process(List<Object> acc, Object value) {
            acc.add(value);
        }
    }
}

