/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.parser2;

import java.util.HashMap;
import java.util.Map;

public class ParsingException
extends Exception {
    private static final long serialVersionUID = -5948759071972118254L;
    private String src;
    private String desc;
    private Map<Integer, String> errors = new HashMap<Integer, String>();

    public ParsingException() {
    }

    public ParsingException(String message) {
        super(message);
    }

    @Override
    public String toString() {
        return this.desc + " in " + this.src;
    }

    public Map<Integer, String> errors() {
        return this.errors;
    }

    public String errorsToString() {
        StringBuilder sb = new StringBuilder();
        for (Integer key : this.errors.keySet()) {
            sb.append("Line ");
            sb.append(key);
            sb.append(" > ");
            sb.append(this.errors.get(key));
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getSource() {
        return this.src;
    }

    public void setSource(String src) {
        this.src = src;
    }

    public void addError(int line, String desc) {
        this.errors.put(line, desc);
    }
}

