/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaPredicate;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaUnification;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaLiteralImpl;
import org.provarules.reference2.ProvaMapImpl;
import org.provarules.reference2.ProvaPredicateImpl;
import org.provarules.reference2.ProvaRuleImpl;
import org.provarules.reference2.ProvaUnificationImpl;
import org.provarules.reference2.ProvaVariableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaGoalImpl
implements ProvaGoal {
    private static final Logger log = LoggerFactory.getLogger((String)"prova");
    private ProvaRule query;
    private ProvaLiteral goal;
    private ProvaPredicate predicate;
    private Iterator<ProvaRule> iterator;
    private final List<ProvaVariable> variables;
    private boolean cut = false;
    private List<ProvaList> extraAnswers;
    private List<ProvaList> outerAnswers;
    private boolean singleClause;
    private ProvaRule rule;
    private List<ProvaList> meta;
    private ProvaRule lastMatch;

    public ProvaGoalImpl(ProvaRule query) {
        this.query = query;
        this.variables = query.getVariables();
        this.goal = query.getTop();
        this.goal.setGoal(this);
        this.predicate = this.goal.getPredicate();
    }

    public ProvaGoalImpl(List<ProvaVariable> variables, ProvaLiteral goal) {
        this.variables = variables;
        this.goal = goal;
        this.predicate = goal.getPredicate();
        this.iterator = this.predicate.getClauseSet().getClauses().iterator();
        for (int i = 0; i < this.query.getOffset(); ++i) {
            this.iterator.next();
        }
    }

    @Override
    public void update() {
        this.goal = this.query.getTop();
        this.predicate = this.goal.getPredicate();
    }

    private void createIterator() {
        List<ProvaRule> clauses;
        ProvaObject[] fixed = this.goal.getTerms().getFixed();
        if (fixed.length != 0) {
            ProvaObject firstObject = fixed[0];
            if (firstObject instanceof ProvaVariablePtr) {
                firstObject = this.variables.get(((ProvaVariablePtr)firstObject).getIndex());
                firstObject = firstObject.getRecursivelyAssigned();
            }
            if (firstObject instanceof ProvaConstant && !(firstObject instanceof ProvaMapImpl)) {
                Object o = ((ProvaConstant)firstObject).getObject();
                List<ProvaRule> keyClauses = this.predicate.getClauseSet().getClauses(o, fixed);
                if (keyClauses != null) {
                    if (keyClauses.size() == 1) {
                        this.singleClause = true;
                    }
                    ArrayList<ProvaRule> tempClauses = new ArrayList<ProvaRule>(keyClauses);
                    this.iterator = tempClauses.iterator();
                }
                return;
            }
        }
        if ((clauses = this.predicate.getClauseSet().getClauses()).size() == 1) {
            this.iterator = clauses.iterator();
            this.singleClause = true;
            return;
        }
        this.iterator = clauses.iterator();
    }

    @Override
    public void updateMetadataGoal() {
        ProvaObject[] fixed = this.goal.getTerms().getFixed();
        String symbol = (String)((ProvaConstant)fixed[0]).getObject();
        ProvaList terms = (ProvaList)fixed[1];
        Map<String, List<Object>> m = this.goal.getMetadata();
        this.meta = new ArrayList<ProvaList>();
        for (int i = 2; i < fixed.length; ++i) {
            this.meta.add((ProvaList)fixed[i]);
        }
        this.goal = this.predicate.getKnowledgeBase().generateLiteral(symbol, terms, this.goal.getGuard());
        this.goal.addMetadata(m);
        this.query.getBody()[this.query.getOffset()] = this.goal;
        this.predicate = this.goal.getPredicate();
    }

    @Override
    public ProvaRule next() {
        if (this.extraAnswers != null) {
            ProvaPredicateImpl pred = new ProvaPredicateImpl(this.predicate.getSymbol(), this.predicate.getArity(), this.predicate.getKnowledgeBase());
            for (ProvaList answer : this.extraAnswers) {
                ProvaList ls = ProvaListImpl.create(answer.getFixed());
                ProvaLiteralImpl lit = new ProvaLiteralImpl(pred, ls);
                ProvaRule clause = ProvaRuleImpl.createVirtualRule(1L, lit, null);
                pred.addClause(clause);
            }
            this.iterator = pred.getClauseSet().getClauses().iterator();
            this.extraAnswers = null;
        } else if (this.iterator == null) {
            this.createIterator();
        }
        try {
            ProvaRule nextRule;
            ProvaRule provaRule = nextRule = this.iterator != null && this.iterator.hasNext() ? this.iterator.next() : null;
            if (nextRule != null && !this.iterator.hasNext()) {
                this.singleClause = true;
            }
            return nextRule;
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            return null;
        }
    }

    @Override
    public ProvaUnification nextUnification(ProvaKnowledgeBase kb) {
        if (this.cut) {
            return null;
        }
        this.rule = null;
        this.singleClause = false;
        this.rule = this.next();
        while (this.rule != null && this.rule.isRemoved()) {
            this.rule = this.next();
        }
        if (this.rule == null) {
            if (this.outerAnswers != null) {
                ProvaPredicateImpl pred = new ProvaPredicateImpl(this.predicate.getSymbol(), this.predicate.getArity(), this.predicate.getKnowledgeBase());
                for (ProvaList answer : this.outerAnswers) {
                    ProvaList ls = ProvaListImpl.create(answer.getFixed());
                    ProvaLiteralImpl lit = new ProvaLiteralImpl(pred, ls);
                    ProvaRule clause = ProvaRuleImpl.createVirtualRule(1L, lit, null);
                    pred.addClause(clause);
                }
                this.iterator = pred.getClauseSet().getClauses().iterator();
                this.outerAnswers.clear();
                ProvaRule provaRule = this.rule = this.iterator.hasNext() ? this.iterator.next() : null;
            }
            if (this.rule == null) {
                this.goal.markCompletion();
                return null;
            }
        }
        ProvaRule clone = this.query.cloneRule(!this.singleClause);
        ProvaUnificationImpl unification = new ProvaUnificationImpl(clone, this.rule);
        unification.setMeta(this.meta);
        return unification;
    }

    @Override
    public ProvaLiteral getGoal() {
        return this.goal;
    }

    @Override
    public ProvaRule getQuery() {
        return this.query;
    }

    public ProvaPredicate getPredicate() {
        return this.predicate;
    }

    public void setIterator(Iterator<ProvaRule> iterator) {
        this.iterator = iterator;
    }

    @Override
    public Iterator<ProvaRule> getIterator() {
        return this.iterator;
    }

    public List<ProvaVariable> getVariables() {
        return this.variables;
    }

    @Override
    public void setCut(boolean cut) {
        this.cut = cut;
    }

    @Override
    public boolean isCut() {
        return this.cut;
    }

    @Override
    public void setGoal(ProvaLiteral goal) {
        this.goal = goal;
    }

    @Override
    public boolean hasNext() {
        return this.iterator != null && this.iterator.hasNext();
    }

    @Override
    public void addAnswer(ProvaList terms) {
        if (this.extraAnswers == null) {
            this.extraAnswers = new ArrayList<ProvaList>();
        }
        this.extraAnswers.add(terms);
    }

    @Override
    public void addOuterAnswer(ProvaList terms) {
        if (this.outerAnswers == null) {
            this.outerAnswers = new ArrayList<ProvaList>();
        }
        this.outerAnswers.add(terms);
    }

    @Override
    public boolean isSingleClause() {
        return this.singleClause || this.rule != null && this.rule.isCut();
    }

    @Override
    public void removeTarget() {
        this.rule.setRemoved();
        this.iterator.remove();
    }

    @Override
    public Object lookupMetadata(String reference, List<ProvaVariable> variables) {
        if (this.meta == null) {
            return reference;
        }
        for (ProvaList p : this.meta) {
            ProvaList pair = (ProvaList)p.cloneWithVariables(variables);
            String name = pair.getFixed()[0].toString();
            if (!name.equals(reference)) continue;
            ProvaObject data = pair.getFixed()[1];
            return data instanceof ProvaConstant ? ((ProvaConstant)data).getObject() : ProvaVariableImpl.create(name, data);
        }
        return reference;
    }

    @Override
    public void setLastMatch(ProvaRule lastMatch) {
        this.lastMatch = lastMatch;
    }

    @Override
    public ProvaRule getLastMatch() {
        return this.lastMatch;
    }

    @Override
    public void updateGround() {
        this.goal.updateGround(this.variables);
    }
}

