/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2;

import java.util.ArrayList;
import java.util.List;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaPredicate;
import org.provarules.kernel2.ProvaUnification;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaLiteralImpl;
import org.provarules.reference2.ProvaVariableImpl;

public class ProvaGuardedLiteralImpl
extends ProvaLiteralImpl
implements ProvaLiteral {
    private static final long serialVersionUID = -3967549869751321929L;
    private List<ProvaLiteral> guard;

    public ProvaGuardedLiteralImpl(ProvaPredicate pred, ProvaList terms, List<ProvaLiteral> guard) {
        super(pred, terms);
        this.guard = guard;
    }

    @Override
    public List<ProvaLiteral> getGuard() {
        return this.guard;
    }

    @Override
    public int collectVariables(long ruleId, List<ProvaVariable> variables) {
        if (this.ground || this.terms == null) {
            return -1;
        }
        this.ground &= this.terms.collectVariables(ruleId, variables) < 0;
        for (ProvaLiteral g : this.guard) {
            this.ground &= g.collectVariables(ruleId, variables) < 0;
        }
        return this.ground ? -1 : 0;
    }

    @Override
    public void substituteVariables(ProvaVariablePtr[] varsMap) {
        super.substituteVariables(varsMap);
        for (ProvaLiteral g : this.guard) {
            g.substituteVariables(varsMap);
        }
    }

    @Override
    public ProvaLiteral cloneWithBoundVariables(ProvaUnification unification, List<ProvaVariable> variables, List<Boolean> isConstant) {
        ProvaGuardedLiteralImpl ret = (ProvaGuardedLiteralImpl)this.cloneWithBoundVariables(variables, isConstant);
        ArrayList<ProvaLiteral> newGuard = new ArrayList<ProvaLiteral>(this.guard.size());
        for (ProvaLiteral g : this.guard) {
            newGuard.add(g.cloneWithBoundVariables(unification, variables, isConstant));
        }
        ret.guard = newGuard;
        if (ret.getMetadata() != null) {
            this.copyMetadata(unification, ret);
        }
        return ret;
    }

    @Override
    public ProvaObject cloneWithBoundVariables(List<ProvaVariable> variables, List<Boolean> isConstant) {
        if (this.terms == null) {
            return this;
        }
        ProvaList newTerms = (ProvaList)this.terms.cloneWithBoundVariables(variables, isConstant);
        ProvaGuardedLiteralImpl newLit = new ProvaGuardedLiteralImpl(this.predicate, newTerms, null);
        newLit.ground = this.ground;
        newLit.line = this.line;
        newLit.sourceCode = this.sourceCode;
        newLit.metadata = this.metadata;
        return newLit;
    }

    @Override
    public ProvaLiteral rebuild(ProvaUnification unification) {
        if (this.ground || this.terms == null) {
            return this;
        }
        ProvaList newTerms = this.terms.rebuild(unification);
        ArrayList<ProvaLiteral> newGuard = new ArrayList<ProvaLiteral>(this.guard.size());
        for (ProvaLiteral g : this.guard) {
            newGuard.add(g.rebuild(unification));
        }
        ProvaGuardedLiteralImpl ret = new ProvaGuardedLiteralImpl(this.predicate, newTerms, newGuard);
        ret.sourceCode = this.sourceCode;
        ret.line = this.line;
        if (this.metadata != null) {
            this.copyMetadata(unification, ret);
        }
        return ret;
    }

    @Override
    public ProvaLiteral rebuildSource(ProvaUnification unification) {
        if (this.ground) {
            return this;
        }
        ArrayList<ProvaLiteral> newGuard = new ArrayList<ProvaLiteral>(this.guard.size());
        for (ProvaLiteral g : this.guard) {
            newGuard.add(g.rebuildSource(unification));
        }
        ProvaList newTerms = this.terms;
        if (this.terms != null) {
            newTerms = this.terms.rebuildSource(unification);
        }
        return new ProvaGuardedLiteralImpl(this.predicate, newTerms, newGuard);
    }

    @Override
    public ProvaObject cloneWithVariables(List<ProvaVariable> variables) {
        if (this.predicate.getSymbol().equals("cut")) {
            ProvaVariable any1 = ProvaVariableImpl.create();
            ProvaList lany1 = ProvaListImpl.create(new ProvaObject[]{any1});
            return new ProvaLiteralImpl(this.predicate, lany1);
        }
        ProvaList newTerms = this.terms;
        if (this.terms != null) {
            newTerms = (ProvaList)this.terms.cloneWithVariables(variables);
        }
        ArrayList<ProvaLiteral> newGuard = new ArrayList<ProvaLiteral>(this.guard.size());
        for (ProvaLiteral g : this.guard) {
            newGuard.add((ProvaLiteral)g.cloneWithVariables(variables));
        }
        ProvaGuardedLiteralImpl newLit = new ProvaGuardedLiteralImpl(this.predicate, newTerms, newGuard);
        newLit.ground = this.ground;
        newLit.line = this.line;
        newLit.sourceCode = this.sourceCode;
        newLit.metadata = this.metadata;
        return newLit;
    }

    @Override
    public ProvaObject cloneWithVariables(long ruleId, List<ProvaVariable> variables) {
        if (this.predicate.getSymbol().equals("cut")) {
            ProvaVariable any1 = ProvaVariableImpl.create();
            ProvaList lany1 = ProvaListImpl.create(new ProvaObject[]{any1});
            return new ProvaLiteralImpl(this.predicate, lany1);
        }
        ProvaList newTerms = this.terms;
        if (this.terms != null) {
            newTerms = (ProvaList)this.terms.cloneWithVariables(ruleId, variables);
        }
        ArrayList<ProvaLiteral> newGuard = new ArrayList<ProvaLiteral>(this.guard.size());
        for (ProvaLiteral g : this.guard) {
            newGuard.add((ProvaLiteral)g.cloneWithVariables(ruleId, variables));
        }
        ProvaGuardedLiteralImpl newLit = new ProvaGuardedLiteralImpl(this.predicate, newTerms, newGuard);
        newLit.ground = this.ground;
        newLit.line = this.line;
        newLit.sourceCode = this.sourceCode;
        newLit.metadata = this.metadata;
        return newLit;
    }

    @Override
    public String toString() {
        String sb = this.predicate.getSymbol() + '(' + this.terms + ") [" + this.guard + ']';
        return sb;
    }
}

