/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaPredicate;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaUnification;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.kernel2.cache.ProvaCacheState;
import org.provarules.kernel2.cache.ProvaLocalAnswers;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaVariableImpl;

public class ProvaLiteralImpl
implements ProvaLiteral {
    private static final long serialVersionUID = 9180554897688659494L;
    protected final ProvaPredicate predicate;
    protected ProvaList terms;
    protected boolean ground = false;
    protected String sourceCode;
    protected Map<String, List<Object>> metadata;
    protected int line;
    public static ThreadLocal<Map<Object, ProvaObject>> tlVars = new ThreadLocal();

    public ProvaLiteralImpl(ProvaPredicate predicate, ProvaList terms) {
        this.predicate = predicate;
        this.terms = terms;
    }

    public ProvaLiteralImpl(ProvaPredicate predicate, ProvaList terms, Map<String, List<Object>> metadata) {
        this.predicate = predicate;
        this.terms = terms;
        this.metadata = metadata;
    }

    @Override
    public ProvaPredicate getPredicate() {
        return this.predicate;
    }

    @Override
    public ProvaList getTerms() {
        return this.terms;
    }

    @Override
    public void setTerms(ProvaList terms) {
        this.terms = terms;
    }

    @Override
    public int collectVariables(long ruleId, List<ProvaVariable> variables) {
        if (this.ground || this.terms == null) {
            return -1;
        }
        int rc = this.terms.collectVariables(ruleId, variables);
        if (rc < 0) {
            this.ground = true;
        }
        return rc;
    }

    @Override
    public ProvaObject getRecursivelyAssigned() {
        return null;
    }

    @Override
    public int computeSize() {
        return 0;
    }

    @Override
    public void substituteVariables(ProvaVariablePtr[] varsMap) {
        if (this.ground) {
            return;
        }
        if (this.terms != null) {
            this.terms.substituteVariables(varsMap);
        }
    }

    @Override
    public boolean unify(ProvaObject target, ProvaUnification unification) {
        ProvaLiteral targetLiteral = (ProvaLiteral)target;
        return this.terms.unify(targetLiteral.getTerms(), unification);
    }

    @Override
    public ProvaLiteral rebuild(ProvaUnification unification) {
        if (this.ground || this.terms == null) {
            return this;
        }
        ProvaList newTerms = this.terms.rebuild(unification);
        ProvaLiteralImpl ret = new ProvaLiteralImpl(this.predicate, newTerms);
        ret.sourceCode = this.sourceCode;
        ret.line = this.line;
        if (this.metadata != null) {
            this.copyMetadata(unification, ret);
        }
        return ret;
    }

    void copyMetadata(ProvaUnification unification, ProvaLiteralImpl ret) {
        ret.metadata = new HashMap<String, List<Object>>(this.metadata);
        for (Map.Entry<String, List<Object>> e : this.metadata.entrySet()) {
            for (int i = 0; i < e.getValue().size(); ++i) {
                Object o = e.getValue().get(i);
                if (!(o instanceof ProvaVariable)) continue;
                Object oo = ((ProvaVariable)o).getAssigned();
                if (!(oo instanceof ProvaVariable)) {
                    oo = o;
                }
                for (int j = 0; j < unification.getTarget().getVariables().size(); ++j) {
                    ProvaVariable var = unification.getTarget().getVariables().get(j);
                    if (var != oo) continue;
                    Map<Object, ProvaObject> vars = tlVars.get();
                    if (vars == null) {
                        vars = new HashMap<Object, ProvaObject>();
                        tlVars.set(vars);
                    }
                    vars.put(((ProvaVariable)o).getName(), unification.getTargetVariables().get(j).getAssigned());
                }
            }
        }
    }

    @Override
    public ProvaLiteral rebuildSource(ProvaUnification unification) {
        if (this.ground || this.terms == null) {
            return this;
        }
        ProvaList newTerms = this.terms.rebuildSource(unification);
        return new ProvaLiteralImpl(this.predicate, newTerms, this.metadata);
    }

    public String toString() {
        return this.predicate.getSymbol() + '(' + this.terms + ')';
    }

    @Override
    public void addClause(ProvaRule clause) {
        this.predicate.addClause(clause);
    }

    @Override
    public void addClauseA(ProvaRule clause) {
        this.predicate.addClauseA(clause);
    }

    @Override
    public boolean isGround() {
        return this.ground;
    }

    @Override
    public void setGoal(ProvaGoal goal) {
    }

    @Override
    public ProvaCacheState getCacheState() {
        return null;
    }

    @Override
    public ProvaLocalAnswers getAnswers() {
        return null;
    }

    @Override
    public void markCompletion() {
    }

    @Override
    public ProvaGoal getGoal() {
        return null;
    }

    @Override
    public String toString(List<ProvaVariable> variables) {
        return this.toString();
    }

    @Override
    public ProvaLiteral cloneWithBoundVariables(ProvaUnification unification, List<ProvaVariable> variables, List<Boolean> isConstant) {
        ProvaLiteralImpl ret = (ProvaLiteralImpl)this.cloneWithBoundVariables(variables, isConstant);
        if (ret.getMetadata() != null) {
            this.copyMetadata(unification, ret);
        }
        return ret;
    }

    @Override
    public ProvaObject cloneWithBoundVariables(List<ProvaVariable> variables, List<Boolean> isConstant) {
        if (this.terms == null) {
            return this;
        }
        ProvaList newTerms = (ProvaList)this.terms.cloneWithBoundVariables(variables, isConstant);
        ProvaLiteralImpl newLit = new ProvaLiteralImpl(this.predicate, newTerms);
        newLit.ground = this.ground;
        newLit.line = this.line;
        newLit.sourceCode = this.sourceCode;
        newLit.metadata = this.metadata;
        return newLit;
    }

    @Override
    public ProvaObject cloneWithVariables(List<ProvaVariable> variables) {
        if (this.terms == null) {
            return this;
        }
        if (this.predicate.getSymbol().equals("cut")) {
            ProvaVariable any1 = ProvaVariableImpl.create();
            ProvaList lany1 = ProvaListImpl.create(new ProvaObject[]{any1});
            return new ProvaLiteralImpl(this.predicate, lany1);
        }
        ProvaList newTerms = (ProvaList)this.terms.cloneWithVariables(variables);
        ProvaLiteralImpl newLit = new ProvaLiteralImpl(this.predicate, newTerms);
        newLit.ground = this.ground;
        newLit.line = this.line;
        newLit.sourceCode = this.sourceCode;
        newLit.metadata = this.metadata;
        return newLit;
    }

    @Override
    public ProvaObject cloneWithVariables(long ruleId, List<ProvaVariable> variables) {
        if (this.terms == null) {
            return this;
        }
        if (this.predicate.getSymbol().equals("cut")) {
            ProvaVariable any1 = ProvaVariableImpl.create();
            ProvaList lany1 = ProvaListImpl.create(new ProvaObject[]{any1});
            return new ProvaLiteralImpl(this.predicate, lany1);
        }
        ProvaList newTerms = (ProvaList)this.terms.cloneWithVariables(ruleId, variables);
        ProvaLiteralImpl newLit = new ProvaLiteralImpl(this.predicate, newTerms);
        newLit.ground = this.ground;
        newLit.line = this.line;
        newLit.sourceCode = this.sourceCode;
        newLit.metadata = this.metadata;
        return newLit;
    }

    @Override
    public String getSourceCode() {
        if (this.sourceCode == null) {
            this.sourceCode = this.toString();
        }
        return this.sourceCode;
    }

    @Override
    public void setSourceCode(String text) {
        this.sourceCode = text;
    }

    @Override
    public void setMetadata(String property, List<Object> value) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, List<Object>>();
        }
        this.metadata.put(property, value);
    }

    @Override
    public List<Object> getMetadata(String property) {
        return this.metadata == null ? null : this.metadata.get(property);
    }

    @Override
    public List<ProvaObject> addMetadata(Map<String, List<Object>> m) {
        if (m == null) {
            return null;
        }
        if (this.metadata == null) {
            this.metadata = new HashMap<String, List<Object>>();
        }
        this.metadata.putAll(m);
        ArrayList<ProvaObject> metaVariables = new ArrayList<ProvaObject>();
        for (Map.Entry<String, List<Object>> e : m.entrySet()) {
            for (Object value : e.getValue()) {
                String str;
                if (!(value instanceof String) || (str = (String)value).length() == 0 || !Character.isUpperCase(str.charAt(0))) continue;
                metaVariables.add(ProvaListImpl.create(new ProvaObject[]{ProvaConstantImpl.create(str), ProvaVariableImpl.create(str)}));
            }
        }
        return metaVariables.size() == 0 ? null : metaVariables;
    }

    @Override
    public Map<String, List<Object>> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setLine(int line) {
        this.line = line;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public List<ProvaLiteral> getGuard() {
        return null;
    }

    @Override
    public Object computeIfExpression() {
        return this;
    }

    @Override
    public ProvaObject computeProvaIfExpression() {
        return this;
    }

    @Override
    public void setGround(boolean ground) {
        this.ground = ground;
        if (ground && this.terms != null) {
            this.terms.setGround(true);
        }
    }

    @Override
    public boolean updateGround(List<ProvaVariable> variables) {
        this.ground = this.terms.updateGround(variables);
        return this.ground;
    }
}

