/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaBuiltin;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaPredicate;
import org.provarules.kernel2.ProvaResolutionInferenceEngine;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaUnification;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaDerivationNodeImpl;
import org.provarules.reference2.ProvaDerivationStepCounter;
import org.provarules.reference2.ProvaGoalImpl;
import org.provarules.reference2.builtins.ProvaFailImpl;
import org.provarules.reference2.messaging.ProvaDelayedCommand;
import org.provarules.reference2.messaging.ProvaMessengerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaResolutionInferenceEngineImpl
implements ProvaResolutionInferenceEngine {
    private static final Logger log = LoggerFactory.getLogger((String)"prova");
    private ProvaKnowledgeBase kb;
    private Stack<ProvaDerivationNode> tabledNodes;
    private ProvaDerivationNode node;
    private ProvaDerivationStepCounter counter;
    private ProvaReagent prova;
    public static ThreadLocal<List<ProvaDelayedCommand>> delayedCommands = new ThreadLocal();

    public ProvaResolutionInferenceEngineImpl(ProvaKnowledgeBase kb, ProvaRule query) {
        this.kb = kb;
        this.tabledNodes = new Stack();
        this.counter = new ProvaDerivationStepCounter();
        this.node = new ProvaDerivationNodeImpl();
        this.node.setFailed(true);
        this.node.setId(this.counter.next());
        this.node.setCut(false);
        this.node.setQuery(query);
        this.node.setCurrentGoal(new ProvaGoalImpl(query));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProvaDerivationNode run() {
        List<ProvaDelayedCommand> delayed0 = delayedCommands.get();
        try {
            if (delayed0 == null) {
                ArrayList delayed = new ArrayList();
                delayedCommands.set(delayed);
            }
            ProvaDerivationNode provaDerivationNode = this._run();
            return provaDerivationNode;
        }
        finally {
            if (delayedCommands != null) {
                List<ProvaDelayedCommand> delayed = delayedCommands.get();
                Iterator<ProvaDelayedCommand> iter = delayed.iterator();
                while (iter.hasNext()) {
                    ProvaDelayedCommand message = iter.next();
                    iter.remove();
                    message.process(this.prova);
                }
                if (delayed0 == null) {
                    delayedCommands.remove();
                }
            }
            ProvaMessengerImpl.cleanupThreadlocals();
        }
    }

    private ProvaDerivationNode _run() {
        ArrayList<ProvaLiteral> newLiterals = new ArrayList<ProvaLiteral>(100);
        this.tabledNodes.push(this.node);
        while (!this.tabledNodes.empty()) {
            ProvaUnification unification;
            boolean isCut;
            ProvaGoal goal;
            this.node = this.tabledNodes.pop();
            ProvaRule query = this.node.getQuery();
            if (log.isDebugEnabled()) {
                log.debug("{}", (Object)query);
            }
            if ((goal = this.node.getCurrentGoal()) == null) {
                this.node.setFailed(true);
                return this.node;
            }
            ProvaLiteral goalLiteral = goal.getGoal();
            ProvaPredicate predicate = goalLiteral.getPredicate();
            if (predicate instanceof ProvaFailImpl) {
                if (this.node.getParent() == null) {
                    this.node.setFailed(true);
                    return this.node;
                }
                this.node = this.node.getParent();
                this.tabledNodes.push(this.node);
                continue;
            }
            String symbol = predicate.getSymbol();
            if (symbol.equals("metadata")) {
                goal.updateMetadataGoal();
                goalLiteral = goal.getGoal();
                predicate = goalLiteral.getPredicate();
            }
            if (predicate instanceof ProvaBuiltin) {
                ProvaBuiltin builtin = (ProvaBuiltin)predicate;
                newLiterals.clear();
                boolean result = builtin.process_(this.prova, this.node, goal, newLiterals, query);
                if (!result) {
                    this.node = this.node.getParent();
                } else {
                    int size = newLiterals.size();
                    if (size == 1) {
                        query.replaceTopBodyLiteral(newLiterals);
                        goal.update();
                    } else if (size > 1) {
                        query.replaceTopBodyLiteral(newLiterals);
                        this.node.setCurrentGoal(new ProvaGoalImpl(query));
                    } else {
                        boolean fail = query.advance();
                        if (fail) {
                            if (this.node.getParent() == null) {
                                this.node.setFailed(true);
                                return this.node;
                            }
                            this.node = this.node.getParent();
                            this.tabledNodes.push(this.node);
                            continue;
                        }
                        goal.update();
                    }
                }
                if (this.node == null) continue;
                this.tabledNodes.push(this.node);
                continue;
            }
            if ("cut".equals(symbol) && (isCut = this.checkCut(this.node, goal))) {
                this.tabledNodes.push(this.node);
                continue;
            }
            ProvaDerivationNodeImpl newNode = null;
            goal.updateGround();
            while ((unification = goal.nextUnification(this.kb)) != null) {
                boolean result = unification.unify();
                if (!result) continue;
                if (log.isDebugEnabled()) {
                    log.debug(">>> [" + unification.getTarget().getMetadata() + ']' + unification.getTarget().getSourceCode());
                }
                ProvaRule newQuery = unification.generateQuery(symbol, this.kb, query, this.node);
                if (goal.isSingleClause()) {
                    this.node.setCurrentGoal(new ProvaGoalImpl(newQuery));
                    this.node.setQuery(newQuery);
                    break;
                }
                newNode = new ProvaDerivationNodeImpl();
                newNode.setQuery(newQuery);
                newNode.setParent(this.node);
                newNode.setId(this.counter.next());
                newNode.setCut(false);
                newNode.setCurrentGoal(new ProvaGoalImpl(newQuery));
                this.tabledNodes.push(newNode);
                break;
            }
            if (goal.isSingleClause()) {
                this.tabledNodes.push(this.node);
                continue;
            }
            if (newNode != null) continue;
            this.node = this.node.getParent();
            if (this.node == null) continue;
            this.tabledNodes.push(this.node);
        }
        return null;
    }

    private boolean checkCut(ProvaDerivationNode node, ProvaGoal goal) {
        boolean rc = false;
        ProvaRule query = goal.getQuery();
        ProvaLiteral top = query.getTop();
        String symbol = top.getPredicate().getSymbol();
        while ("cut".equals(symbol)) {
            rc = true;
            ProvaObject ref = top.getTerms().getFixed()[0];
            if (ref instanceof ProvaVariablePtr) {
                log.error("{}", (Object)ref);
            }
            ProvaDerivationNode cutNode = (ProvaDerivationNode)((ProvaConstant)ref).getObject();
            ProvaGoal cutGoal = cutNode.getCurrentGoal();
            cutGoal.setCut(true);
            cutNode.setCut(true);
            query.advance();
            top = query.getTop();
            goal.setGoal(top);
            node.setParent(cutNode.getParent());
            if (top == null) break;
            symbol = top.getPredicate().getSymbol();
        }
        if (rc) {
            node.setCurrentGoal(new ProvaGoalImpl(query));
        }
        return rc;
    }

    public void setKb(ProvaKnowledgeBase kb) {
        this.kb = kb;
    }

    public ProvaKnowledgeBase getKb() {
        return this.kb;
    }

    @Override
    public void setReagent(ProvaReagent prova) {
        this.prova = prova;
    }
}

