/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaRuleSet;
import org.provarules.kernel2.ProvaUnification;
import org.provarules.reference2.ProvaGoalImpl;
import org.provarules.reference2.ProvaRuleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaRuleSetImpl
implements ProvaRuleSet {
    private static final Logger log = LoggerFactory.getLogger((String)"prova");
    private final String symbol;
    private final int arity;
    private final List<ProvaRule> clauses = new ArrayList<ProvaRule>();
    private final ConcurrentMap<Object, List<ProvaRule>> firstArgMap = new ConcurrentHashMap<Object, List<ProvaRule>>();
    private final ConcurrentMap<String, List<ProvaRule>> srcMap = new ConcurrentHashMap<String, List<ProvaRule>>();
    private ConcurrentMap<Long, ProvaRule> temporalRuleMap;

    public ProvaRuleSetImpl(String symbol) {
        this.symbol = symbol;
        this.arity = -1;
    }

    ProvaRuleSetImpl(String symbol, int arity) {
        this.symbol = symbol;
        this.arity = arity;
    }

    public void setClauses(List<ProvaRule> clauses) {
        this.clauses.addAll(clauses);
    }

    @Override
    public List<ProvaRule> getClauses() {
        return this.clauses;
    }

    @Override
    public synchronized List<ProvaRule> getClauses(Object key, ProvaObject[] source) {
        ProvaObject[] target;
        ProvaRule next;
        List bound = (List)this.firstArgMap.get(key);
        List free = (List)this.firstArgMap.get("@");
        if (bound == null) {
            return free;
        }
        if (free == null) {
            return bound;
        }
        int boundSize = bound.size();
        int freeSize = free.size();
        ArrayList<ProvaRule> merged = new ArrayList<ProvaRule>(boundSize + freeSize);
        int i1 = 0;
        int i2 = 0;
        while (i1 < boundSize && i2 < freeSize) {
            next = ((ProvaRule)bound.get(i1)).getAbsRuleId() > ((ProvaRule)free.get(i2)).getAbsRuleId() ? (ProvaRule)free.get(i2++) : (ProvaRule)bound.get(i1++);
            target = next.getHead().getTerms().getFixed();
            if (!this.preFilter(source, target)) continue;
            merged.add(next);
        }
        while (i1 < boundSize) {
            if (!this.preFilter(source, target = (next = (ProvaRule)bound.get(i1++)).getHead().getTerms().getFixed())) continue;
            merged.add(next);
        }
        while (i2 < freeSize) {
            if (!this.preFilter(source, target = (next = (ProvaRule)free.get(i2++)).getHead().getTerms().getFixed())) continue;
            merged.add(next);
        }
        return merged;
    }

    private boolean preFilter(ProvaObject[] source, ProvaObject[] target) {
        for (int i = 1; i < source.length; ++i) {
            if (!(source[i] instanceof ProvaConstant) || !(target[i] instanceof ProvaConstant) || ((ProvaConstant)source[i]).matched((ProvaConstant)target[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void removeClauses(Object key) {
        if (key instanceof Long && (Long)key < 0L) {
            ProvaRule rule = (ProvaRule)this.temporalRuleMap.remove(-((Long)key).longValue());
            rule.setRemoved();
            this.clauses.remove(rule);
            return;
        }
        List bound = (List)this.firstArgMap.get(key);
        for (ProvaRule rule : bound) {
            rule.setRemoved();
            this.clauses.remove(rule);
        }
    }

    @Override
    public synchronized void removeTemporalClause(long key) {
        ProvaRule rule = (ProvaRule)this.temporalRuleMap.remove(-key);
        if (rule == null) {
            return;
        }
        rule.setRemoved();
        if (!"@".equals(rule.getFirstArg())) {
            List children = (List)this.firstArgMap.get(rule.getFirstArg());
            children.remove(rule);
        }
        this.clauses.remove(rule);
    }

    @Override
    public boolean removeClausesByMatch(ProvaKnowledgeBase kb, ProvaObject[] data) {
        ProvaUnification unification;
        ProvaLiteral goalLit = kb.generateLiteral(data);
        ProvaRule query = kb.generateGoal(new ProvaLiteral[]{goalLit});
        ProvaGoalImpl goal = new ProvaGoalImpl(query);
        while ((unification = goal.nextUnification(kb)) != null) {
            boolean result = unification.unify();
            if (!result || !unification.targetUnchanged()) continue;
            goal.removeTarget();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAllClausesByMatch(ProvaKnowledgeBase kb, ProvaObject[] data) {
        ProvaUnification unification;
        ProvaLiteral goalLit = kb.generateLiteral(data);
        ProvaRule query = kb.generateGoal(new ProvaLiteral[]{goalLit});
        ProvaGoalImpl goal = new ProvaGoalImpl(query);
        while ((unification = goal.nextUnification(kb)) != null) {
            boolean result = unification.unify();
            if (!result || !unification.targetUnchanged()) continue;
            goal.removeTarget();
        }
        return true;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public synchronized void add(ProvaRule clause) {
        Object firstArg = clause.getFirstArg();
        if (firstArg != null) {
            List rules = this.firstArgMap.computeIfAbsent(firstArg, k -> new ArrayList());
            rules.add(clause);
        }
        if (clause.getRuleId() < 0L) {
            if (this.temporalRuleMap == null) {
                this.temporalRuleMap = new ConcurrentHashMap<Long, ProvaRule>();
            }
            this.temporalRuleMap.put(clause.getRuleId(), clause);
        }
        if (!this.clauses.contains(clause)) {
            this.clauses.add(clause);
        }
    }

    @Override
    public synchronized void addA(ProvaRule clause) {
        Object firstArg = clause.getFirstArg();
        if (firstArg != null) {
            List rules = this.firstArgMap.computeIfAbsent(firstArg, k -> new ArrayList());
            rules.add(0, clause);
        }
        if (!this.clauses.contains(clause)) {
            this.clauses.add(0, clause);
        }
    }

    @Override
    public Object size() {
        return this.clauses.size();
    }

    @Override
    public synchronized void addAll(ProvaRuleSet ruleSet) {
        for (ProvaRule clause : ruleSet.getClauses()) {
            this.add(clause);
        }
    }

    @Override
    public synchronized void addRuleToSrc(ProvaRuleImpl rule, String src) {
        List rules = this.srcMap.computeIfAbsent(src, k -> new ArrayList());
        rules.add(rule);
    }

    @Override
    public synchronized void removeClausesBySrc(String src) {
        List rules = (List)this.srcMap.remove(src);
        if (rules == null) {
            return;
        }
        for (ProvaRule rule : rules) {
            rule.setRemoved();
            this.clauses.remove(rule);
        }
    }

    @Override
    public ProvaUnification nextMatch(ProvaKnowledgeBase kb, ProvaGoal goal) {
        ProvaUnification unification;
        while ((unification = goal.nextUnification(kb)) != null) {
            boolean result = unification.unify();
            if (!result) continue;
            return unification;
        }
        return null;
    }
}

