/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaUnification;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaAnyImpl;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaTermImpl;

public class ProvaVariableImpl
extends ProvaTermImpl
implements ProvaVariable {
    private static final long serialVersionUID = 7501612596168443208L;
    private Object name;
    private Class<?> type;
    private ProvaObject assigned;
    private int index;
    private long ruleId;
    private static AtomicLong incName = new AtomicLong(0L);

    public static ProvaVariable create() {
        return new ProvaVariableImpl();
    }

    public static ProvaVariable create(String name) {
        return new ProvaVariableImpl(name);
    }

    public static ProvaVariable create(String name, Class<?> type) {
        return new ProvaVariableImpl(name, type);
    }

    public static ProvaVariableImpl create(String name, ProvaObject assigned) {
        return new ProvaVariableImpl(name, assigned);
    }

    private ProvaVariableImpl() {
        this.name = incName.incrementAndGet();
        this.type = Object.class;
        this.index = -1;
    }

    private ProvaVariableImpl(String name) {
        this.name = "_".equals(name) ? Long.valueOf(incName.incrementAndGet()) : name;
        this.type = Object.class;
        this.index = -1;
    }

    private ProvaVariableImpl(String name, Class<?> type) {
        this.name = name;
        this.type = type;
        this.index = -1;
    }

    private ProvaVariableImpl(Class<?> type, ProvaObject assigned, int index, long ruleId) {
        this.name = incName.incrementAndGet();
        this.type = type;
        this.assigned = assigned;
        this.index = index;
        this.ruleId = ruleId;
    }

    private ProvaVariableImpl(String name, ProvaObject assigned) {
        this.name = name;
        this.assigned = assigned;
        this.type = Object.class;
        this.index = -1;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getName() {
        return this.name;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public void setAssigned(ProvaObject assigned) {
        this.assigned = assigned;
    }

    @Override
    public ProvaObject getAssigned() {
        return this.assigned;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public ProvaObject getRecursivelyAssigned() {
        if (this.assigned instanceof ProvaConstant) {
            return this.assigned;
        }
        if (this.assigned == this) {
            this.assigned = null;
            return this;
        }
        if (this.assigned == null) {
            return this;
        }
        ProvaObject recursivelyAssigned = this.assigned.getRecursivelyAssigned();
        if (this.assigned != recursivelyAssigned) {
            this.assigned = recursivelyAssigned;
        }
        return recursivelyAssigned;
    }

    @Override
    public int collectVariables(long ruleId, List<ProvaVariable> variables) {
        if (this.assigned != null) {
            this.assigned.collectVariables(ruleId, variables);
            return -1;
        }
        int foundIndex = variables.indexOf(this);
        if (foundIndex != -1) {
            this.index = foundIndex;
            return this.index;
        }
        this.index = variables.size();
        variables.add(this);
        return this.index;
    }

    @Override
    public int computeSize() {
        if (this.assigned != null) {
            return this.assigned.computeSize();
        }
        return -1;
    }

    @Override
    public ProvaVariable clone() {
        return new ProvaVariableImpl(this.type, this.assigned, this.index, this.ruleId);
    }

    @Override
    public ProvaVariable clone(long ruleId) {
        return new ProvaVariableImpl(this.type, this.assigned, this.index, ruleId);
    }

    @Override
    public boolean unify(ProvaObject target, ProvaUnification unification) {
        if (target == null) {
            this.assigned = ProvaListImpl.emptyRList;
            return true;
        }
        if (target instanceof ProvaVariable) {
            Class<?> targetType = ((ProvaVariable)target).getType();
            if (targetType.isAssignableFrom(this.type)) {
                ((ProvaVariable)target).setAssigned(this);
                return true;
            }
            if (this.type.isAssignableFrom(targetType)) {
                this.assigned = target;
                return true;
            }
            return false;
        }
        if (this.type != Object.class && target instanceof ProvaConstant) {
            if (target instanceof ProvaAnyImpl) {
                return true;
            }
            if (!this.type.isInstance(((ProvaConstant)target).getObject())) {
                return false;
            }
        }
        this.assigned = target;
        return true;
    }

    @Override
    public void setRuleId(long ruleId) {
        this.ruleId = ruleId;
    }

    @Override
    public long getRuleId() {
        return this.ruleId;
    }

    public String toString() {
        if (this.assigned == null) {
            String strName;
            StringBuilder sb = new StringBuilder();
            if (this.type != Object.class) {
                sb.append(this.type.getCanonicalName());
                sb.append('.');
            }
            if ((strName = this.name.toString()).length() != 0 && Character.isDigit(strName.charAt(0))) {
                sb.append("<");
                sb.append(this.name);
                sb.append('>');
            } else {
                sb.append(this.name);
            }
            return sb.toString();
        }
        return this.getRecursivelyAssigned().toString();
    }

    @Override
    public void substituteVariables(ProvaVariablePtr[] varsMap) {
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProvaVariableImpl)) {
            return false;
        }
        ProvaVariableImpl var = (ProvaVariableImpl)o;
        return var.name.equals(this.name) && var.type == this.type;
    }

    @Override
    public boolean isGround() {
        return false;
    }

    @Override
    public String toString(List<ProvaVariable> variables) {
        return this.toString();
    }

    @Override
    public ProvaObject cloneWithBoundVariables(List<ProvaVariable> variables, List<Boolean> isConstant) {
        if (this.assigned != null) {
            return this.assigned;
        }
        return this;
    }

    @Override
    public ProvaObject cloneWithVariables(List<ProvaVariable> variables) {
        if (this.assigned != null) {
            return this.assigned;
        }
        return this;
    }

    @Override
    public ProvaObject cloneWithVariables(long ruleId, List<ProvaVariable> variables) {
        if (this.assigned != null) {
            return this.assigned;
        }
        return this;
    }

    @Override
    public Object computeIfExpression() {
        return this;
    }

    @Override
    public ProvaObject computeProvaIfExpression() {
        return this;
    }

    @Override
    public Object compute() {
        return this;
    }

    @Override
    public boolean updateGround(List<ProvaVariable> variables) {
        if (this.assigned != null) {
            return this.assigned.updateGround(variables);
        }
        return false;
    }
}

