/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils.ConstructorUtils;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.ProvaGlobalConstantImpl;
import org.provarules.reference2.builtins.ProvaBuiltinImpl;

public class ProvaConstructorImpl
extends ProvaBuiltinImpl {
    public ProvaConstructorImpl(ProvaKnowledgeBase kb) {
        super(kb, "construct");
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node, ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        block13: {
            ProvaLiteral literal = goal.getGoal();
            List<ProvaVariable> variables = query.getVariables();
            ProvaList terms = (ProvaList)literal.getTerms().cloneWithVariables(variables);
            ProvaObject[] data = terms.getFixed();
            if (data.length != 3) {
                return false;
            }
            if (!(data[0] instanceof ProvaConstant) || !(data[2] instanceof ProvaList)) {
                return false;
            }
            ProvaObject lt = data[1];
            if (!(lt instanceof ProvaVariable) && !(lt instanceof ProvaConstant)) {
                return false;
            }
            ProvaConstant classRef = (ProvaConstant)data[0];
            if (!(classRef.getObject() instanceof Class)) {
                return false;
            }
            Class targetClass = (Class)classRef.getObject();
            ProvaList argsList = (ProvaList)data[2];
            ArrayList<Object> args = new ArrayList<Object>();
            for (ProvaObject argObject : argsList.getFixed()) {
                if (argObject instanceof ProvaVariablePtr) {
                    ProvaVariablePtr varPtr = (ProvaVariablePtr)argObject;
                    argObject = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
                }
                if (argObject instanceof ProvaConstant) {
                    args.add(((ProvaConstant)argObject).getObject());
                    continue;
                }
                if (argObject instanceof ProvaList) {
                    ProvaList list = (ProvaList)argObject;
                    ProvaObject[] os = list.getFixed();
                    Object[] objs = new Object[os.length];
                    for (int i = 0; i < os.length; ++i) {
                        objs[i] = os[i] instanceof ProvaConstant ? ((ProvaConstant)os[i]).getObject() : os[i];
                    }
                    args.add(Arrays.asList(objs));
                    continue;
                }
                args.add(argObject);
            }
            try {
                Object result = ConstructorUtils.invokeConstructor((Class)targetClass, (Object[])args.toArray());
                if (lt instanceof ProvaVariable) {
                    ((ProvaVariable)lt).setAssigned(ProvaConstantImpl.create(result));
                    break block13;
                }
                if (lt instanceof ProvaGlobalConstantImpl) {
                    ((ProvaConstant)lt).setObject(result);
                    break block13;
                }
                return ((ProvaConstant)lt).getObject().equals(result);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }
}

