/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.List;
import org.provarules.agent2.ProvaReagent;
import org.provarules.exchange.ProvaSolution;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.builtins.ProvaBuiltinImpl;

public class ProvaConsultImpl
extends ProvaBuiltinImpl {
    public ProvaConsultImpl(ProvaKnowledgeBase kb) {
        super(kb, "consult");
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node, ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        ProvaLiteral literal = goal.getGoal();
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = (ProvaList)literal.getTerms().cloneWithVariables(variables);
        ProvaObject[] data = terms.getFixed();
        if (data.length != 1) {
            return false;
        }
        ProvaObject source = data[0];
        if (data[0] instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)data[0];
            source = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        if (!(source instanceof ProvaConstant)) {
            return false;
        }
        Object rules = ((ProvaConstant)source).getObject();
        List<ProvaSolution[]> resultSets = null;
        try {
            if (rules instanceof String) {
                resultSets = this.kb.consultSyncInternal(prova, (String)rules, (String)rules, null);
            } else if (rules instanceof BufferedReader) {
                resultSets = this.kb.consultSyncInternal(prova, (BufferedReader)rules, "-1", null);
            } else if (rules instanceof StringBuffer) {
                StringReader sr = new StringReader(((StringBuffer)rules).toString());
                BufferedReader in = new BufferedReader(sr);
                resultSets = this.kb.consultSyncInternal(prova, in, "-1", null);
            }
            return true;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

