/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.util.List;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaGlobalConstantImpl;
import org.provarules.reference2.ProvaLiteralImpl;
import org.provarules.reference2.ProvaPredicateImpl;
import org.provarules.reference2.ProvaRuleImpl;
import org.provarules.reference2.builtins.ProvaBuiltinImpl;

public class ProvaEqualsImpl
extends ProvaBuiltinImpl {
    public ProvaEqualsImpl(ProvaKnowledgeBase kb) {
        super(kb, "equals");
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node, ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        ProvaLiteral literal = goal.getGoal();
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = literal.getTerms();
        ProvaObject[] data = terms.getFixed();
        if (data.length != 2) {
            return false;
        }
        ProvaObject lt = data[0];
        if (lt instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)lt;
            lt = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        if (lt instanceof ProvaVariable) {
            ((ProvaVariable)lt).setAssigned(data[1]);
            return true;
        }
        ProvaObject rhs = data[1];
        if (rhs instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)rhs;
            rhs = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        if (rhs instanceof ProvaVariable) {
            ((ProvaVariable)rhs).setAssigned(data[0]);
            return true;
        }
        if (lt instanceof ProvaConstant) {
            ProvaConstant lhsConstant = (ProvaConstant)lt;
            if (rhs instanceof ProvaConstant) {
                if (lhsConstant instanceof ProvaGlobalConstantImpl) {
                    lhsConstant.setObject(((ProvaConstant)rhs).getObject());
                    return true;
                }
                return lhsConstant.getObject().equals(((ProvaConstant)rhs).getObject());
            }
            return false;
        }
        if (lt instanceof ProvaList && rhs instanceof ProvaList) {
            ProvaPredicateImpl pred = new ProvaPredicateImpl("", 1, this.kb);
            ProvaLiteralImpl lit = new ProvaLiteralImpl(pred, (ProvaList)lt);
            ProvaRule clause = ProvaRuleImpl.createVirtualRule(1L, lit, null);
            pred.addClause(clause);
            ProvaLiteralImpl newLiteral = new ProvaLiteralImpl(pred, (ProvaList)rhs);
            newLiterals.add(newLiteral);
            return true;
        }
        return false;
    }
}

