/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.util.List;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaVariableImpl;
import org.provarules.reference2.builtins.ProvaBuiltinImpl;

public class ProvaLengthImpl
extends ProvaBuiltinImpl {
    public ProvaLengthImpl(ProvaKnowledgeBase kb) {
        super(kb, "length");
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node, ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        ProvaLiteral literal = goal.getGoal();
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = (ProvaList)literal.getTerms().cloneWithVariables(variables);
        ProvaObject[] data = terms.getFixed();
        if (data.length != 2) {
            return false;
        }
        ProvaObject lt = data[0];
        if (lt instanceof ProvaVariable) {
            ProvaObject out = data[1];
            if (!(out instanceof ProvaConstant)) {
                return false;
            }
            Object olen = ((ProvaConstant)out).getObject();
            if (!(olen instanceof Integer)) {
                return false;
            }
            int len = (Integer)olen;
            ProvaObject[] fixed = new ProvaObject[len];
            for (int i = 0; i < len; ++i) {
                fixed[i] = ProvaVariableImpl.create();
            }
            ProvaList newList = ProvaListImpl.create(fixed, null);
            ((ProvaVariable)lt).setAssigned(newList);
            return true;
        }
        if (!(lt instanceof ProvaList)) {
            return false;
        }
        ProvaList list = (ProvaList)lt;
        if (list.getTail() instanceof ProvaVariable) {
            return false;
        }
        ProvaObject out = data[1];
        if (out instanceof ProvaConstant) {
            Object o = ((ProvaConstant)out).getObject();
            if (!(o instanceof Integer)) {
                return false;
            }
            return list.getFixed().length == (Integer)o;
        }
        if (out instanceof ProvaVariable) {
            ((ProvaVariable)out).setAssigned(ProvaConstantImpl.create(list.getFixed().length));
            return true;
        }
        return false;
    }
}

