/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.util.List;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.builtins.ProvaBuiltinImpl;

public class ProvaMathSubtractImpl
extends ProvaBuiltinImpl {
    public ProvaMathSubtractImpl(ProvaKnowledgeBase kb) {
        super(kb, "math_subtract");
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node, ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        ProvaLiteral literal = goal.getGoal();
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = (ProvaList)literal.getTerms().cloneWithVariables(variables);
        ProvaObject[] data = terms.getFixed();
        if (data.length != 3) {
            return false;
        }
        ProvaObject lt = data[0];
        if (lt instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)lt;
            lt = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        if (!(lt instanceof ProvaVariable) && !(lt instanceof ProvaConstant)) {
            return false;
        }
        ProvaObject a1 = data[1];
        if (a1 instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)a1;
            a1 = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        if (!(a1 instanceof ProvaConstant)) {
            return false;
        }
        Object oa1 = ((ProvaConstant)a1).getObject();
        if (!(oa1 instanceof Number)) {
            return false;
        }
        ProvaObject a2 = data[2];
        if (a2 instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)a2;
            a2 = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        if (!(a2 instanceof ProvaConstant)) {
            return false;
        }
        Object oa2 = ((ProvaConstant)a2).getObject();
        if (!(oa2 instanceof Number)) {
            return false;
        }
        Number na1 = (Number)oa1;
        Number na2 = (Number)oa2;
        Number result = na1 instanceof Double || na2 instanceof Double ? (Number)(na1.doubleValue() - na2.doubleValue()) : (Number)(na1 instanceof Float || na2 instanceof Float ? (Number)Float.valueOf(na1.floatValue() - na2.floatValue()) : (Number)(na1 instanceof Long || na2 instanceof Long ? (Number)(na1.longValue() - na2.longValue()) : (Number)(na1 instanceof Integer || na2 instanceof Integer ? Integer.valueOf(na1.intValue() - na2.intValue()) : Integer.valueOf(na1.byteValue() - na2.byteValue()))));
        if (lt instanceof ProvaConstant) {
            return ((ProvaConstant)lt).getObject() == result;
        }
        ((ProvaVariable)lt).setAssigned(ProvaConstantImpl.create(result));
        return true;
    }
}

