/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.util.ArrayList;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaPredicate;
import org.provarules.reference2.builtins.ProvaSparqlQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaSparqlAskImpl
extends ProvaSparqlQueryImpl {
    private static final Logger log = LoggerFactory.getLogger(ProvaSparqlAskImpl.class);

    public ProvaSparqlAskImpl(ProvaKnowledgeBase kb) {
        super(kb, "sparql_ask");
    }

    @Override
    protected boolean processQuery(ProvaPredicate pred, ProvaConstant cqid, RepositoryConnection con, String sparql_query) {
        boolean answer;
        BooleanQuery q;
        try {
            q = con.prepareBooleanQuery(QueryLanguage.SPARQL, sparql_query);
        }
        catch (Exception e) {
            log.error("Could not prepare boolean query.");
            if (log.isDebugEnabled()) {
                log.debug("Exception: ", (Throwable)e);
            }
            return false;
        }
        try {
            answer = q.evaluate();
        }
        catch (QueryEvaluationException e) {
            log.error("Could not evaluate boolean query.");
            if (log.isDebugEnabled()) {
                log.debug("Exception: ", (Throwable)e);
            }
            return false;
        }
        if (answer) {
            pred = this.kb.getOrGeneratePredicate("sparql_results", 1);
            ProvaSparqlAskImpl.addFact(pred, cqid, new ArrayList<ProvaObject>());
        }
        return true;
    }
}

