/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.util.List;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.http.HTTPRepository;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.builtins.ProvaBuiltinImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaSparqlConnectImpl
extends ProvaBuiltinImpl {
    private static final Logger log = LoggerFactory.getLogger(ProvaSparqlConnectImpl.class);

    public ProvaSparqlConnectImpl(ProvaKnowledgeBase kb) {
        super(kb, "sparql_connect");
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node, ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        RepositoryConnection con;
        List<ProvaVariable> variables = query.getVariables();
        ProvaLiteral literal = goal.getGoal();
        ProvaList terms = literal.getTerms();
        ProvaObject[] data = terms.getFixed();
        if (data.length != 2) {
            log.error("Syntax error. Need two terms.");
            return false;
        }
        ProvaObject data0 = this.resolve(data[0], variables);
        if (data0 instanceof ProvaConstant) {
            Object obj = ((ProvaConstant)data0).getObject();
            if (obj instanceof RepositoryConnection) {
                RepositoryConnection conn = (RepositoryConnection)obj;
                try {
                    return conn.isOpen();
                }
                catch (RepositoryException e) {
                    log.error("Could not determine status of given repository connection.");
                    if (log.isDebugEnabled()) {
                        log.debug("Exception: ", (Throwable)e);
                    }
                    return false;
                }
            }
            log.error("Binding error. First term is bound to something that is not a RepositoryConnection.");
            return false;
        }
        ProvaObject data1 = this.resolve(data[1], variables);
        if (!(data1 instanceof ProvaConstant)) {
            log.error("Second term must be constant string (HTTP end point).");
            return false;
        }
        String url = (String)((ProvaConstant)data1).getObject();
        HTTPRepository repo = new HTTPRepository(url);
        try {
            repo.init();
        }
        catch (RepositoryException e) {
            log.error("Could not initialize repository \"" + url + "\".");
            if (log.isDebugEnabled()) {
                log.debug("Exception: ", (Throwable)e);
            }
            return false;
        }
        try {
            con = repo.getConnection();
        }
        catch (RepositoryException e) {
            log.error("Could not connect to repository \"" + url + "\".");
            if (log.isDebugEnabled()) {
                log.debug("Exception: ", (Throwable)e);
            }
            return false;
        }
        ProvaVariable cvar = (ProvaVariable)data0;
        cvar.setAssigned(ProvaConstantImpl.create(con));
        return true;
    }

    private ProvaObject resolve(ProvaObject o, List<ProvaVariable> variables) {
        if (o instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)o;
            o = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        return o;
    }
}

