/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.util.List;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.builtins.ProvaBuiltinImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaSparqlDisconnectImpl
extends ProvaBuiltinImpl {
    private static final Logger log = LoggerFactory.getLogger(ProvaSparqlDisconnectImpl.class);

    public ProvaSparqlDisconnectImpl(ProvaKnowledgeBase kb) {
        super(kb, "sparql_disconnect");
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node, ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        List<ProvaVariable> variables = query.getVariables();
        ProvaLiteral literal = goal.getGoal();
        ProvaList terms = literal.getTerms();
        ProvaObject[] data = terms.getFixed();
        if (data.length != 1) {
            log.error("Syntax error. Need one term.");
            return false;
        }
        ProvaObject data0 = data[0];
        if (data0 instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)data0;
            data0 = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        if (!(data0 instanceof ProvaConstant)) {
            log.error("Binding error. First term must be constant.");
            return false;
        }
        Object obj = ((ProvaConstant)data0).getObject();
        if (!(obj instanceof RepositoryConnection)) {
            log.error("Binding error. First term must be RepositoryConnection.");
            return false;
        }
        try {
            ((RepositoryConnection)obj).close();
        }
        catch (RepositoryException e) {
            log.error("Could not close connection.");
            return false;
        }
        return true;
    }
}

