/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaPredicate;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaLiteralImpl;
import org.provarules.reference2.ProvaRuleImpl;
import org.provarules.reference2.builtins.ProvaBuiltinImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProvaSparqlQueryImpl
extends ProvaBuiltinImpl {
    private static final Logger log = LoggerFactory.getLogger(ProvaSparqlQueryImpl.class);
    private static AtomicInteger nqid = new AtomicInteger(0);

    ProvaSparqlQueryImpl(ProvaKnowledgeBase kb, String symbol) {
        super(kb, symbol);
    }

    @Override
    public int getArity() {
        return -1;
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node, ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        String qid;
        List<ProvaVariable> variables = query.getVariables();
        ProvaLiteral literal = goal.getGoal();
        ProvaList terms = literal.getTerms();
        ProvaObject[] data = terms.getFixed();
        if (data.length != 3) {
            log.error("Syntax error. Need three terms.");
            return false;
        }
        RepositoryConnection con = (RepositoryConnection)ProvaSparqlQueryImpl.extractValue(data, variables, 0);
        if (con == null) {
            return false;
        }
        String sparql_query = (String)ProvaSparqlQueryImpl.extractValue(data, variables, 1);
        if (sparql_query == null) {
            return false;
        }
        ProvaObject data2 = ProvaSparqlQueryImpl.resolve(data[2], variables);
        if (data2 instanceof ProvaConstant) {
            qid = data2.toString();
        } else {
            qid = Integer.toString(nqid.incrementAndGet());
            ((ProvaVariable)data2).setAssigned(ProvaConstantImpl.create(qid));
        }
        ProvaPredicate pred = null;
        ProvaConstantImpl cqid = ProvaConstantImpl.create(qid);
        return this.processQuery(pred, cqid, con, sparql_query);
    }

    protected abstract boolean processQuery(ProvaPredicate var1, ProvaConstant var2, RepositoryConnection var3, String var4);

    private static ProvaObject resolve(ProvaObject o, List<ProvaVariable> variables) {
        if (o instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)o;
            o = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        return o;
    }

    private static <T> T extractValue(ProvaObject[] data, List<ProvaVariable> variables, int idx) {
        Object retval;
        ProvaObject o = ProvaSparqlQueryImpl.resolve(data[idx], variables);
        if (!(o instanceof ProvaConstant)) {
            log.error("Binding error. Term " + (idx + 1) + " must be constant.");
            return null;
        }
        try {
            retval = ((ProvaConstant)o).getObject();
        }
        catch (ClassCastException cce) {
            log.error("Binding error. Term " + (idx + 1) + " has wrong type.");
            if (log.isDebugEnabled()) {
                log.debug("Exception: ", (Throwable)cce);
            }
            return null;
        }
        return (T)retval;
    }

    static void addFact(ProvaPredicate pred, ProvaConstant cqid, List<ProvaObject> terms) {
        terms.add(0, cqid);
        ProvaList ls = ProvaListImpl.create(terms);
        ProvaLiteralImpl lit = new ProvaLiteralImpl(pred, ls);
        ProvaRule clause = ProvaRuleImpl.createVirtualRule(1L, lit, null);
        pred.addClause(clause);
    }
}

