/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.kernel2.cache.ProvaCacheState;
import org.provarules.kernel2.cache.ProvaGroundKey;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.cache.ProvaGroundKeyImpl;

public class ProvaCacheStateImpl
implements ProvaCacheState {
    private boolean open = false;
    private boolean complete = false;
    private Map<ProvaCacheAnswerKey, ProvaList> answers = new HashMap<ProvaCacheAnswerKey, ProvaList>();
    private List<ProvaGoal> goals = new ArrayList<ProvaGoal>();

    @Override
    public List<ProvaGoal> getGoals() {
        return this.goals;
    }

    @Override
    public void setOpen(boolean open) {
        this.open = open;
    }

    @Override
    public void addGoal(ProvaGoal goal) {
        this.goals.add(goal);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean addSolution(ProvaCacheAnswerKey key, ProvaList literalList) {
        ProvaList oldAnswer = this.answers.get(key);
        if (oldAnswer != null) {
            return false;
        }
        this.answers.put(key, literalList);
        return true;
    }

    @Override
    public ProvaCacheAnswerKey getCacheAnswerKey(ProvaList literalList, List<ProvaVariable> variables) {
        if (literalList == ProvaListImpl.emptyRList) {
            return new ProvaCacheAnswerKey(0, null);
        }
        ProvaObject[] fixed = literalList.getFixed();
        int arity = fixed.length;
        int numBound = 0;
        int mask = 0;
        ProvaObject[] provaObjectArray = fixed;
        int n = provaObjectArray.length;
        for (int i = 0; i < n; ++i) {
            ProvaObject provaObject;
            ProvaObject o = provaObject = provaObjectArray[i];
            mask <<= 1;
            if (o instanceof ProvaVariablePtr) {
                ProvaVariablePtr ptr = (ProvaVariablePtr)o;
                ProvaVariable var = variables.get(ptr.getIndex());
                o = var.getAssigned();
            }
            if (o instanceof ProvaConstant) {
                ++numBound;
                mask |= 1;
                continue;
            }
            if (!(o instanceof ProvaVariable)) continue;
        }
        Object[] data = new Object[numBound];
        int j = 0;
        for (int i = 0; i < arity; ++i) {
            ProvaObject o = fixed[i];
            if (!(o instanceof ProvaConstant)) continue;
            data[j++] = ((ProvaConstant)o).getObject();
        }
        return new ProvaCacheAnswerKey(mask, data);
    }

    @Override
    public Collection<ProvaList> getSolutions() {
        return this.answers.values();
    }

    @Override
    public ProvaGoal getGoal() {
        if (this.goals.size() == 0) {
            return null;
        }
        return this.goals.get(this.goals.size() - 1);
    }

    @Override
    public void markCompletion() {
        this.goals.remove(this.goals.size() - 1);
        if (this.goals.size() == 0) {
            this.complete = true;
        }
    }

    public class ProvaCacheAnswerKey {
        private int mask;
        private ProvaGroundKey groundKey;

        public ProvaCacheAnswerKey(int mask, Object[] data) {
            this.mask = mask;
            this.groundKey = new ProvaGroundKeyImpl(data);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.groundKey == null ? 0 : this.groundKey.hashCode());
            result = 31 * result + this.mask;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProvaCacheAnswerKey other = (ProvaCacheAnswerKey)obj;
            if (this.groundKey == null ? other.groundKey != null : !this.groundKey.equals(other.groundKey)) {
                return false;
            }
            return this.mask == other.mask;
        }
    }
}

