/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.cache;

import java.util.List;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaPredicate;
import org.provarules.kernel2.ProvaUnification;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.cache.ProvaCacheState;
import org.provarules.kernel2.cache.ProvaCachedLiteral;
import org.provarules.kernel2.cache.ProvaLocalAnswers;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaLiteralImpl;
import org.provarules.reference2.ProvaVariableImpl;

public class ProvaCachedLiteralImpl
extends ProvaLiteralImpl
implements ProvaCachedLiteral {
    private static final long serialVersionUID = -4320866097994244461L;
    private ProvaGoal goal;
    private ProvaCacheState cacheState;
    private ProvaLocalAnswers answers;

    public ProvaCachedLiteralImpl(ProvaPredicate predicate, ProvaList terms, ProvaCacheState cacheState, ProvaLocalAnswers answers) {
        super(predicate, terms);
        this.cacheState = cacheState;
        this.answers = answers;
    }

    @Override
    public ProvaLiteral rebuildSource(ProvaUnification unification) {
        if (this.ground || this.terms == null) {
            return this;
        }
        ProvaList newTerms = this.terms.rebuildSource(unification);
        ProvaCachedLiteralImpl cachedLit = new ProvaCachedLiteralImpl(this.predicate, newTerms, this.cacheState, this.answers);
        cachedLit.setGoal(this.goal);
        return cachedLit;
    }

    @Override
    public String toString() {
        return this.predicate.getSymbol() + '(' + this.terms + ')';
    }

    @Override
    public ProvaObject cloneWithVariables(List<ProvaVariable> variables) {
        if (this.terms == null) {
            return this;
        }
        if (this.predicate.getSymbol().equals("cut")) {
            ProvaVariable any1 = ProvaVariableImpl.create();
            ProvaList lany1 = ProvaListImpl.create(new ProvaObject[]{any1});
            return new ProvaLiteralImpl(this.predicate, lany1);
        }
        ProvaList newTerms = (ProvaList)this.terms.cloneWithVariables(variables);
        ProvaCachedLiteralImpl newLit = new ProvaCachedLiteralImpl(this.predicate, newTerms, this.cacheState, this.answers);
        newLit.ground = this.ground;
        newLit.line = this.line;
        newLit.sourceCode = this.sourceCode;
        newLit.metadata = this.metadata;
        newLit.goal = this.goal;
        return newLit;
    }

    @Override
    public void setGoal(ProvaGoal goal) {
        this.goal = goal;
        if (this.cacheState != null) {
            this.cacheState.addGoal(goal);
        }
    }

    @Override
    public ProvaGoal getGoal() {
        return this.goal;
    }

    @Override
    public ProvaCacheState getCacheState() {
        return this.cacheState;
    }

    @Override
    public ProvaLocalAnswers getAnswers() {
        return this.answers;
    }

    @Override
    public void markCompletion() {
        this.cacheState.markCompletion();
    }
}

