/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.eventing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaLiteralImpl;
import org.provarules.reference2.eventing.ProvaBasicGroupImpl;
import org.provarules.reference2.eventing.ProvaGroup;
import org.provarules.reference2.messaging.RemoveList;
import org.provarules.reference2.messaging.where.WhereNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaAndGroupImpl
extends ProvaBasicGroupImpl {
    private static final Logger log = LoggerFactory.getLogger((String)"prova.eventing");
    private ConcurrentMap<MetaVarsKey, List<MetaVars>> varResults;
    private List<Object> local;

    public ProvaAndGroupImpl(String dynamicGroup, String staticGroup) {
        super(dynamicGroup, staticGroup);
        this.results = new ArrayList();
        this.varResults = new ConcurrentHashMap<MetaVarsKey, List<MetaVars>>();
    }

    public ProvaAndGroupImpl(ProvaGroup g) {
        super((ProvaBasicGroupImpl)g);
        this.results = new ArrayList();
        this.varResults = new ConcurrentHashMap<MetaVarsKey, List<MetaVars>>();
    }

    @Override
    public ProvaGroup clone() {
        ProvaAndGroupImpl g = new ProvaAndGroupImpl((ProvaGroup)this);
        g.adjustClone(this);
        return g;
    }

    @Override
    public String getOperatorName() {
        return "and";
    }

    @Override
    public boolean isGroupFailed() {
        return !this.removeMap.isEmpty() && this.local == null;
    }

    @Override
    public ProvaGroup.EventDetectionStatus eventDetected(ProvaKnowledgeBase kb, ProvaReagent prova, long ruleid, ProvaList reaction, Map<String, List<Object>> metadata, Map<Long, ProvaGroup> ruleid2Group) {
        RemoveList r0;
        boolean not;
        if (reaction == null && !this.removeMap.containsKey(ruleid)) {
            return ProvaGroup.EventDetectionStatus.preserved;
        }
        if (this.paused.contains(ruleid)) {
            this.results.remove(this.results.size() - 1);
            return ProvaGroup.EventDetectionStatus.preserved;
        }
        boolean dynamicContext = false;
        boolean noMatches = false;
        if (metadata != null && metadata.containsKey("vars")) {
            dynamicContext = true;
            List<Object> vars = metadata.get("vars");
            Map<Object, ProvaObject> contextVarsMap = ProvaLiteralImpl.tlVars.get();
            HashMap<Object, Object> varsMap = new HashMap<Object, Object>(contextVarsMap.size());
            for (Object var : vars) {
                ProvaObject o = contextVarsMap.remove(((ProvaVariable)var).getName());
                varsMap.put(((ProvaVariable)var).getName(), o instanceof ProvaConstant ? ((ProvaConstant)o).getObject() : o);
            }
            List<List<ProvaList>> matches = this.findFullAnd(ruleid, varsMap, reaction, ruleid2Group, metadata);
            if (matches == null) {
                return ProvaGroup.EventDetectionStatus.failed;
            }
            this.addVarResults(ruleid, varsMap, (ProvaList)reaction.cloneWithVariables(null));
            if (!matches.isEmpty()) {
                this.lastReaction = reaction;
                List<List<ProvaList>> localResults = this.nextResults(0, matches);
                for (List list : localResults) {
                    this.local = new ArrayList<Object>(list.size());
                    for (ProvaList result : list) {
                        this.local.add(result.cloneWithVariables(null));
                    }
                    this.sendGroupResults(this.local, kb, prova);
                    if (this.countMax <= 0 || this.numEmitted != (long)this.countMax) continue;
                    this.lastReaction = reaction;
                    return ProvaGroup.EventDetectionStatus.complete;
                }
            } else {
                noMatches = true;
            }
            this.local = null;
        }
        boolean bl = not = metadata != null && metadata.containsKey("not");
        if (metadata != null && metadata.containsKey("count")) {
            List<Object> countList = metadata.get("count");
            int countMin = (Integer)countList.get(0);
            int countMax = (Integer)countList.get(1);
            int countMode = (Integer)countList.get(2);
            if (reaction == null) {
                if (not) {
                    if (countMin != 0) {
                        ((RemoveList)this.removeMap.get(ruleid)).setOptional(true);
                    } else {
                        if (countMode != 2 || countMax != 0) {
                            if (log.isDebugEnabled()) {
                                log.debug("@and not complete" + this.results);
                            }
                            this.failed = true;
                            return ProvaGroup.EventDetectionStatus.complete;
                        }
                        ((RemoveList)this.removeMap.get(ruleid)).setOptional(true);
                    }
                } else {
                    if (countMin > 0) {
                        if (log.isDebugEnabled()) {
                            log.debug("@and not complete" + this.results);
                        }
                        this.failed = true;
                        return ProvaGroup.EventDetectionStatus.complete;
                    }
                    reaction = ProvaListImpl.emptyRList;
                }
            } else {
                if (!not && countMax == 0 && countMode == 2) {
                    if (log.isDebugEnabled()) {
                        log.debug("@and not complete" + this.results);
                    }
                    this.failed = true;
                    this.lastReaction = reaction;
                    return ProvaGroup.EventDetectionStatus.complete;
                }
                if (countMin > 0) {
                    countList.set(0, --countMin);
                }
                if (not) {
                    if (countMin != 0) {
                        ((RemoveList)this.removeMap.get(ruleid)).setOptional(true);
                    } else {
                        if (countMode != 2) {
                            if (log.isDebugEnabled()) {
                                log.debug("@and not complete" + this.results);
                            }
                            this.failed = true;
                            return ProvaGroup.EventDetectionStatus.complete;
                        }
                        ((RemoveList)this.removeMap.get(ruleid)).setOptional(countMax == 0);
                    }
                }
                if (countMax > 0) {
                    countList.set(1, --countMax);
                }
                if (log.isDebugEnabled()) {
                    log.debug("{}", (Object)countMin);
                }
                if (!not && countMin == 0 && this.removeMap.containsKey(ruleid)) {
                    ((RemoveList)this.removeMap.get(ruleid)).setOptional(true);
                }
                if (not || countMax != 0 || countMode != 0 || countMin != 0) {
                    return ProvaGroup.EventDetectionStatus.preserved;
                }
            }
        } else {
            ruleid2Group.remove(ruleid);
        }
        if (!this.isPermanent() && (r0 = (RemoveList)this.removeMap.remove(ruleid)) != null && !this.isTemplate()) {
            r0.getP1().getClauseSet().removeTemporalClause(ruleid);
            r0.getP2().getClauseSet().removeTemporalClause(ruleid);
        }
        if (reaction == null || metadata != null && (not || metadata.containsKey("stop") && metadata.get("stop").isEmpty())) {
            boolean bl2 = this.failed = reaction != null && not;
            if (this.failed) {
                if (log.isDebugEnabled()) {
                    log.debug("@and not complete" + this.results);
                }
                return ProvaGroup.EventDetectionStatus.complete;
            }
            if (!dynamicContext && this.isAndComplete(ruleid2Group)) {
                if (log.isDebugEnabled()) {
                    log.debug("@and complete" + this.results);
                }
                this.setExtended(false);
                this.failed = false;
            } else {
                this.failed = true;
            }
            return ProvaGroup.EventDetectionStatus.complete;
        }
        if (metadata != null && metadata.containsKey("stop") && !metadata.get("stop").isEmpty()) {
            List<Object> toStop = metadata.get("stop");
            for (Object ido : toStop) {
                if (!(ido instanceof String)) continue;
                String id = (String)ido;
                long ruleidToStop = (Long)this.id2ruleid.get(id);
                RemoveList r = (RemoveList)this.removeMap.get(ruleidToStop);
                if (r == null) {
                    ruleid2Group.remove(ruleidToStop);
                    this.removeMap.remove(ruleidToStop);
                    continue;
                }
                if (!r.isOptional()) {
                    this.failed = true;
                    return ProvaGroup.EventDetectionStatus.complete;
                }
                ruleid2Group.remove(ruleidToStop);
                this.removeMap.remove(ruleidToStop);
                r.getP1().getClauseSet().removeTemporalClause(ruleidToStop);
                r.getP2().getClauseSet().removeTemporalClause(ruleidToStop);
            }
        }
        if (!dynamicContext && this.isAndComplete(ruleid2Group)) {
            if (log.isDebugEnabled()) {
                log.debug("@and complete" + this.results);
            }
            this.setExtended(false);
            this.lastReaction = reaction;
            return ProvaGroup.EventDetectionStatus.complete;
        }
        if (noMatches && this.removeMap.isEmpty()) {
            return ProvaGroup.EventDetectionStatus.failed;
        }
        return ProvaGroup.EventDetectionStatus.incomplete;
    }

    private List<List<ProvaList>> nextResults(int offset, List<List<ProvaList>> matches) {
        if (offset == matches.size()) {
            return Collections.emptyList();
        }
        ArrayList<List<ProvaList>> out = new ArrayList<List<ProvaList>>();
        List<List<ProvaList>> remainder = this.nextResults(offset + 1, matches);
        for (ProvaList match : matches.get(offset)) {
            if (remainder.isEmpty()) {
                out.add(Arrays.asList(match));
                continue;
            }
            for (List<ProvaList> r : remainder) {
                ArrayList<ProvaList> n = new ArrayList<ProvaList>();
                n.add(match);
                n.addAll(r);
                out.add(n);
            }
        }
        return out;
    }

    private List<List<ProvaList>> findFullAnd(long ruleid, Map<Object, Object> varsMap, ProvaList reaction, Map<Long, ProvaGroup> ruleid2Group, Map<String, List<Object>> metadata) {
        ArrayList<List<ProvaList>> matches = new ArrayList<List<ProvaList>>();
        for (Map.Entry e : this.varResults.entrySet()) {
            if (((MetaVarsKey)e.getKey()).dynamicGroup != this.dynamicGroup || ((MetaVarsKey)e.getKey()).ruleid == ruleid) continue;
            ArrayList<ProvaList> legMatches = new ArrayList<ProvaList>();
            for (MetaVars values : (List)e.getValue()) {
                boolean matching = true;
                for (Map.Entry<Object, Object> e2 : values.vars.entrySet()) {
                    Object other = varsMap.get(e2.getKey());
                    if (other == null || e2.getValue().equals(other)) continue;
                    matching = false;
                    break;
                }
                if (!matching && !metadata.containsKey("count") && ruleid2Group.get(e.getKey()) == null) {
                    return null;
                }
                if (this.where != null) {
                    for (WhereNode w : this.where) {
                        boolean r = w.evaluate(varsMap, values.vars);
                        if (r) continue;
                        matching = false;
                        break;
                    }
                }
                if (!matching) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Matching");
                }
                legMatches.add(values.result);
            }
            if (legMatches.isEmpty()) continue;
            matches.add(legMatches);
        }
        if (!matches.isEmpty()) {
            matches.add(Collections.singletonList(reaction));
        }
        return matches;
    }

    private void addVarResults(long ruleid, Map<Object, Object> varsMap, ProvaList reaction) {
        ArrayList<MetaVars> vars = (ArrayList<MetaVars>)this.varResults.get(ruleid);
        if (vars == null) {
            vars = new ArrayList<MetaVars>();
            this.varResults.put(new MetaVarsKey(this.dynamicGroup, ruleid), vars);
        }
        MetaVars mv = new MetaVars(reaction, varsMap);
        vars.add(mv);
    }

    private boolean isAndComplete(Map<Long, ProvaGroup> ruleid2Group) {
        if (this.isPermanent()) {
            this.removeMap.clear();
        }
        if (this.removeMap.isEmpty()) {
            return true;
        }
        if (this.countMax != 0) {
            for (Map.Entry e : this.removeMap.entrySet()) {
                if (((RemoveList)e.getValue()).isOptional() || this.timeout == 0L && ((RemoveList)e.getValue()).isNot()) continue;
                return false;
            }
        }
        for (Map.Entry e : this.removeMap.entrySet()) {
            long ruleid = (Long)e.getKey();
            ruleid2Group.remove(ruleid);
            RemoveList r = (RemoveList)this.removeMap.get(ruleid);
            r.getP1().getClauseSet().removeTemporalClause(ruleid);
            r.getP2().getClauseSet().removeTemporalClause(ruleid);
        }
        this.removeMap.clear();
        return true;
    }

    @Override
    public boolean isOperatorConfigured() {
        return true;
    }

    @Override
    public void childFailed(ProvaGroup child, Map<Long, ProvaGroup> ruleid2Group, Map<String, ProvaGroup> dynamic2Group) {
        this.children.removeIf(provaGroup -> child == provaGroup);
        this.lastReaction = null;
        this.immediateCleanup(ruleid2Group, dynamic2Group);
    }

    private class MetaVarsKey {
        String dynamicGroup;
        public long ruleid;

        MetaVarsKey(String dynamicGroup, long ruleid) {
            this.dynamicGroup = dynamicGroup;
            this.ruleid = ruleid;
        }
    }

    private class MetaVars {
        public Map<Object, Object> vars;
        public ProvaList result;

        MetaVars(ProvaList result, Map<Object, Object> varList) {
            this.result = result;
            this.vars = new HashMap<Object, Object>(varList);
        }
    }
}

