/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.eventing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import org.provarules.agent2.ProvaReagent;
import org.provarules.agent2.ProvaThreadpoolEnum;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaResolutionInferenceEngineImpl;
import org.provarules.reference2.eventing.ProvaGroup;
import org.provarules.reference2.messaging.ProvaDelayedCommand;
import org.provarules.reference2.messaging.ProvaMessengerImpl;
import org.provarules.reference2.messaging.RemoveList;
import org.provarules.reference2.messaging.where.WhereNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaBasicGroupImpl
implements ProvaGroup {
    private static final Logger log = LoggerFactory.getLogger((String)"prova.eventing");
    String dynamicGroup;
    protected List<Object> results;
    RemoveList resultRemoveEntry;
    private List<RemoveList> timeoutRemoveEntries;
    Map<Long, RemoveList> removeMap;
    ProvaList lastReaction;
    protected ProvaGroup parent;
    List<ProvaGroup> children;
    protected long timeout;
    protected boolean failed = false;
    Map<String, Long> id2ruleid;
    Set<Long> paused;
    private String staticGroup;
    private boolean template;
    boolean permanent;
    private String templateDynamicGroup;
    ScheduledFuture<?> future = null;
    long numEmitted = 0L;
    protected List<WhereNode> where = null;
    private boolean extended = false;
    int countMax;
    private ProvaGroup concrete = null;

    public ProvaBasicGroupImpl(String dynamicGroup, String staticGroup) {
        this.dynamicGroup = dynamicGroup;
        this.staticGroup = staticGroup;
        this.timeout = 0L;
        this.template = false;
        this.templateDynamicGroup = null;
        this.permanent = false;
        this.countMax = -1;
        this.removeMap = new HashMap<Long, RemoveList>();
        this.paused = new HashSet<Long>();
    }

    ProvaBasicGroupImpl(ProvaBasicGroupImpl g) {
        this.dynamicGroup = g.dynamicGroup;
        this.templateDynamicGroup = g.templateDynamicGroup;
        this.staticGroup = g.staticGroup;
        this.removeMap = g.removeMap;
        this.resultRemoveEntry = g.resultRemoveEntry;
        this.timeoutRemoveEntries = g.timeoutRemoveEntries;
        this.timeout = g.timeout;
        this.children = g.children;
        this.id2ruleid = g.id2ruleid;
        this.paused = g.paused;
        this.template = g.template;
        this.permanent = g.permanent;
        this.countMax = g.countMax;
        this.future = g.future;
        if (this.children != null) {
            for (ProvaGroup c : this.children) {
                c.setParent(this);
            }
        }
        this.where = g.where;
    }

    @Override
    public ProvaGroup clone() {
        ProvaBasicGroupImpl g = new ProvaBasicGroupImpl(this);
        g.adjustClone(this);
        return g;
    }

    void adjustClone(ProvaBasicGroupImpl group) {
        this.permanent = true;
        this.templateDynamicGroup = group.dynamicGroup;
        this.removeMap = new HashMap<Long, RemoveList>();
        this.removeMap.putAll(group.removeMap);
        this.paused = new HashSet<Long>();
    }

    @Override
    public String getStaticGroup() {
        return this.staticGroup;
    }

    @Override
    public String getOperatorName() {
        return "undefined";
    }

    @Override
    public void addRemoveEntry(long ruleid, RemoveList rl) {
        this.removeMap.put(ruleid, rl);
    }

    @Override
    public void start(Map<Long, ProvaGroup> ruleid2Group) {
        for (Map.Entry<Long, RemoveList> r : this.removeMap.entrySet()) {
            ruleid2Group.put(r.getKey(), this);
        }
    }

    @Override
    public void start(RemoveList rl, Map<Long, ProvaGroup> ruleid2Group) {
        this.resultRemoveEntry = rl;
        for (Map.Entry<Long, RemoveList> r : this.removeMap.entrySet()) {
            ruleid2Group.put(r.getKey(), this);
        }
    }

    @Override
    public void addTimeoutEntry(RemoveList rl) {
        if (this.timeoutRemoveEntries == null) {
            this.timeoutRemoveEntries = new ArrayList<RemoveList>();
        }
        this.timeoutRemoveEntries.add(rl);
    }

    @Override
    public void cleanupTimeoutEntries() {
        if (this.timeoutRemoveEntries == null) {
            return;
        }
        for (RemoveList rl : this.timeoutRemoveEntries) {
            long k = rl.getRuleid();
            rl.getP1().getClauseSet().removeTemporalClause(k);
            rl.getP2().getClauseSet().removeTemporalClause(k);
        }
    }

    @Override
    public String getDynamicGroup() {
        return this.dynamicGroup;
    }

    @Override
    public RemoveList getResultRemoveEntry() {
        return this.resultRemoveEntry;
    }

    @Override
    public Map<Long, RemoveList> getRemoveMap() {
        return this.removeMap;
    }

    @Override
    public void addResult(ProvaList result) {
        this.results.add(result);
    }

    @Override
    public ProvaGroup.EventDetectionStatus eventDetected(ProvaKnowledgeBase kb, ProvaReagent prova, long key, ProvaList reaction, Map<String, List<Object>> metadata, Map<Long, ProvaGroup> ruleid2Group) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stop() {
        for (Map.Entry<Long, RemoveList> e : this.removeMap.entrySet()) {
            if (log.isDebugEnabled()) {
                log.debug("{}", e);
            }
            RemoveList r = e.getValue();
            long k = r.getRuleid();
            r.getP1().getClauseSet().removeTemporalClause(k);
            r.getP2().getClauseSet().removeTemporalClause(k);
        }
        if (this.children != null) {
            for (ProvaGroup c : this.children) {
                c.stop();
            }
        }
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    @Override
    public boolean cleanup(ProvaKnowledgeBase kb, ProvaReagent prova, Map<Long, ProvaGroup> ruleid2Group, Map<String, ProvaGroup> dynamic2Group) {
        if (this.failed) {
            this.immediateCleanup(ruleid2Group, dynamic2Group);
            return true;
        }
        List<ProvaDelayedCommand> delayed = ProvaResolutionInferenceEngineImpl.delayedCommands.get();
        if (delayed != null && !this.removeMap.isEmpty()) {
            return false;
        }
        if (delayed == null) {
            this.results.clear();
            Iterator<Map.Entry<Long, RemoveList>> iter = this.removeMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Long, RemoveList> e = iter.next();
                RemoveList removeList = (RemoveList)e.getValue();
                if (!removeList.isNot()) continue;
                ProvaList reaction = removeList.getReaction();
                reaction.getFixed()[1] = ProvaConstantImpl.create("async");
                reaction.getFixed()[2] = ProvaConstantImpl.create(0);
                this.lastReaction = reaction;
                ProvaList reactionM = ProvaListImpl.create(new ProvaObject[]{ProvaConstantImpl.create("not"), reaction.shallowCopy()});
                this.addResult(reactionM);
                iter.remove();
            }
        }
        boolean resultsSent = this.sendGroupResults(this.results, kb, prova);
        for (Map.Entry entry : this.removeMap.entrySet()) {
            long k = (Long)entry.getKey();
            ruleid2Group.remove(k);
        }
        if (!resultsSent) {
            long k = this.resultRemoveEntry.getRuleid();
            this.resultRemoveEntry.getP1().getClauseSet().removeTemporalClause(k);
            this.resultRemoveEntry.getP2().getClauseSet().removeTemporalClause(k);
            this.cleanupTimeoutEntries();
        }
        if (this.children != null) {
            for (ProvaGroup provaGroup : this.children) {
                provaGroup.immediateCleanup(ruleid2Group, dynamic2Group);
            }
        }
        dynamic2Group.remove(this.dynamicGroup);
        if (this.lastReaction == null) {
            if (log.isDebugEnabled()) {
                log.debug("Group failed");
            }
            if (this.parent != null) {
                this.parent.childFailed(this, ruleid2Group, dynamic2Group);
            }
        }
        return true;
    }

    @Override
    public void immediateCleanup(Map<Long, ProvaGroup> ruleid2Group, Map<String, ProvaGroup> dynamic2Group) {
        for (Map.Entry<Long, RemoveList> e : this.removeMap.entrySet()) {
            long k = e.getKey();
            ruleid2Group.remove(k);
        }
        long k = this.resultRemoveEntry.getRuleid();
        this.resultRemoveEntry.getP1().getClauseSet().removeTemporalClause(k);
        this.resultRemoveEntry.getP2().getClauseSet().removeTemporalClause(k);
        this.cleanupTimeoutEntries();
        if (this.children != null) {
            for (ProvaGroup c : this.children) {
                c.immediateCleanup(ruleid2Group, dynamic2Group);
            }
        }
        dynamic2Group.remove(this.dynamicGroup);
        if (log.isDebugEnabled()) {
            log.debug("Group removed: " + this.dynamicGroup);
        }
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    @Override
    public boolean isOperatorConfigured() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized boolean sendGroupResults(List<Object> results, ProvaKnowledgeBase kb, ProvaReagent prova) {
        ProvaList content;
        if (this.isGroupFailed()) {
            if (log.isDebugEnabled()) {
                log.debug("Timeout group results: " + results);
            }
            content = ProvaListImpl.create(new ProvaObject[]{ProvaConstantImpl.create(results)});
            if (results.isEmpty()) {
                if (this.timeoutRemoveEntries == null || this.timeoutRemoveEntries.isEmpty()) return false;
                this.lastReaction = this.timeoutRemoveEntries.get(0).getReaction();
                this.lastReaction.getFixed()[1] = ProvaConstantImpl.create("async");
                this.lastReaction.getFixed()[2] = ProvaConstantImpl.create(0);
            } else {
                Object last = results.get(results.size() - 1);
                this.lastReaction = last instanceof ProvaList ? ((ProvaList)last).shallowCopy() : this.resultRemoveEntry.getReaction();
                this.lastReaction.getFixed()[3] = ProvaConstantImpl.create("timeout");
                if (this.numEmitted != 0L) {
                    results.clear();
                }
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Group results: " + results);
            }
            content = ProvaListImpl.create(new ProvaObject[]{ProvaConstantImpl.create(results)});
            if (this.lastReaction == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Empty results");
                }
                this.lastReaction = this.resultRemoveEntry.getReaction();
                this.lastReaction.getFixed()[1] = ProvaConstantImpl.create("async");
                this.lastReaction.getFixed()[2] = ProvaConstantImpl.create(0);
            } else {
                if (this.lastReaction.getFixed().length == 0) {
                    this.lastReaction = (ProvaList)results.get(results.size() - 1);
                } else if (this.lastReaction.getFixed().length == 2) {
                    ProvaObject[] newFixed = new ProvaObject[5];
                    newFixed[0] = this.lastReaction.getFixed()[0];
                    newFixed[1] = ProvaConstantImpl.create("async");
                    newFixed[2] = ProvaConstantImpl.create(0);
                    newFixed[4] = this.lastReaction.getFixed()[1];
                    this.lastReaction = ProvaListImpl.create(newFixed, this.lastReaction.getTail());
                }
                ProvaObject o = this.lastReaction.getFixed()[2];
                if (o instanceof ProvaList) {
                    this.lastReaction = (ProvaList)o;
                }
            }
            this.lastReaction.getFixed()[3] = ProvaConstantImpl.create(this.getOperatorName());
        }
        this.lastReaction.getFixed()[4] = content;
        ProvaObject cidOriginal = this.lastReaction.getFixed()[0];
        String cid = cidOriginal instanceof ProvaConstant ? ((ProvaConstant)cidOriginal).getObject().toString() : "0";
        ProvaConstantImpl cidObject = ProvaConstantImpl.create(cid);
        this.lastReaction.getFixed()[0] = cidObject;
        ProvaLiteral lit = kb.generateHeadLiteral("rcvMsg", this.lastReaction);
        HashMap<String, List<Object>> meta = new HashMap<String, List<Object>>(1);
        if (this.templateDynamicGroup != null) {
            meta.put("group", Arrays.asList(this.templateDynamicGroup));
        } else {
            meta.put("group", Arrays.asList(this.dynamicGroup));
        }
        lit.addMetadata(meta);
        ProvaRule goal = kb.generateGoal(new ProvaLiteral[]{lit, kb.generateLiteral("fail")}).cloneRule();
        if (log.isDebugEnabled()) {
            log.debug("Sent group results: " + goal);
        }
        if (cid.equals("0")) {
            prova.submitAsync(0L, goal, ProvaThreadpoolEnum.MAIN);
        } else {
            prova.submitAsync(ProvaMessengerImpl.partitionKey(cid), goal, ProvaThreadpoolEnum.CONVERSATION);
        }
        ++this.numEmitted;
        return true;
    }

    @Override
    public boolean isGroupFailed() {
        return this.results.size() == 0 || this.lastReaction == null;
    }

    @Override
    public void setParent(ProvaGroup parent) {
        this.parent = parent;
    }

    @Override
    public ProvaGroup getParent() {
        return this.parent;
    }

    @Override
    public void addChild(ProvaGroup g) {
        if (this.children == null) {
            this.children = new ArrayList<ProvaGroup>();
        }
        this.children.add(g);
    }

    @Override
    public List<ProvaGroup> getChildren() {
        return this.children;
    }

    @Override
    public void childFailed(ProvaGroup child, Map<Long, ProvaGroup> ruleid2Group, Map<String, ProvaGroup> dynamic2Group) {
        throw new RuntimeException("Unsupported method");
    }

    @Override
    public void setTimeout(long delay) {
        this.timeout = delay;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public void putId2ruleid(String id, long ruleid) {
        if (this.id2ruleid == null) {
            this.id2ruleid = new HashMap<String, Long>();
        }
        this.id2ruleid.put(id, ruleid);
    }

    @Override
    public void pause(long ruleidToPause) {
        this.paused.add(ruleidToPause);
    }

    void resume(long ruleidToPause) {
        this.paused.remove(ruleidToPause);
    }

    @Override
    public void setTemplate(boolean template) {
        this.template = template;
    }

    @Override
    public boolean isTemplate() {
        return this.template;
    }

    @Override
    public void setDynamicGroup(String dynamicGroup) {
        this.dynamicGroup = dynamicGroup;
    }

    @Override
    public boolean isPermanent() {
        return this.permanent;
    }

    @Override
    public void setTimerFuture(ScheduledFuture<?> future) {
        if (this.concrete != null) {
            this.concrete.setTimerFuture(future);
        } else {
            this.future = future;
        }
    }

    @Override
    public void addWhere(WhereNode newWhere) {
        if (this.where == null) {
            this.where = new ArrayList<WhereNode>();
        }
        this.where.add(newWhere);
    }

    @Override
    public boolean isExtended() {
        return this.extended;
    }

    @Override
    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    @Override
    public void setCountMax(int countMax) {
        this.countMax = countMax;
    }

    @Override
    public void setConcrete(ProvaGroup group) {
        this.concrete = group;
    }
}

