/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.messaging;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang3.time.DateUtils;
import org.provarules.agent2.ProvaReagent;
import org.provarules.agent2.ProvaThreadpoolEnum;
import org.provarules.esb2.ProvaAgent;
import org.provarules.eventing.ProvaEventsAccumulator;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaPredicate;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.kernel2.messaging.ProvaMessenger;
import org.provarules.parser.WhereLexer;
import org.provarules.parser.WhereParser;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaLiteralImpl;
import org.provarules.reference2.ProvaMapImpl;
import org.provarules.reference2.ProvaResolutionInferenceEngineImpl;
import org.provarules.reference2.ProvaVariableImpl;
import org.provarules.reference2.eventing.ProvaAndGroupImpl;
import org.provarules.reference2.eventing.ProvaBasicGroupImpl;
import org.provarules.reference2.eventing.ProvaGroup;
import org.provarules.reference2.eventing.ProvaOrGroupImpl;
import org.provarules.reference2.messaging.ProvaDelayedCommand;
import org.provarules.reference2.messaging.ProvaESBMessageImpl;
import org.provarules.reference2.messaging.ProvaGroupCleanupImpl;
import org.provarules.reference2.messaging.ProvaMessageImpl;
import org.provarules.reference2.messaging.ProvaScheduleGroupCleanupImpl;
import org.provarules.reference2.messaging.ProvaScheduleGroupMemberCleanupImpl;
import org.provarules.reference2.messaging.ProvaServiceMessageImpl;
import org.provarules.reference2.messaging.RemoveList;
import org.provarules.reference2.messaging.where.WhereNode;
import org.provarules.reference2.messaging.where.WhereTreeVisitor;
import org.provarules.service.ProvaMiniService;
import org.provarules.util2.ProvaTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaMessengerImpl
implements ProvaMessenger {
    private static final ProvaVariable CTLPROTOCOL = ProvaVariableImpl.create("CtlProtocol");
    private static final ProvaVariable CTLFROM = ProvaVariableImpl.create("CtlFrom");
    private static final ProvaConstantImpl EOF = ProvaConstantImpl.create("eof");
    private static final Logger log = LoggerFactory.getLogger((String)"prova");
    private final ProvaReagent prova;
    private final ProvaKnowledgeBase kb;
    private final String agent;
    private final String password;
    private final String machine;
    private final ProvaAgent esb;
    private final AtomicLong unique_iid = new AtomicLong();
    private final AtomicLong reaction_iid = new AtomicLong();
    private final ConcurrentMap<Long, List<String>> ruleid2outbound = new ConcurrentHashMap<Long, List<String>>();
    private final ConcurrentMap<String, List<Long>> inbound2ruleids = new ConcurrentHashMap<String, List<Long>>();
    private final ConcurrentMap<String, String> dynamic2Static = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, ProvaGroup> dynamic2Group = new ConcurrentHashMap<String, ProvaGroup>();
    private final ConcurrentMap<Long, ProvaGroup> ruleid2Group = new ConcurrentHashMap<Long, ProvaGroup>();
    private final ConcurrentMap<Long, ProvaGroup> outcomeRuleid2Group = new ConcurrentHashMap<Long, ProvaGroup>();
    private final ScheduledThreadPoolExecutor timers;
    private final ProvaPredicate rcvMsg2;
    private ProvaMiniService service;
    private static ThreadLocal<Map<String, String>> tlStatic2Dynamic = new ThreadLocal();
    private static ThreadLocal<Map<String, ProvaGroup>> tlDynamic = new ThreadLocal();

    public ProvaMessengerImpl(ProvaReagent prova, ProvaKnowledgeBase kb, String agent, String password, String machine, ProvaAgent esb) {
        this.prova = prova;
        this.kb = kb;
        this.agent = agent;
        this.password = password;
        this.machine = machine;
        this.esb = esb;
        this.timers = new ScheduledThreadPoolExecutor(5, new TimerThreadFactory());
        this.rcvMsg2 = kb.getOrGeneratePredicate("rcvMsg", 2);
    }

    @Override
    public boolean prepareMsg(ProvaLiteral literal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        ProvaDelayedCommand message = null;
        try {
            String cid;
            List<ProvaVariable> variables = query.getVariables();
            ProvaList terms = literal.getTerms();
            ProvaObject[] data = terms.getFixed();
            ProvaObject lt = data[0];
            if (lt instanceof ProvaVariablePtr) {
                ProvaVariablePtr varPtr = (ProvaVariablePtr)lt;
                lt = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
            }
            if (lt instanceof ProvaConstant) {
                cid = lt.toString();
            } else if (lt instanceof ProvaVariable) {
                cid = this.generateCid();
                ((ProvaVariable)lt).setAssigned(ProvaConstantImpl.create(cid));
            } else {
                return false;
            }
            if (!(data[1] instanceof ProvaConstant)) {
                return false;
            }
            String protocol = ((ProvaConstant)data[1]).getObject().toString();
            if (!(data[2] instanceof ProvaConstant)) {
                return false;
            }
            String dest = ((ProvaConstant)data[2]).getObject().toString();
            ProvaList termsCopy = (ProvaList)terms.cloneWithVariables(variables);
            if ("esb".equals(protocol)) {
                if (this.esb == null) {
                    return false;
                }
                message = new ProvaESBMessageImpl(dest, termsCopy, this.esb);
            } else if ("osgi".equals(protocol)) {
                if (this.service == null) {
                    return false;
                }
                message = new ProvaServiceMessageImpl(dest, termsCopy, this.agent, this.service);
            } else {
                ProvaLiteral lit = this.kb.generateHeadLiteral("rcvMsg", termsCopy);
                ProvaRule goal = this.kb.generateGoal(new ProvaLiteral[]{lit, this.kb.generateLiteral("fail")});
                if ("async".equals(protocol)) {
                    message = new ProvaMessageImpl(ProvaMessengerImpl.partitionKey(cid), goal, ProvaThreadpoolEnum.CONVERSATION);
                } else if ("task".equals(protocol)) {
                    message = new ProvaMessageImpl(0L, goal, ProvaThreadpoolEnum.TASK);
                } else if ("swing".equals(protocol)) {
                    message = new ProvaMessageImpl(0L, goal, ProvaThreadpoolEnum.SWING);
                } else if ("self".equals(protocol) || "0".equals(dest)) {
                    message = new ProvaMessageImpl(0L, goal, ProvaThreadpoolEnum.MAIN);
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        if (message != null) {
            List<ProvaDelayedCommand> delayed = ProvaResolutionInferenceEngineImpl.delayedCommands.get();
            delayed.add(message);
            return true;
        }
        return false;
    }

    public static long partitionKey(String cid) {
        return Math.abs(cid.hashCode());
    }

    @Override
    public boolean sendMsg(ProvaLiteral literal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        try {
            String cid;
            if (literal.isGround()) {
                return this.sendMsgGround(literal, newLiterals, query);
            }
            List<ProvaVariable> variables = query.getVariables();
            ProvaList terms = literal.getTerms();
            ProvaObject[] data = terms.getFixed();
            ProvaObject lt = data[0];
            if (lt instanceof ProvaVariablePtr) {
                ProvaVariablePtr varPtr = (ProvaVariablePtr)lt;
                lt = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
            }
            if (lt instanceof ProvaConstant) {
                cid = lt.toString();
            } else if (lt instanceof ProvaVariable) {
                cid = this.generateCid();
                ((ProvaVariable)lt).setAssigned(ProvaConstantImpl.create(cid));
            } else {
                return false;
            }
            if (data.length == 2) {
                ProvaList termsCopy = terms.copyWithVariables(variables);
                ProvaLiteralImpl lit = new ProvaLiteralImpl(this.rcvMsg2, termsCopy);
                ProvaRule goal = this.kb.generateGoal(new ProvaLiteral[]{lit, this.kb.generateLiteral("fail")});
                this.prova.submitAsync(ProvaMessengerImpl.partitionKey(cid), goal, ProvaThreadpoolEnum.CONVERSATION);
                return true;
            }
            if (!(data[1] instanceof ProvaConstant)) {
                return false;
            }
            String protocol = data[1].toString();
            ProvaObject destObject = data[2];
            if (destObject instanceof ProvaVariablePtr) {
                ProvaVariablePtr varPtr = (ProvaVariablePtr)destObject;
                destObject = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
            }
            if (!(destObject instanceof ProvaConstant)) {
                return false;
            }
            String dest = destObject.toString();
            if (!(data[3] instanceof ProvaConstant)) {
                return false;
            }
            ProvaList termsCopy = terms.copyWithVariables(variables);
            if ("esb".equals(protocol)) {
                if (this.esb == null) {
                    return false;
                }
                ProvaESBMessageImpl message = new ProvaESBMessageImpl(dest, termsCopy, this.esb);
                message.process(this.prova);
                return true;
            }
            if ("osgi".equals(protocol)) {
                if (this.service == null) {
                    return false;
                }
                ProvaServiceMessageImpl message = new ProvaServiceMessageImpl(dest, termsCopy, this.agent, this.service);
                message.process(this.prova);
                return true;
            }
            String verb = data[3].toString();
            ProvaLiteral lit = this.kb.generateHeadLiteral("rcvMsg", termsCopy);
            ProvaRule goal = this.kb.generateGoal(new ProvaLiteral[]{lit, this.kb.generateLiteral("fail")});
            if ("async".equals(protocol)) {
                this.prova.submitAsync(ProvaMessengerImpl.partitionKey(cid), goal, ProvaThreadpoolEnum.CONVERSATION);
                return true;
            }
            if ("task".equals(protocol)) {
                this.prova.submitAsync(0L, goal, ProvaThreadpoolEnum.TASK);
                return true;
            }
            if ("swing".equals(protocol)) {
                this.prova.submitAsync(0L, goal, ProvaThreadpoolEnum.SWING);
                return true;
            }
            if ("self".equals(protocol) || "0".equals(dest)) {
                this.prova.submitAsync(0L, goal, ProvaThreadpoolEnum.MAIN);
                return true;
            }
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
        }
        return false;
    }

    private boolean sendMsgGround(ProvaLiteral literal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        ProvaList terms = literal.getTerms();
        ProvaObject[] data = terms.getFixed();
        if (data.length == 2) {
            ProvaLiteralImpl lit = new ProvaLiteralImpl(this.rcvMsg2, terms);
            ProvaRule goal = this.kb.generateGoal(new ProvaLiteral[]{lit, this.kb.generateLiteral("fail")});
            this.prova.submitAsync(ProvaMessengerImpl.partitionKey(data[0].toString()), goal, ProvaThreadpoolEnum.CONVERSATION);
            return true;
        }
        String protocol = data[1].toString();
        String dest = data[2].toString();
        if ("esb".equals(protocol)) {
            if (this.esb == null) {
                return false;
            }
            ProvaESBMessageImpl message = new ProvaESBMessageImpl(dest, terms, this.esb);
            message.process(this.prova);
            return true;
        }
        if ("osgi".equals(protocol)) {
            if (this.service == null) {
                return false;
            }
            ProvaServiceMessageImpl message = new ProvaServiceMessageImpl(dest, terms, this.agent, this.service);
            message.process(this.prova);
            return true;
        }
        if (!(data[3] instanceof ProvaConstant)) {
            return false;
        }
        String verb = data[3].toString();
        ProvaList termsCopy = terms;
        ProvaLiteral lit = this.kb.generateHeadLiteral("rcvMsg", termsCopy);
        ProvaRule goal = this.kb.generateGoal(new ProvaLiteral[]{lit, this.kb.generateLiteral("fail")});
        if ("async".equals(protocol)) {
            String cid = data[0].toString();
            this.prova.submitAsync(ProvaMessengerImpl.partitionKey(cid), goal, ProvaThreadpoolEnum.CONVERSATION);
            return true;
        }
        if ("task".equals(protocol)) {
            this.prova.submitAsync(0L, goal, ProvaThreadpoolEnum.TASK);
            return true;
        }
        if ("swing".equals(protocol)) {
            this.prova.submitAsync(0L, goal, ProvaThreadpoolEnum.SWING);
            return true;
        }
        if ("self".equals(protocol) || "0".equals(dest)) {
            this.prova.submitAsync(0L, goal, ProvaThreadpoolEnum.MAIN);
            return true;
        }
        return false;
    }

    @Override
    public void sendReturnAsMsg(ProvaConstant cid, Object ret) {
        if (ret == null) {
            ret = 0;
        }
        ProvaList terms = ProvaListImpl.create(new ProvaObject[]{cid, ProvaConstantImpl.create("self"), ProvaConstantImpl.create("0"), ProvaConstantImpl.create("return"), ProvaConstantImpl.create(ret)});
        ProvaLiteral lit = this.kb.generateHeadLiteral("rcvMsg", terms);
        ProvaRule goal = this.kb.generateGoal(new ProvaLiteral[]{lit, this.kb.generateLiteral("fail")});
        this.prova.submitAsync(ProvaMessengerImpl.partitionKey(cid.getObject().toString()), goal, ProvaThreadpoolEnum.CONVERSATION);
    }

    @Override
    public boolean spawn(ProvaLiteral literal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = literal.getTerms();
        ProvaObject[] data = terms.getFixed();
        ProvaObject lt = data[0];
        if (lt instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)lt;
            lt = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        if (lt instanceof ProvaVariable) {
            String cid = this.generateCid();
            ((ProvaVariable)lt).setAssigned(ProvaConstantImpl.create(cid));
        }
        this.prova.spawn((ProvaList)terms.cloneWithVariables(variables));
        return true;
    }

    @Override
    public String generateCid() {
        return this.prova.getAgent() + ':' + this.unique_iid.incrementAndGet();
    }

    private static WhereNode parse(String expr) throws Exception {
        ByteArrayInputStream rawinput = new ByteArrayInputStream(expr.getBytes(StandardCharsets.UTF_8));
        ANTLRInputStream input = new ANTLRInputStream((InputStream)rawinput);
        WhereLexer lexer = new WhereLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        WhereParser parser = new WhereParser((TokenStream)tokens);
        CommonTree tree = (CommonTree)parser.expr().getTree();
        return WhereTreeVisitor.visit((Tree)tree);
    }

    @Override
    public boolean rcvMsg(ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query, boolean mult) {
        ProvaLiteral literal = goal.getGoal();
        ProvaRule copy = query.cloneRule();
        List<ProvaVariable> variables = copy.getVariables();
        ProvaLiteral literalClone = (ProvaLiteral)literal.cloneWithVariables(variables);
        ProvaList terms = literalClone.getTerms();
        try {
            ProvaList addAndResultList;
            boolean meta;
            ProvaObject[] data = terms.getFixed();
            ProvaObject xid = data[0];
            if (!(xid instanceof ProvaConstant) && !(xid instanceof ProvaVariable)) {
                return false;
            }
            if (data.length != 2 && !(data[2] instanceof ProvaConstant) && !(data[2] instanceof ProvaVariable)) {
                return false;
            }
            long ruleid = this.reaction_iid.incrementAndGet();
            ProvaConstantImpl tid = ProvaConstantImpl.create(ruleid);
            boolean bl = meta = literal.getMetadata() != null;
            if (!meta) {
                ProvaList headControlList;
                ArrayList<ProvaLiteral> body = new ArrayList<ProvaLiteral>();
                List<ProvaLiteral> guard = literalClone.getGuard();
                if (guard != null) {
                    body.addAll(guard);
                }
                ProvaObject poXID = data[0];
                if (data.length == 2) {
                    ProvaVariable ctlProtocol = CTLPROTOCOL;
                    headControlList = ProvaListImpl.create(new ProvaObject[]{tid, ctlProtocol, CTLFROM, EOF, terms});
                } else {
                    ProvaObject poProtocol = data[1];
                    ProvaObject ctlProtocol = poProtocol instanceof ProvaConstant ? poProtocol : CTLPROTOCOL;
                    headControlList = ProvaListImpl.create(new ProvaObject[]{tid, ctlProtocol, CTLFROM, EOF, terms});
                }
                ProvaLiteral head = this.kb.generateHeadLiteral("rcvMsg", terms);
                ProvaLiteral headControl = this.kb.generateLiteral("@temporal_rule_control", (ProvaList)headControlList.cloneWithVariables(variables));
                ProvaList removeList = ProvaListImpl.create(new ProvaObject[]{ProvaConstantImpl.create(head.getPredicate()), ProvaConstantImpl.create(headControl.getPredicate()), tid, head.getTerms()});
                ProvaLiteral removeLiteral = this.kb.generateLiteral("@temporal_rule_remove", removeList);
                if (!mult) {
                    body.add(removeLiteral);
                }
                ProvaLiteral[] queryLiterals = copy.getBody();
                for (int i = 1; i < queryLiterals.length; ++i) {
                    body.add((ProvaLiteral)queryLiterals[i].cloneWithVariables(variables));
                }
                ProvaRule rule = this.kb.generateRule(ruleid, head, body.toArray(new ProvaLiteral[0]));
                this.kb.generateRule(ruleid, headControl, new ProvaLiteral[]{removeLiteral});
                if (log.isDebugEnabled()) {
                    log.debug("Added temporal rule: " + rule);
                }
                return false;
            }
            List<Object> groups = literal.getMetadata("group");
            List<Object> groupsAnd = literal.getMetadata("and");
            List<Object> groupsOr = literal.getMetadata("or");
            List<Object> groupsNot = literal.getMetadata("not");
            List<Object> groupsStop = literal.getMetadata("stop");
            List<Object> groupsOptional = literal.getMetadata("optional");
            List<Object> groupsCount = literal.getMetadata("count");
            List<Object> groupsSize = literal.getMetadata("size");
            List<Object> groupsPause = literal.getMetadata("pause");
            List<Object> groupsResume = literal.getMetadata("resume");
            List<Object> groupsPaused = literal.getMetadata("paused");
            Object size = null;
            Object sizeReset = null;
            Object sizeObject = null;
            if (groupsSize != null && groupsSize.size() != 0) {
                size = groupsSize.get(0);
                size = goal.lookupMetadata(size.toString(), variables);
                if (groupsSize.size() > 1) {
                    sizeReset = groupsSize.get(1);
                    sizeReset = goal.lookupMetadata(sizeReset.toString(), variables);
                    if (groupsSize.size() > 2) {
                        sizeObject = groupsSize.get(2);
                        sizeObject = goal.lookupMetadata(sizeObject.toString(), variables);
                    }
                }
            }
            Integer countMin = null;
            Integer countMax = null;
            int countMode = 0;
            if (groupsCount != null && groupsCount.size() != 0) {
                String s = groupsCount.get(0).toString();
                countMin = Integer.parseInt((String)goal.lookupMetadata(s, variables));
                if (groupsCount.size() > 1) {
                    s = groupsCount.get(1).toString();
                    countMax = Integer.parseInt((String)goal.lookupMetadata(s, variables));
                    if (groupsCount.size() > 2) {
                        s = groupsCount.get(2).toString();
                        if ("record".equals(s)) {
                            countMode = 1;
                        } else if ("strict".equals(s)) {
                            countMode = 2;
                        }
                    } else if (countMax == -1) {
                        countMax = countMin;
                        countMode = 1;
                    }
                } else if (countMin == -1) {
                    countMin = 0;
                    countMax = 0;
                    countMode = 1;
                } else {
                    countMax = countMin;
                    countMode = 0;
                }
            }
            List<Object> groupsTimeout = literal.getMetadata("timeout");
            Object timeout = null;
            if (groupsTimeout != null && groupsTimeout.size() != 0) {
                timeout = groupsTimeout.get(0);
                timeout = goal.lookupMetadata(timeout.toString(), variables);
            }
            List<Object> groupsTimer = literal.getMetadata("timer");
            Object timer = null;
            Object timerReset = null;
            Object timerObject = null;
            if (groupsTimer != null && groupsTimer.size() != 0) {
                timer = groupsTimer.get(0);
                timer = goal.lookupMetadata(timer.toString(), variables);
                if (groupsTimer.size() > 1) {
                    timerReset = groupsTimer.get(1);
                    timerReset = goal.lookupMetadata(timerReset.toString(), variables);
                } else {
                    timerReset = timer;
                }
                if (groupsTimer.size() > 2) {
                    timerObject = groupsTimer.get(2);
                    timerObject = goal.lookupMetadata(timerObject.toString(), variables);
                }
            }
            List<Object> groupsVar = literal.getMetadata("vars");
            ArrayList<Object> vars = null;
            if (groupsVar != null && groupsVar.size() != 0) {
                vars = new ArrayList<Object>();
                for (Object var : groupsVar) {
                    var = goal.lookupMetadata(var.toString(), variables);
                    vars.add(var);
                }
            }
            List<Object> groupsWhere = literal.getMetadata("where");
            WhereNode where = null;
            if (groupsWhere != null && groupsWhere.size() != 0) {
                where = ProvaMessengerImpl.parse(groupsWhere.get(0).toString());
            }
            ArrayList<ProvaLiteral> body = new ArrayList<ProvaLiteral>();
            List<ProvaLiteral> guard = literalClone.getGuard();
            if (guard != null) {
                body.addAll(guard);
            }
            ProvaObject poXID = data[0];
            ProvaObject poProtocol = data[1];
            ProvaObject ctlProtocol = poProtocol instanceof ProvaConstant ? poProtocol : CTLPROTOCOL;
            ProvaList headControlList = ProvaListImpl.create(new ProvaObject[]{tid, ctlProtocol, CTLFROM, EOF, terms});
            ProvaLiteral head = this.kb.generateHeadLiteral("rcvMsg", terms);
            ProvaLiteral headControl = this.kb.generateLiteral("@temporal_rule_control", (ProvaList)headControlList.cloneWithVariables(variables));
            RemoveList rl = new RemoveList(head.getPredicate(), headControl.getPredicate(), ruleid, (ProvaList)head.getTerms().cloneWithVariables(variables));
            ProvaGroup dynamic = this.generateOrReuseDynamicGroup(goal, variables, ruleid, rl);
            ProvaList removeList = ProvaListImpl.create(new ProvaObject[]{ProvaConstantImpl.create(head.getPredicate()), ProvaConstantImpl.create(headControl.getPredicate()), tid, head.getTerms()});
            ProvaLiteral removeLiteral = this.kb.generateLiteral("@temporal_rule_remove", removeList);
            if (groupsWhere != null) {
                dynamic.addWhere(where);
            }
            if (dynamic != null && dynamic.getParent() != null) {
                addAndResultList = ProvaListImpl.create(new ProvaObject[]{ProvaConstantImpl.create(dynamic.getParent().getDynamicGroup()), head.getTerms()});
                removeLiteral.setMetadata("rule", Arrays.asList(dynamic.getParent().getDynamicGroup()));
                body.add(this.kb.generateLiteral("@add_group_result", addAndResultList));
                if (groupsNot != null) {
                    removeLiteral.setMetadata("not", Collections.emptyList());
                    rl.setNot(true);
                }
                if (groupsTimeout != null) {
                    removeLiteral.setMetadata("timeout", groupsTimeout);
                }
                if (groupsStop != null) {
                    removeLiteral.setMetadata("stop", groupsStop);
                    rl.setOptional(groupsStop.isEmpty());
                }
                if (groupsOptional != null) {
                    rl.setOptional(true);
                }
                if (groupsPause != null) {
                    removeLiteral.setMetadata("pause", groupsPause);
                }
                if (groupsResume != null) {
                    removeLiteral.setMetadata("resume", groupsResume);
                }
                if (groupsPaused != null) {
                    removeLiteral.setMetadata("paused", groupsPaused);
                    dynamic.getParent().pause(ruleid);
                }
            } else if (groups != null && groups.size() != 0) {
                addAndResultList = ProvaListImpl.create(new ProvaObject[]{ProvaConstantImpl.create(dynamic.getDynamicGroup()), head.getTerms()});
                removeLiteral.setMetadata("rule", Arrays.asList(dynamic.getDynamicGroup()));
                body.add(this.kb.generateLiteral("@add_group_result", addAndResultList));
                if (groupsNot != null) {
                    removeLiteral.setMetadata("not", Collections.emptyList());
                    rl.setNot(true);
                }
                if (groupsTimeout != null) {
                    removeLiteral.setMetadata("timeout", groupsTimeout);
                }
                if (groupsStop != null) {
                    removeLiteral.setMetadata("stop", groupsStop);
                    rl.setOptional(groupsStop.isEmpty());
                }
                if (groupsOptional != null) {
                    rl.setOptional(true);
                }
                if (groupsPause != null) {
                    removeLiteral.setMetadata("pause", groupsPause);
                }
                if (groupsResume != null) {
                    removeLiteral.setMetadata("resume", groupsResume);
                }
                if (groupsPaused != null) {
                    removeLiteral.setMetadata("paused", groupsPaused);
                    dynamic.pause(ruleid);
                }
                if (mult) {
                    dynamic.setTemplate(true);
                    mult = false;
                }
            }
            if (!mult) {
                body.add(removeLiteral);
            }
            ProvaLiteral[] queryLiterals = copy.getBody();
            for (int i = 1; i < queryLiterals.length; ++i) {
                body.add((ProvaLiteral)queryLiterals[i].cloneWithVariables(variables));
            }
            if (groupsSize != null) {
                if (sizeObject != null) {
                    removeLiteral.setMetadata("size", Arrays.asList(size, sizeReset, sizeObject));
                } else if (sizeReset != null) {
                    removeLiteral.setMetadata("size", Arrays.asList(size, sizeReset));
                } else {
                    removeLiteral.setMetadata("size", Arrays.asList(size));
                    rl.setOptional(Integer.parseInt((String)size) <= 0);
                }
            }
            if (groupsCount != null) {
                if (groupsAnd != null || groupsOr != null) {
                    dynamic.setCountMax(countMax);
                }
                removeLiteral.setMetadata("count", Arrays.asList(countMin, countMax, countMode));
                rl.setOptional(countMin <= 0);
            }
            if (groupsTimer != null) {
                if (timerObject != null) {
                    removeLiteral.setMetadata("timer", Arrays.asList(timer, timerReset, timerObject));
                } else if (timerReset != null) {
                    removeLiteral.setMetadata("timer", Arrays.asList(timer, timerReset));
                } else {
                    removeLiteral.setMetadata("timer", Arrays.asList(timer));
                }
            }
            if (groupsVar != null) {
                removeLiteral.setMetadata("vars", vars);
            }
            ProvaRule temporalRule = this.kb.generateRule(ruleid, head, body.toArray(new ProvaLiteral[0]));
            this.kb.generateRule(ruleid, headControl, new ProvaLiteral[]{removeLiteral});
            if (log.isDebugEnabled()) {
                log.debug("Added temporal rule: " + (dynamic == null ? "" : dynamic.getDynamicGroup()) + " " + head);
            }
            if (dynamic != null && dynamic.isOperatorConfigured()) {
                temporalRule.setMetadata("group", Arrays.asList(dynamic.getDynamicGroup()));
                removeLiteral.setMetadata("group", Arrays.asList(dynamic.getDynamicGroup()));
                if (timeout != null) {
                    long delay = ProvaTimeUtils.timeIntervalInMilliseconds(timeout);
                    List<ProvaDelayedCommand> delayed = ProvaResolutionInferenceEngineImpl.delayedCommands.get();
                    if (groupsAnd != null || groupsOr != null) {
                        delayed.add(new ProvaScheduleGroupCleanupImpl(dynamic, delay));
                    } else {
                        delayed.add(new ProvaScheduleGroupMemberCleanupImpl(xid, dynamic, head.getPredicate(), headControl.getPredicate(), ruleid, delay, 0L, removeLiteral.getMetadata()));
                    }
                }
            } else if (dynamic == null && timeout != null) {
                if (timeout != null) {
                    long delay = ProvaTimeUtils.timeIntervalInMilliseconds(timeout);
                    this.scheduleCleanup(xid, dynamic, head.getPredicate(), headControl.getPredicate(), ruleid, delay, 0L, removeLiteral.getMetadata());
                }
            } else if (dynamic != null && timeout != null) {
                if (timeout != null) {
                    long delay = ProvaTimeUtils.timeIntervalInMilliseconds(timeout);
                    List<ProvaDelayedCommand> delayed = ProvaResolutionInferenceEngineImpl.delayedCommands.get();
                    delayed.add(new ProvaScheduleGroupMemberCleanupImpl(xid, dynamic, head.getPredicate(), headControl.getPredicate(), ruleid, delay, 0L, removeLiteral.getMetadata()));
                }
            } else if (dynamic != null && timer != null && timer != null) {
                long delay = ProvaTimeUtils.timeIntervalInMilliseconds(timer);
                long period = ProvaTimeUtils.timeIntervalInMilliseconds(timerReset);
                List<ProvaDelayedCommand> delayed = ProvaResolutionInferenceEngineImpl.delayedCommands.get();
                if (timerObject instanceof ProvaEventsAccumulator) {
                    ProvaEventsAccumulator acc = (ProvaEventsAccumulator)timerObject;
                    Date now = new Date();
                    if (acc.getDuration() != 0) {
                        Date endDate = DateUtils.addMilliseconds((Date)acc.getStartTime(), (int)acc.getDuration());
                        long timeRemaining = endDate.getTime() - now.getTime();
                        delay = timeRemaining > 0L ? timeRemaining : 0L;
                    } else {
                        acc.setStartTime(now);
                        acc.setDuration((int)period);
                    }
                }
                delayed.add(new ProvaScheduleGroupMemberCleanupImpl(xid, dynamic, head.getPredicate(), headControl.getPredicate(), ruleid, delay, period, removeLiteral.getMetadata()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Possible formatting error in rcvMsg: " + e.getMessage());
        }
        return false;
    }

    private ProvaGroup generateOrReuseDynamicGroup(ProvaGoal goal, List<ProvaVariable> variables, long ruleid, RemoveList rl) {
        Map<String, ProvaGroup> d2g;
        ProvaLiteral literal = goal.getGoal();
        ProvaGroup g = null;
        List<Object> groups = literal.getMetadata("and");
        String dynamicGroup = null;
        if (groups != null && groups.size() != 0) {
            dynamicGroup = this.generateOrReuseDynamicGroup(groups.get(0).toString(), goal, variables);
            if (tlDynamic.get() == null) {
                tlDynamic.set(new HashMap());
            }
            if ((g = (d2g = tlDynamic.get()).get(dynamicGroup)) == null) {
                g = new ProvaAndGroupImpl(dynamicGroup, groups.get(0).toString());
            } else {
                if (g instanceof ProvaAndGroupImpl) {
                    g.addTimeoutEntry(rl);
                    return g;
                }
                if (g instanceof ProvaBasicGroupImpl) {
                    g = new ProvaAndGroupImpl(g);
                } else {
                    throw new RuntimeException("Event group can only have one operator");
                }
            }
            d2g.put(dynamicGroup, g);
            this.dynamic2Group.put(dynamicGroup, g);
            g.start(rl, this.ruleid2Group);
        }
        if ((groups = literal.getMetadata("or")) != null && groups.size() != 0) {
            if (dynamicGroup != null) {
                throw new RuntimeException("Multiple operators on event groups are not allowed");
            }
            dynamicGroup = this.generateOrReuseDynamicGroup(groups.get(0).toString(), goal, variables);
            if (tlDynamic.get() == null) {
                tlDynamic.set(new HashMap());
            }
            if ((g = (d2g = tlDynamic.get()).get(dynamicGroup)) == null) {
                g = new ProvaOrGroupImpl(dynamicGroup, groups.get(0).toString());
            } else {
                if (g instanceof ProvaOrGroupImpl) {
                    g.addTimeoutEntry(rl);
                    return g;
                }
                if (g instanceof ProvaBasicGroupImpl) {
                    g = new ProvaOrGroupImpl(g);
                } else {
                    throw new RuntimeException("Event group can only have one operator");
                }
            }
            d2g.put(dynamicGroup, g);
            this.dynamic2Group.put(dynamicGroup, g);
            this.outcomeRuleid2Group.put(ruleid, g);
            g.start(rl, this.ruleid2Group);
        }
        if ((groups = literal.getMetadata("group")) != null && groups.size() != 0) {
            Map<String, ProvaGroup> d2g2;
            ProvaGroup gg;
            dynamicGroup = this.generateOrReuseDynamicGroup(groups.get(0).toString(), goal, variables);
            if (tlDynamic.get() == null) {
                tlDynamic.set(new HashMap());
            }
            if ((gg = (d2g2 = tlDynamic.get()).get(dynamicGroup)) == null) {
                gg = new ProvaBasicGroupImpl(dynamicGroup, groups.get(0).toString());
                d2g2.put(dynamicGroup, gg);
            } else {
                gg.setExtended(true);
            }
            gg.addRemoveEntry(ruleid, rl);
            List<Object> groupsId = literal.getMetadata("id");
            if (groupsId != null && groupsId.size() != 0) {
                gg.putId2ruleid(groupsId.get(0).toString(), ruleid);
            }
            if (gg.isOperatorConfigured()) {
                gg.start(rl, this.ruleid2Group);
            }
            if (g == null) {
                return gg;
            }
            g.setParent(gg);
            gg.addChild(g);
        }
        return g;
    }

    private String generateOrReuseDynamicGroup(String group, ProvaGoal goal, List<ProvaVariable> variables) {
        String dynamicGroup;
        if (Character.isUpperCase(group.charAt(0))) {
            dynamicGroup = goal.lookupMetadata(group, variables).toString();
        } else {
            Map<String, String> s2d;
            if (tlStatic2Dynamic.get() == null) {
                tlStatic2Dynamic.set(new HashMap());
            }
            if ((dynamicGroup = (s2d = tlStatic2Dynamic.get()).get(group)) == null) {
                dynamicGroup = this.generateCid();
                s2d.put(group, dynamicGroup);
                this.dynamic2Static.put(dynamicGroup, group);
            }
        }
        return dynamicGroup;
    }

    @Override
    public boolean rcvMsgP(ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query, boolean mult) {
        ProvaLiteral literal = goal.getGoal();
        ProvaRule copy = query.cloneRule();
        List<ProvaVariable> variables = copy.getVariables();
        ProvaLiteral literalClone = (ProvaLiteral)literal.cloneWithVariables(variables);
        ProvaList terms = literalClone.getTerms();
        try {
            ProvaObject[] data = terms.getFixed();
            if (!(data[0] instanceof ProvaList && data[1] instanceof ProvaList && data[2] instanceof ProvaList)) {
                return false;
            }
            ProvaObject[] oInbound = ((ProvaList)data[0]).getFixed();
            ProvaObject[] oOutbound = ((ProvaList)data[1]).getFixed();
            ProvaObject[] reaction = ((ProvaList)data[2]).getFixed();
            ProvaObject[] reactionFixed = new ProvaObject[reaction.length - 1];
            System.arraycopy(reaction, 1, reactionFixed, 0, reactionFixed.length);
            ProvaList reactionTerms = ProvaListImpl.create(reactionFixed);
            ProvaObject xid = reactionFixed[0];
            if (!(xid instanceof ProvaConstant) && !(xid instanceof ProvaVariable)) {
                return false;
            }
            if (!(reaction[2] instanceof ProvaConstant) && !(reaction[2] instanceof ProvaVariable)) {
                return false;
            }
            long ruleid = this.reaction_iid.incrementAndGet();
            ProvaConstantImpl tid = ProvaConstantImpl.create(ruleid);
            ArrayList<String> inbound = new ArrayList<String>();
            for (ProvaObject o : oInbound) {
                String s = ((ProvaConstant)o).getObject().toString();
                inbound.add(s);
                List ruleids = this.inbound2ruleids.computeIfAbsent(s, k -> new ArrayList());
                ruleids.add(ruleid);
            }
            ArrayList<String> outbound = new ArrayList<String>();
            for (ProvaObject o : oOutbound) {
                outbound.add(((ProvaConstant)o).getObject().toString());
            }
            this.ruleid2outbound.put(ruleid, outbound);
            ProvaVariable ctlProtocol = CTLPROTOCOL;
            ProvaVariable ctlFrom = CTLFROM;
            ProvaList headControlList = ProvaListImpl.create(new ProvaObject[]{tid, ctlProtocol, ctlFrom, EOF, terms});
            ProvaLiteral head = this.kb.generateHeadLiteral("rcvMsg", reactionTerms);
            ProvaLiteral headControl = this.kb.generateLiteral("@temporal_rule_control", (ProvaList)headControlList.cloneWithVariables(variables));
            ArrayList<ProvaLiteral> body = new ArrayList<ProvaLiteral>();
            ProvaList removeList = ProvaListImpl.create(new ProvaObject[]{ProvaConstantImpl.create(head.getPredicate()), ProvaConstantImpl.create(headControl.getPredicate()), tid, head.getTerms()});
            List<ProvaLiteral> guard = literalClone.getGuard();
            if (guard != null) {
                body.addAll(guard);
            }
            if (data.length > 3 && data[3] instanceof ProvaList && ((ProvaConstant)((ProvaList)data[3]).getFixed()[0]).getObject().toString().equals("condition")) {
                String symbol = ((ProvaConstant)((ProvaList)((ProvaList)data[3]).getFixed()[1]).getFixed()[0]).getObject().toString();
                body.add(this.kb.generateLiteral(symbol, ((ProvaList)((ProvaList)data[3]).getFixed()[1]).getFixed(), 1));
            }
            if (!mult) {
                body.add(this.kb.generateLiteral("@temporal_rule_remove", removeList));
            }
            ProvaLiteral[] queryLiterals = copy.getBody();
            for (int i = 1; i < queryLiterals.length; ++i) {
                body.add((ProvaLiteral)queryLiterals[i].cloneWithVariables(variables));
            }
            ProvaRule temporalRule = this.kb.generateRule(ruleid, head, body.toArray(new ProvaLiteral[0]));
            temporalRule = this.kb.generateRule(ruleid, headControl, new ProvaLiteral[]{this.kb.generateLiteral("@temporal_rule_remove", removeList)});
            if (log.isDebugEnabled()) {
                log.debug("Added temporal rule: " + head);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void scheduleCleanup(ProvaGroup dynamic, long delay) {
        dynamic.setTimeout(delay);
        final String dynamicGroup = dynamic.getDynamicGroup();
        TimerTask cleanup = new TimerTask(){

            @Override
            public void run() {
                ProvaMessengerImpl.this.removeGroup(dynamicGroup, true);
            }
        };
        ScheduledFuture<?> future = this.timers.schedule(cleanup, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void scheduleCleanup(ProvaObject xid, ProvaGroup group, final ProvaPredicate p1, final ProvaPredicate p2, final long ruleid, long delay, long period, final Map<String, List<Object>> metadata) {
        final String protocol = xid == null || xid instanceof ProvaVariable ? "self" : "async";
        final String cid = xid == null || xid instanceof ProvaVariable ? "basic" : ((ProvaConstant)xid).getObject().toString();
        TimerTask cleanup = new TimerTask(){

            @Override
            public void run() {
                if ("self".equals(protocol)) {
                    ProvaMessengerImpl.this.prova.executeTask(0L, () -> {
                        ProvaKnowledgeBase provaKnowledgeBase = ProvaMessengerImpl.this.kb;
                        synchronized (provaKnowledgeBase) {
                            ProvaMessengerImpl.this.removeTemporalRule(p1, p2, ruleid, true, null, metadata);
                        }
                    }, ProvaThreadpoolEnum.MAIN);
                } else {
                    ProvaMessengerImpl.this.prova.executeTask(ProvaMessengerImpl.partitionKey(cid), () -> {
                        ProvaKnowledgeBase provaKnowledgeBase = ProvaMessengerImpl.this.kb;
                        synchronized (provaKnowledgeBase) {
                            ProvaMessengerImpl.this.removeTemporalRule(p1, p2, ruleid, true, null, metadata);
                        }
                    }, ProvaThreadpoolEnum.CONVERSATION);
                }
            }
        };
        ScheduledFuture<?> future = period == 0L ? this.timers.schedule(cleanup, delay, TimeUnit.MILLISECONDS) : this.timers.scheduleAtFixedRate(cleanup, delay, period, TimeUnit.MILLISECONDS);
        if (group != null) {
            group.setTimerFuture(future);
        }
    }

    @Override
    public void addMsg(ProvaList terms) {
        ProvaObject[] data = terms.getFixed();
        ProvaObject lt = data[0];
        String cid = "";
        if (lt instanceof ProvaConstant) {
            cid = (String)((ProvaConstant)lt).getObject();
        }
        String prot = ((ProvaConstant)data[1]).getObject().toString();
        ProvaLiteral lit = this.kb.generateHeadLiteral("rcvMsg", terms);
        ProvaRule goal = this.kb.generateGoal(new ProvaLiteral[]{lit, this.kb.generateLiteral("fail")});
        ProvaThreadpoolEnum dest = ProvaThreadpoolEnum.CONVERSATION;
        if ("self".equals(prot)) {
            dest = ProvaThreadpoolEnum.MAIN;
        } else if ("task".equals(prot)) {
            dest = ProvaThreadpoolEnum.TASK;
        }
        this.prova.submitAsync(ProvaMessengerImpl.partitionKey(cid), goal, dest);
    }

    @Override
    public void addMsg(String xid, Map<String, Object> msg) {
        ProvaList terms = ProvaListImpl.create(new ProvaObject[]{ProvaConstantImpl.create(xid), ProvaMapImpl.wrapValues(msg)});
        ProvaObject[] data = terms.getFixed();
        ProvaLiteral lit = this.kb.generateHeadLiteral("rcvMsg", terms);
        ProvaRule goal = this.kb.generateGoal(new ProvaLiteral[]{lit, this.kb.generateLiteral("fail")});
        this.prova.submitAsync(ProvaMessengerImpl.partitionKey(xid), goal, ProvaThreadpoolEnum.CONVERSATION);
    }

    @Override
    public void addMsg(String xid, String agent, String verb, Object payload) {
        ProvaList terms = ProvaListImpl.create(new ProvaObject[]{ProvaConstantImpl.create(xid), ProvaConstantImpl.create("osgi"), ProvaConstantImpl.create(agent), ProvaConstantImpl.create(verb), payload instanceof Map ? ProvaMapImpl.wrapValues((Map)payload) : ProvaConstantImpl.wrap(payload)});
        ProvaLiteral lit = this.kb.generateHeadLiteral("rcvMsg", terms);
        ProvaRule goal = this.kb.generateGoal(new ProvaLiteral[]{lit, this.kb.generateLiteral("fail")});
        ProvaThreadpoolEnum dest = ProvaThreadpoolEnum.CONVERSATION;
        this.prova.submitAsync(ProvaMessengerImpl.partitionKey(xid), goal, dest);
    }

    @Override
    public synchronized boolean removeTemporalRule(ProvaPredicate predicate, ProvaPredicate predicate2, long key, boolean recursive, ProvaList reaction, Map<String, List<Object>> metadata) {
        boolean rc = true;
        if (log.isDebugEnabled() && reaction != null) {
            log.debug("Removing " + reaction + " at " + key + " with " + metadata);
        }
        if (reaction == null && log.isDebugEnabled()) {
            log.debug("Removing on timeout");
        }
        ProvaGroup group = (ProvaGroup)this.ruleid2Group.get(key);
        List<Object> groups = null;
        if (metadata != null) {
            groups = metadata.get("group");
        }
        boolean avoidRemovingRule = false;
        if (group == null && metadata == null) {
            group = (ProvaGroup)this.outcomeRuleid2Group.get(key);
        }
        if (group == null && metadata != null && groups != null) {
            String dynamic = groups.get(0).toString();
            group = (ProvaGroup)this.dynamic2Group.get(dynamic);
        }
        if (group != null) {
            ProvaGroup.EventDetectionStatus detectionStatus;
            if (group.isPermanent() || group.isTemplate()) {
                avoidRemovingRule = true;
            }
            if ((detectionStatus = group.eventDetected(this.kb, this.prova, key, reaction, metadata, this.ruleid2Group)) == ProvaGroup.EventDetectionStatus.failed) {
                return false;
            }
            if (detectionStatus == ProvaGroup.EventDetectionStatus.complete) {
                this.removeGroup(group.getDynamicGroup(), recursive);
            } else if (detectionStatus == ProvaGroup.EventDetectionStatus.preserved) {
                return rc;
            }
        } else if (metadata != null && metadata.containsKey("count")) {
            List<Object> countList = metadata.get("count");
            int count = (Integer)countList.get(0);
            if (count == 0) {
                return rc;
            }
            countList.set(0, --count);
            if (count != 0) {
                return rc;
            }
        }
        if (avoidRemovingRule) {
            return rc;
        }
        predicate.getClauseSet().removeTemporalClause(key);
        predicate2.getClauseSet().removeTemporalClause(key);
        if (this.ruleid2outbound.get(key) == null) {
            return rc;
        }
        List outbound = (List)this.ruleid2outbound.get(key);
        for (String s : outbound) {
            List inbound = (List)this.inbound2ruleids.get(s);
            if (inbound == null) continue;
            if (recursive) {
                Iterator iter = inbound.iterator();
                while (iter.hasNext()) {
                    long i = (Long)iter.next();
                    iter.remove();
                    this.removeTemporalRule(predicate, predicate2, i, false, reaction, metadata);
                }
            }
            this.inbound2ruleids.remove(s);
        }
        this.ruleid2outbound.remove(key);
        this.outcomeRuleid2Group.remove(key);
        return rc;
    }

    private void removeGroup(String dynamicGroup, boolean recursive) {
        List<ProvaDelayedCommand> delayed;
        ProvaGroup group = (ProvaGroup)this.dynamic2Group.get(dynamicGroup);
        if (group != null && !group.isExtended()) {
            group.stop();
        }
        if ((delayed = ProvaResolutionInferenceEngineImpl.delayedCommands.get()) == null) {
            this.cleanupGroup(dynamicGroup);
            return;
        }
        delayed.add(new ProvaGroupCleanupImpl(dynamicGroup));
        if (tlStatic2Dynamic.get() == null) {
            tlStatic2Dynamic.set(new HashMap());
        }
        Map<String, String> s2d = tlStatic2Dynamic.get();
        s2d.put((String)this.dynamic2Static.get(dynamicGroup), dynamicGroup);
        if (group != null) {
            if (tlDynamic.get() == null) {
                tlDynamic.set(new HashMap());
            }
            Map<String, ProvaGroup> d2g = tlDynamic.get();
            d2g.put(dynamicGroup, group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupGroup(String dynamicGroup) {
        ProvaGroup group = (ProvaGroup)this.dynamic2Group.get(dynamicGroup);
        if (group != null && group.isExtended()) {
            group.setExtended(false);
            return;
        }
        this.dynamic2Static.remove(dynamicGroup);
        if (group != null) {
            ProvaKnowledgeBase provaKnowledgeBase = this.kb;
            synchronized (provaKnowledgeBase) {
                group.cleanup(this.kb, this.prova, this.ruleid2Group, this.dynamic2Group);
            }
        }
    }

    @Override
    public void addGroupResult(ProvaList terms) {
        ProvaObject[] fixed = terms.getFixed();
        String dynamicGroup = (String)((ProvaConstant)fixed[0]).getObject();
        ProvaGroup group = (ProvaGroup)this.dynamic2Group.get(dynamicGroup);
        if (group != null) {
            if (group.isTemplate()) {
                dynamicGroup = this.generateCid();
                group = group.clone();
                group.setDynamicGroup(dynamicGroup);
                group.setTemplate(false);
                group.start(this.ruleid2Group);
                this.dynamic2Group.put(dynamicGroup, group);
                if (log.isDebugEnabled()) {
                    log.debug("Group " + dynamicGroup + " is a template/concrete");
                }
            }
            group.addResult((ProvaList)fixed[1]);
            if (tlStatic2Dynamic.get() == null) {
                tlStatic2Dynamic.set(new HashMap());
            }
            Map<String, String> s2d = tlStatic2Dynamic.get();
            s2d.putIfAbsent(group.getStaticGroup(), dynamicGroup);
            if (tlDynamic.get() == null) {
                tlDynamic.set(new HashMap());
            }
            Map<String, ProvaGroup> d2g = tlDynamic.get();
            d2g.putIfAbsent(dynamicGroup, group);
        } else if (log.isDebugEnabled()) {
            log.debug("Group " + dynamicGroup + " is missing");
        }
    }

    public static void cleanupThreadlocals() {
        tlStatic2Dynamic.remove();
        tlDynamic.remove();
    }

    @Override
    public void stop() {
        this.timers.shutdownNow();
    }

    @Override
    public void setService(ProvaMiniService service) {
        this.service = service;
    }

    private class TimerThreadFactory
    implements ThreadFactory {
        private int count = 1;

        private TimerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("Timer-" + this.count++);
            return thread;
        }
    }
}

