/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.messaging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.messaging.ProvaWorkflows;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaMapImpl;
import org.provarules.reference2.ProvaRuleImpl;
import org.provarules.reference2.ProvaUnificationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaWorkflowsImpl
implements ProvaWorkflows {
    private static final Logger log = LoggerFactory.getLogger((String)"prova");
    private ProvaKnowledgeBase kb;
    private ConcurrentMap<String, List<List<ProvaObject>>> join_record = new ConcurrentHashMap<String, List<List<ProvaObject>>>();
    private ConcurrentMap<String, Object[]> predicate_join_record = new ConcurrentHashMap<String, Object[]>();
    private final ConcurrentMap<String, ReentrantLock> predicate_join_locks = new ConcurrentHashMap<String, ReentrantLock>();

    public ProvaWorkflowsImpl(ProvaKnowledgeBase kb) {
        this.kb = kb;
    }

    @Override
    public boolean init_join(ProvaLiteral literal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        ProvaObject[] expectedList;
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = literal.getTerms();
        ProvaList termsCopy = (ProvaList)terms.cloneWithVariables(variables);
        ProvaObject[] data = termsCopy.getFixed();
        if (!(data[0] instanceof ProvaConstant) || !(data[1] instanceof ProvaConstant)) {
            return false;
        }
        String key = ((ProvaConstant)data[0]).getObject().toString() + ((ProvaConstant)data[1]).getObject().toString();
        if (this.join_record.containsKey(key)) {
            return false;
        }
        if (data[2].getClass() == ProvaConstantImpl.class && ((ProvaConstant)data[2]).getObject() instanceof List) {
            List list = (List)((ProvaConstant)data[2]).getObject();
            ArrayList<ProvaObject> wrappedList = new ArrayList<ProvaObject>();
            for (Object o : list) {
                wrappedList.add(ProvaMapImpl.wrap(o));
            }
            expectedList = wrappedList.toArray(new ProvaObject[wrappedList.size()]);
        } else {
            if (!(data[2] instanceof ProvaList)) {
                return false;
            }
            expectedList = ((ProvaList)data[2]).getFixed();
        }
        ArrayList<ProvaObject> waiting = new ArrayList<ProvaObject>(Arrays.asList(expectedList));
        ArrayList complete = new ArrayList();
        ArrayList record = new ArrayList();
        record.add(waiting);
        record.add(complete);
        this.join_record.put(key, record);
        return true;
    }

    @Override
    public boolean join_test(ProvaLiteral literal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = literal.getTerms();
        ProvaList termsCopy = (ProvaList)terms.cloneWithVariables(variables);
        ProvaObject[] data = termsCopy.getFixed();
        if (!(data[1] instanceof ProvaConstant && data[2] instanceof ProvaConstant && data[4] instanceof ProvaVariable)) {
            return false;
        }
        String key = ((ProvaConstant)data[1]).getObject().toString() + ((ProvaConstant)data[2]).getObject().toString();
        List waitingAndComplete = (List)this.join_record.get(key);
        if (waitingAndComplete == null) {
            return false;
        }
        ProvaLiteral goalLit = this.kb.generateLiteral("pred1", ProvaListImpl.create(new ProvaObject[]{data[3]}));
        ProvaRule goal = this.kb.generateGoal(new ProvaLiteral[]{goalLit});
        ListIterator iter = ((List)waitingAndComplete.get(0)).listIterator();
        while (iter.hasNext()) {
            ProvaObject t = ((ProvaObject)iter.next()).cloneWithVariables(variables);
            ProvaLiteral lit = this.kb.generateLiteral("pred1", ProvaListImpl.create(new ProvaObject[]{t}));
            ProvaRule rule = ProvaRuleImpl.createVirtualRule(1L, lit, null);
            ProvaUnificationImpl unification = new ProvaUnificationImpl(goal, rule);
            boolean result = unification.unify();
            if (!result) continue;
            iter.remove();
            ((List)waitingAndComplete.get(1)).add(data[3]);
            if (!((List)waitingAndComplete.get(0)).isEmpty()) continue;
            this.join_record.remove(key);
            ((ProvaVariable)data[4]).setAssigned(ProvaConstantImpl.create(waitingAndComplete.get(1)));
            return true;
        }
        return false;
    }

    @Override
    public boolean init_predicate_join(ProvaLiteral literal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = literal.getTerms();
        ProvaList termsCopy = (ProvaList)terms.cloneWithVariables(variables);
        ProvaObject[] data = termsCopy.getFixed();
        if (!(data[0] instanceof ProvaConstant && data[1] instanceof ProvaConstant && data[3] instanceof ProvaConstant && data[2] instanceof ProvaList)) {
            return false;
        }
        String key = ((ProvaConstant)data[0]).getObject().toString() + ((ProvaConstant)data[1]).getObject().toString();
        if (this.predicate_join_record.containsKey(key)) {
            return false;
        }
        ProvaObject[] expectedList = ((ProvaList)data[2]).getFixed();
        ArrayList<ProvaObject> waiting = new ArrayList<ProvaObject>();
        for (ProvaObject expected : expectedList) {
            if (!(expected instanceof ProvaList)) {
                return false;
            }
            waiting.add(expected);
        }
        ArrayList complete = new ArrayList();
        this.predicate_join_record.put(key, new Object[]{((ProvaConstant)data[3]).getObject(), waiting, complete});
        return true;
    }

    @Override
    public boolean stop_predicate_join(ProvaLiteral literal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = literal.getTerms();
        ProvaList termsCopy = (ProvaList)terms.cloneWithVariables(variables);
        ProvaObject[] data = termsCopy.getFixed();
        if (!(data[0] instanceof ProvaConstant) || !(data[1] instanceof ProvaConstant)) {
            return false;
        }
        String key = ((ProvaConstant)data[0]).getObject().toString() + ((ProvaConstant)data[1]).getObject().toString();
        this.predicate_join_record.remove(key);
        ReentrantLock lock = (ReentrantLock)this.predicate_join_locks.get(key);
        try {
            lock.unlock();
            this.predicate_join_locks.remove(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean predicate_join_test(ProvaLiteral literal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        boolean rc;
        block11: {
            ReentrantLock lock;
            rc = false;
            List<ProvaVariable> variables = query.getVariables();
            ProvaList terms = literal.getTerms();
            ProvaList termsCopy = (ProvaList)terms.cloneWithVariables(variables);
            ProvaObject[] data = termsCopy.getFixed();
            if (!(data[0] instanceof ProvaConstant && data[1] instanceof ProvaConstant && data[2] instanceof ProvaList && data[3] instanceof ProvaList)) {
                return false;
            }
            String key = ((ProvaConstant)data[0]).getObject().toString() + ((ProvaConstant)data[1]).getObject().toString();
            ConcurrentMap<String, ReentrantLock> concurrentMap = this.predicate_join_locks;
            synchronized (concurrentMap) {
                lock = (ReentrantLock)this.predicate_join_locks.get(key);
                if (lock == null) {
                    lock = new ReentrantLock();
                    this.predicate_join_locks.put(key, lock);
                }
                lock.lock();
            }
            try {
                Object[] value = (Object[])this.predicate_join_record.get(key);
                String joinPredicate = (String)value[0];
                List complete = (List)value[2];
                if (value[1] instanceof Long) {
                    break block11;
                }
                ProvaLiteral goalLit = this.kb.generateLiteral("pred1", (ProvaList)data[2]);
                ProvaRule goal = this.kb.generateGoal(new ProvaLiteral[]{goalLit});
                List waiting = (List)value[1];
                ListIterator iter = waiting.listIterator();
                while (iter.hasNext()) {
                    ProvaList t = (ProvaList)((ProvaList)iter.next()).cloneWithVariables(variables);
                    ProvaLiteral lit = this.kb.generateLiteral("pred1", t);
                    ProvaRule rule = ProvaRuleImpl.createVirtualRule(1L, lit, null);
                    ProvaUnificationImpl unification = new ProvaUnificationImpl(goal, rule);
                    boolean result = unification.unify();
                    if (!result) continue;
                    iter.remove();
                    complete.add((ProvaList)data[2]);
                    ((ProvaVariable)data[4]).setAssigned(ProvaConstantImpl.create(joinPredicate));
                    ((ProvaVariable)data[5]).setAssigned(ProvaConstantImpl.create(waiting));
                    ((ProvaVariable)data[6]).setAssigned(ProvaConstantImpl.create(complete.size()));
                    ((ProvaVariable)data[7]).setAssigned(ProvaConstantImpl.create(complete));
                    rc = true;
                    break;
                }
            }
            finally {
                if (!rc) {
                    lock.unlock();
                }
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean predicate_join_exit(ProvaLiteral literal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = literal.getTerms();
        ProvaList termsCopy = (ProvaList)terms.cloneWithVariables(variables);
        ProvaObject[] data = termsCopy.getFixed();
        if (!(data[0] instanceof ProvaConstant) || !(data[1] instanceof ProvaConstant)) {
            return false;
        }
        String key = ((ProvaConstant)data[0]).getObject().toString() + ((ProvaConstant)data[1]).getObject().toString();
        try {
            if (!(data[2] instanceof ProvaConstant)) {
            } else {
                Object state = ((ProvaConstant)data[2]).getObject();
                if (state.equals("reset")) {
                    Object[] value = (Object[])this.predicate_join_record.get(key);
                    if (value == null) {
                        boolean bl = false;
                        return bl;
                    }
                    if (value[2] instanceof Integer) {
                        // empty if block
                    }
                    List waiting = (List)value[1];
                    List complete = (List)value[2];
                    waiting.addAll(complete);
                    complete.clear();
                } else if (state.equals("stop")) {
                    log.debug("Cleaning up a pattern join instance " + key);
                    this.predicate_join_record.remove(key);
                }
            }
        }
        finally {
            ReentrantLock lock = (ReentrantLock)this.predicate_join_locks.get(key);
            lock.unlock();
        }
        return false;
    }
}

