/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.messaging.where;

import org.antlr.runtime.tree.Tree;
import org.provarules.reference2.messaging.where.WhereBinaryOperation;
import org.provarules.reference2.messaging.where.WhereComparison;
import org.provarules.reference2.messaging.where.WhereInOperator;
import org.provarules.reference2.messaging.where.WhereNode;
import org.provarules.reference2.messaging.where.WhereNotEqual;
import org.provarules.reference2.messaging.where.WhereNotOperator;

public class WhereTreeVisitor {
    private WhereTreeVisitor() {
    }

    private static WhereNode createBinaryOperation(Tree tree, WhereBinaryOperation.Operator op) {
        return new WhereBinaryOperation(WhereTreeVisitor.visit(tree.getChild(0)), WhereTreeVisitor.visit(tree.getChild(1)), op);
    }

    private static WhereNode createComparison(Tree tree, WhereComparison.Type type) {
        return new WhereComparison(tree.getChild(0).toString(), tree.getChild(1).toString(), type);
    }

    public static WhereNode visit(Tree tree) {
        String type;
        switch (type = tree.toString()) {
            case "and": {
                return WhereTreeVisitor.createBinaryOperation(tree, WhereBinaryOperation.Operator.And);
            }
            case "or": {
                return WhereTreeVisitor.createBinaryOperation(tree, WhereBinaryOperation.Operator.Or);
            }
            case "xor": {
                return WhereTreeVisitor.createBinaryOperation(tree, WhereBinaryOperation.Operator.Xor);
            }
            case "not": {
                return new WhereNotOperator(WhereTreeVisitor.visit(tree.getChild(0)));
            }
            case "<": {
                return WhereTreeVisitor.createComparison(tree, WhereComparison.Type.LessThan);
            }
            case "<=": {
                return WhereTreeVisitor.createComparison(tree, WhereComparison.Type.LessThanOrEqual);
            }
            case ">": {
                return WhereTreeVisitor.createComparison(tree, WhereComparison.Type.GreaterThan);
            }
            case ">=": {
                return WhereTreeVisitor.createComparison(tree, WhereComparison.Type.GreaterThanOrEqual);
            }
            case "!=": {
                String compareTo = tree.getChild(1).toString();
                if (compareTo.startsWith("'") || Character.isLetter(compareTo.charAt(0))) {
                    return new WhereNotEqual(tree.getChild(0).toString(), compareTo);
                }
                return WhereTreeVisitor.createComparison(tree, WhereComparison.Type.NotEqual);
            }
            case "IN": {
                return new WhereInOperator(tree);
            }
        }
        return null;
    }
}

