/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.util2;

public class ProvaTimeUtils {
    private static final String[][] TIME_PERIODS = new String[][]{{"d", "day", "days"}, {"h", "hour", "hours"}, {"m", "min", "minute", "minutes"}, {"s", "sec", "seconds"}, {"ms", "msec", "millis", "milliseconds"}};
    private static final long[] TIME_PERIODS_MULTIPLIERS = new long[]{86400000L, 3600000L, 60000L, 1000L, 1L};

    public static long timeIntervalInMilliseconds(Object o) {
        try {
            String text = o.toString();
            String[] s = text.split(" ");
            if (s.length == 1) {
                return Long.parseLong(text);
            }
            return ProvaTimeUtils.timeIntervalInMilliseconds(0L, text, s, 0, 0);
        }
        catch (Exception e) {
            throw new RuntimeException("Incorrect time period format: " + o);
        }
    }

    private static long timeIntervalInMilliseconds(long total, String text, String[] s, int soffset, int offset) {
        long number = Long.parseLong(s[soffset]);
        for (int i = offset; i < TIME_PERIODS.length; ++i) {
            for (String t : TIME_PERIODS[i]) {
                if (!t.equals(s[soffset + 1])) continue;
                long current = total + number * TIME_PERIODS_MULTIPLIERS[i];
                return i == 4 || soffset + 2 == s.length ? current : ProvaTimeUtils.timeIntervalInMilliseconds(current, text, s, soffset + 2, i + 1);
            }
        }
        throw new RuntimeException("Incorrect time period format: " + text);
    }
}

