/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.parser2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonErrorNode;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeNodeStream;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaResultSet;
import org.provarules.kernel2.ProvaRule;
import org.provarules.parser.Prova2Lexer;
import org.provarules.parser.Prova2Parser;
import org.provarules.parser.ProvaWalker2;
import org.provarules.parser2.ProvaAST;
import org.provarules.parser2.ProvaErrorNode;
import org.provarules.parser2.ProvaErrorReporter;
import org.provarules.parser2.ProvaParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaParserImpl {
    private static final Logger log = LoggerFactory.getLogger((String)"prova");
    public static ThreadLocal<Object[]> tlObjects = new ThreadLocal();
    public static ThreadLocal<ProvaKnowledgeBase> tlKB = new ThreadLocal();
    private static ThreadLocal<Random> tlRandom = new ThreadLocal();
    public static ThreadLocal<ProvaResultSet> tlRS = new ThreadLocal();
    public static ThreadLocal<String> tlSrc = new ThreadLocal();
    private String src;
    private final Object[] objects;
    private static final TreeAdaptor adaptor = new CommonTreeAdaptor(){

        public Object create(Token payload) {
            return new ProvaAST(payload);
        }

        public void addChild(Object t1, Object t2) {
            ProvaAST ast1 = (ProvaAST)((Object)t1);
            ProvaAST ast2 = (ProvaAST)((Object)t2);
            if (ast1.getLine() == 0) {
                ast1.setLine(ast2.getLine());
                ast1.setColumn(ast2.getColumn());
            }
            super.addChild(t1, t2);
        }

        public Object errorNode(TokenStream ts, Token t1, Token t2, RecognitionException rex) {
            ProvaErrorNode pen = new ProvaErrorNode(null);
            pen.setErrorNode((CommonErrorNode)super.errorNode(ts, t1, t2, rex));
            return pen;
        }
    };

    public ProvaParserImpl(String src, Object[] objects) {
        this.src = src;
        this.objects = objects;
    }

    public List<ProvaRule> parse(ProvaKnowledgeBase kb, ProvaResultSet resultSet, BufferedReader in) throws ProvaParsingException, IOException {
        ArrayList<ProvaRule> rules = new ArrayList<ProvaRule>();
        Prova2Lexer lex = new Prova2Lexer((CharStream)new ANTLRReaderStream((Reader)in));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        Prova2Parser parser = new Prova2Parser((TokenStream)tokens);
        SimpleErrorReporter errorReporter = new SimpleErrorReporter();
        parser.setErrorReporter(errorReporter);
        parser.setTreeAdaptor(adaptor);
        try {
            tlObjects.set(this.objects);
            tlRandom.set(new Random());
            tlKB.set(kb);
            tlRS.set(resultSet);
            tlSrc.set(this.src);
            Prova2Parser.rulebase_return r = parser.rulebase();
            if (!errorReporter.getErrors().errors().isEmpty()) {
                throw errorReporter.getErrors();
            }
            CommonTree tree = (CommonTree)r.getTree();
            if (log.isDebugEnabled()) {
                log.debug(tree.toStringTree());
            }
            CommonTreeNodeStream nodes = new CommonTreeNodeStream(adaptor, (Object)tree);
            ProvaWalker2 walker = new ProvaWalker2((TreeNodeStream)nodes);
            walker.setErrorReporter(errorReporter);
            List results = walker.rulebase();
            for (List result : results) {
                rules.add((ProvaRule)result.get(2));
            }
        }
        catch (Exception e) {
            ProvaParsingException pex = errorReporter.getErrors();
            pex.setSource(this.src);
            if (pex.errors().isEmpty()) {
                pex.addError("0", "Prova walker reported a parsing error");
            }
            if (e instanceof RuntimeException && e.getLocalizedMessage() != null) {
                pex.addError("0", e.getLocalizedMessage());
            }
            pex.setDescription("Syntax errors occurred when parsing");
            throw pex;
        }
        finally {
            if (tlSrc != null) {
                tlSrc.remove();
            }
            if (tlObjects != null) {
                tlObjects.remove();
            }
            if (tlRandom != null) {
                tlRandom.remove();
            }
            if (tlKB != null) {
                tlKB.remove();
            }
            if (tlRS != null) {
                tlRS.remove();
            }
        }
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProvaRule> parse(ProvaKnowledgeBase kb, ProvaResultSet resultSet, String filename) throws IOException, ProvaParsingException {
        File file = new File(filename);
        try (InputStream is = null;){
            BufferedReader in;
            if (!file.exists() || !file.canRead()) {
                try {
                    is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
                    in = new BufferedReader(new InputStreamReader(is));
                }
                catch (Exception ex1) {
                    try {
                        is = ProvaParserImpl.class.getClassLoader().getResourceAsStream(filename);
                        in = new BufferedReader(new InputStreamReader(is));
                    }
                    catch (Exception ex2) {
                        try {
                            is = ProvaParserImpl.class.getResourceAsStream(filename);
                            in = new BufferedReader(new InputStreamReader(is));
                        }
                        catch (Exception ex3) {
                            try {
                                URL url = new URL(filename);
                                in = new BufferedReader(new InputStreamReader(url.openStream()));
                            }
                            catch (Exception ex4) {
                                throw new IOException("Cannot find " + filename);
                            }
                        }
                    }
                }
            } else {
                FileReader fr = new FileReader(file);
                in = new BufferedReader(fr);
            }
            kb.updateContext(filename);
            List<ProvaRule> list = this.parse(kb, resultSet, in);
            return list;
        }
    }

    public static class SimpleErrorReporter
    implements ProvaErrorReporter {
        ProvaParsingException pex = new ProvaParsingException();

        @Override
        public void reportError(String error) {
            String[] e = error.split(" ", 3);
            this.pex.addError(e[1], e[2]);
            log.warn("Error parsing prova: " + error);
        }

        @Override
        public ProvaParsingException getErrors() {
            return this.pex;
        }
    }
}

