/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2;

import java.util.Arrays;
import java.util.List;
import org.provarules.kernel2.ProvaComputable;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaListPtr;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaUnification;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaAnyImpl;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.ProvaListPtrImpl;
import org.provarules.reference2.ProvaMapImpl;
import org.provarules.reference2.ProvaTermImpl;
import org.provarules.reference2.ProvaVariablePtrImpl;
import org.provarules.reference2.operators.ProvaOperator;

public class ProvaListImpl
extends ProvaTermImpl
implements ProvaList,
ProvaComputable {
    private static final long serialVersionUID = -555571145845834681L;
    public static final ProvaListImpl emptyRList = new ProvaListImpl(new ProvaObject[0]);
    private final ProvaObject[] fixed;
    private ProvaObject tail;
    private boolean ground = false;

    public static ProvaList create(ProvaObject[] fixed) {
        if (fixed.length == 0) {
            return emptyRList;
        }
        return new ProvaListImpl(fixed);
    }

    public static ProvaList create(List<ProvaObject> list) {
        if (list.size() == 0) {
            return emptyRList;
        }
        return new ProvaListImpl(list.toArray(new ProvaObject[0]));
    }

    private ProvaListImpl(ProvaObject[] fixed) {
        this.fixed = fixed;
    }

    public static ProvaList create(ProvaObject[] fixed, ProvaObject tail) {
        if (fixed.length == 0) {
            return emptyRList;
        }
        return new ProvaListImpl(fixed, tail);
    }

    private ProvaListImpl(ProvaObject[] fixed, ProvaObject tail) {
        this.fixed = fixed;
        this.tail = tail;
    }

    @Override
    public boolean isGround() {
        return this.ground;
    }

    @Override
    public ProvaObject[] getFixed() {
        return this.fixed;
    }

    public void setTail(ProvaObject tail) {
        this.tail = tail;
    }

    @Override
    public ProvaObject getTail() {
        return this.tail;
    }

    @Override
    public int computeSize() {
        int size = this.fixed.length;
        if (this.tail != null) {
            int tailSize = this.tail.computeSize();
            if (tailSize == -1) {
                return -1;
            }
            size += tailSize;
        }
        return size;
    }

    @Override
    public ProvaObject getRecursivelyAssigned() {
        return this;
    }

    @Override
    public void substituteVariables(ProvaVariablePtr[] varsMap) {
        if (this.ground) {
            return;
        }
        for (int i = 0; i < this.fixed.length; ++i) {
            if (this.fixed[i].getClass() == ProvaConstantImpl.class) continue;
            if (this.fixed[i] instanceof ProvaVariablePtr) {
                this.fixed[i] = varsMap[((ProvaVariablePtr)this.fixed[i]).getIndex()];
                continue;
            }
            if (this.fixed[i] instanceof ProvaList || this.fixed[i] instanceof ProvaListPtr) {
                this.fixed[i].substituteVariables(varsMap);
                continue;
            }
            if (this.fixed[i] instanceof ProvaLiteral) {
                this.fixed[i].substituteVariables(varsMap);
                continue;
            }
            if (!(this.fixed[i] instanceof ProvaMapImpl)) continue;
            this.fixed[i].substituteVariables(varsMap);
        }
        if (this.tail != null) {
            if (this.tail instanceof ProvaVariablePtr) {
                this.tail = varsMap[((ProvaVariablePtr)this.tail).getIndex()];
            } else if (this.tail instanceof ProvaList || this.tail instanceof ProvaListPtr) {
                this.tail.substituteVariables(varsMap);
            }
        }
    }

    @Override
    public ProvaList shallowCopy() {
        int fixedLength = this.fixed.length;
        ProvaObject[] newFixed = Arrays.copyOf(this.fixed, fixedLength);
        return new ProvaListImpl(newFixed, this.tail);
    }

    @Override
    public ProvaList copyWithVariables(List<ProvaVariable> variables) {
        int fixedLength = this.fixed.length;
        ProvaObject[] newFixed = new ProvaObject[fixedLength];
        for (int i = 0; i < fixedLength; ++i) {
            newFixed[i] = this.fixed[i].cloneWithVariables(variables);
        }
        ProvaObject newTail = null;
        if (this.tail != null) {
            newTail = this.tail.cloneWithVariables(variables);
        }
        return new ProvaListImpl(newFixed, newTail);
    }

    @Override
    public ProvaList copyWithBoundVariables(List<ProvaVariable> variables, List<Boolean> isConstant) {
        int fixedLength = this.fixed.length;
        ProvaObject newTail = null;
        if (this.tail != null && (newTail = this.tail.cloneWithBoundVariables(variables, isConstant)) instanceof ProvaList) {
            int i;
            ProvaObject[] newFixed = new ProvaObject[fixedLength += newTail.computeSize()];
            for (i = 0; i < this.fixed.length; ++i) {
                newFixed[i] = this.fixed[i].cloneWithBoundVariables(variables, isConstant);
            }
            ProvaObject[] tailFixed = ((ProvaList)newTail).getFixed();
            while (i < fixedLength) {
                newFixed[i] = tailFixed[i - this.fixed.length];
                ++i;
            }
            return new ProvaListImpl(newFixed, ((ProvaList)newTail).getTail());
        }
        ProvaObject[] newFixed = new ProvaObject[fixedLength];
        for (int i = 0; i < this.fixed.length; ++i) {
            newFixed[i] = this.fixed[i].cloneWithBoundVariables(variables, isConstant);
        }
        return new ProvaListImpl(newFixed, newTail);
    }

    @Override
    public ProvaObject cloneWithBoundVariables(List<ProvaVariable> variables, List<Boolean> changed) {
        if (this.ground) {
            return this;
        }
        return this.copyWithBoundVariables(variables, changed);
    }

    @Override
    public ProvaObject cloneWithVariables(List<ProvaVariable> variables) {
        if (this.ground) {
            return this;
        }
        return this.copyWithVariables(variables);
    }

    @Override
    public ProvaObject cloneWithVariables(List<ProvaVariable> variables, int offset) {
        if (this.ground) {
            return this;
        }
        int fixedLength = this.fixed.length - offset;
        ProvaObject[] newFixed = new ProvaObject[fixedLength];
        if (this.ground) {
            System.arraycopy(this.fixed, offset, newFixed, 0, fixedLength);
        } else {
            for (int i = 0; i < fixedLength; ++i) {
                newFixed[i] = this.fixed[i + offset].cloneWithVariables(variables);
            }
        }
        ProvaObject newTail = null;
        if (this.tail != null) {
            newTail = this.tail.cloneWithVariables(variables);
        }
        return new ProvaListImpl(newFixed, newTail);
    }

    @Override
    public ProvaObject cloneWithVariables(long ruleId, List<ProvaVariable> variables) {
        if (this.ground) {
            return this;
        }
        int fixedLength = this.fixed.length;
        ProvaObject[] newFixed = new ProvaObject[fixedLength];
        for (int i = 0; i < fixedLength; ++i) {
            if (this.fixed[i] == null) {
                throw new RuntimeException("a");
            }
            newFixed[i] = this.fixed[i].cloneWithVariables(ruleId, variables);
        }
        ProvaObject newTail = null;
        if (this.tail != null) {
            newTail = this.tail.cloneWithVariables(ruleId, variables);
        }
        return new ProvaListImpl(newFixed, newTail);
    }

    @Override
    public boolean updateGround(List<ProvaVariable> variables) {
        if (this.ground) {
            return true;
        }
        this.ground = true;
        for (int i = 0; i < this.fixed.length; ++i) {
            ProvaObject o;
            if (this.fixed[i] instanceof ProvaVariablePtr && (o = variables.get(((ProvaVariablePtr)this.fixed[i]).getIndex()).getAssigned()) != null) {
                this.fixed[i] = o;
            }
            if (this.fixed[i].updateGround(variables)) continue;
            this.ground = false;
        }
        if (this.tail != null && !this.tail.updateGround(variables)) {
            this.ground = false;
            return false;
        }
        return this.ground;
    }

    @Override
    public int collectVariables(long ruleId, List<ProvaVariable> variables) {
        if (this.ground) {
            return -1;
        }
        this.ground = true;
        for (int i = 0; i < this.fixed.length; ++i) {
            if (!this.fixed[i].isGround() && this.fixed[i].collectVariables(ruleId, variables) >= 0) {
                this.ground = false;
            }
            if (!(this.fixed[i] instanceof ProvaVariable)) continue;
            this.fixed[i] = new ProvaVariablePtrImpl(ruleId, ((ProvaVariable)this.fixed[i]).getIndex());
        }
        if (this.tail != null) {
            if (!this.tail.isGround() && this.tail.collectVariables(ruleId, variables) >= 0) {
                this.ground = false;
            }
            if (this.tail instanceof ProvaVariable) {
                this.tail = new ProvaVariablePtrImpl(ruleId, ((ProvaVariable)this.tail).getIndex());
            }
        }
        return this.ground ? -1 : 0;
    }

    @Override
    public int computeSize(int offset) {
        return this.computeSize() - offset;
    }

    @Override
    public boolean unify(ProvaObject target, ProvaUnification unification) {
        ProvaListImpl targetList;
        if (target == null) {
            return false;
        }
        if (target instanceof ProvaVariablePtr) {
            ProvaVariablePtr targetVariablePtr = (ProvaVariablePtr)target;
            ProvaVariable targetVariable = unification.getVariableFromVariablePtr(targetVariablePtr);
            ProvaObject assigned = targetVariable.getRecursivelyAssigned();
            if (assigned instanceof ProvaVariable) {
                return assigned.unify(this, unification);
            }
            if (assigned instanceof ProvaConstant) {
                return false;
            }
            if (assigned instanceof ProvaListPtr) {
                return this.unify(((ProvaListPtr)assigned).getAssignedWithOffset(), unification);
            }
            targetList = (ProvaListImpl)assigned;
        } else {
            if (target instanceof ProvaVariable) {
                return target.unify(this, unification);
            }
            if (target instanceof ProvaConstant) {
                return target instanceof ProvaAnyImpl;
            }
            if (target instanceof ProvaListPtr) {
                return this.unify(((ProvaListPtr)target).getAssignedWithOffset(), unification);
            }
            targetList = (ProvaListImpl)target;
        }
        int minFixed = Math.min(this.fixed.length, targetList.fixed.length);
        for (int i = 0; i < minFixed; ++i) {
            boolean result = this.fixed[i].unify(targetList.fixed[i], unification);
            if (result) continue;
            return false;
        }
        if (this.fixed.length == targetList.fixed.length) {
            if (this.tail == null && targetList.tail == null) {
                return true;
            }
            if (this.tail != null && targetList.tail != null) {
                return this.tail.unify(targetList.tail, unification);
            }
            if (this.tail != null) {
                return this.tail.unify(emptyRList, unification);
            }
            return targetList.tail.unify(emptyRList, unification);
        }
        if (this.fixed.length < targetList.fixed.length) {
            if (this.tail instanceof ProvaList) {
                return ((ProvaList)this.tail).unify(0, new ProvaListPtrImpl(targetList, minFixed), unification);
            }
            if (this.tail == null || !(this.tail instanceof ProvaVariablePtr)) {
                return false;
            }
            return this.tail.unify(new ProvaListPtrImpl(targetList, minFixed), unification);
        }
        if (targetList.tail == null) {
            return false;
        }
        return targetList.tail.unify(new ProvaListPtrImpl(this, minFixed), unification);
    }

    @Override
    public boolean unify(int offset, ProvaObject target, ProvaUnification unification) {
        if (target instanceof ProvaVariablePtr) {
            ProvaVariablePtr targetVariablePtr = (ProvaVariablePtr)target;
            ProvaVariable targetVariable = unification.getVariableFromVariablePtr(targetVariablePtr);
            ProvaObject assigned = targetVariable.getRecursivelyAssigned();
            if (assigned instanceof ProvaVariable) {
                return assigned.unify(this, unification);
            }
            if (assigned instanceof ProvaConstant) {
                return false;
            }
        }
        int targetOffset = 0;
        if (target instanceof ProvaListPtr) {
            ProvaListPtr targetListPtr = (ProvaListPtr)target;
            target = targetListPtr.getAssigned();
            targetOffset = targetListPtr.getOffset();
        }
        ProvaListImpl targetList = (ProvaListImpl)target;
        int minFixed = Math.min(this.fixed.length - offset, targetList.fixed.length - targetOffset);
        for (int i = 0; i < minFixed; ++i) {
            boolean result = this.fixed[i + offset].unify(targetList.fixed[i + targetOffset], unification);
            if (result) continue;
            return false;
        }
        if (this.fixed.length - offset == targetList.fixed.length - targetOffset) {
            if (this.tail != null) {
                return this.tail.unify(targetList.tail, unification);
            }
            if (targetList.tail != null) {
                return targetList.tail.unify(null, unification);
            }
            return true;
        }
        if (this.fixed.length - offset < targetList.fixed.length - targetOffset) {
            if (!(this.tail instanceof ProvaVariablePtr)) {
                return false;
            }
            return this.tail.unify(new ProvaListPtrImpl(targetList, targetOffset + minFixed), unification);
        }
        return targetList.tail != null && targetList.tail.unify(new ProvaListPtrImpl(this, offset + minFixed), unification);
    }

    @Override
    public ProvaList rebuild(ProvaUnification unification) {
        if (this.ground || this == emptyRList) {
            return this;
        }
        int fixedLength = this.fixed.length;
        ProvaObject[] newFixed = new ProvaObject[fixedLength];
        boolean changed = false;
        for (int i = 0; i < fixedLength; ++i) {
            if (this.fixed[i].getClass() == ProvaConstantImpl.class) {
                newFixed[i] = this.fixed[i];
                continue;
            }
            if (this.fixed[i] instanceof ProvaVariablePtr) {
                newFixed[i] = unification.rebuild((ProvaVariablePtr)this.fixed[i]);
                changed |= newFixed[i] != this.fixed[i];
                continue;
            }
            if (this.fixed[i] instanceof ProvaList) {
                newFixed[i] = ((ProvaList)this.fixed[i]).rebuild(unification);
                changed |= newFixed[i] != this.fixed[i];
                continue;
            }
            if (this.fixed[i] instanceof ProvaMapImpl) {
                newFixed[i] = ((ProvaMapImpl)this.fixed[i]).rebuild(unification);
                changed |= newFixed[i] != this.fixed[i];
                continue;
            }
            newFixed[i] = this.fixed[i];
        }
        ProvaObject newTail = null;
        if (this.tail != null) {
            if (this.tail instanceof ProvaVariablePtr) {
                newTail = unification.rebuild((ProvaVariablePtr)this.tail);
                changed |= newTail != this.tail;
            } else if (this.tail instanceof ProvaList) {
                newTail = ((ProvaList)this.tail).rebuild(unification);
                changed |= newTail != this.tail;
            } else {
                newTail = this.tail;
            }
            if (newTail instanceof ProvaList) {
                changed = true;
                if (newTail == emptyRList) {
                    newTail = null;
                } else {
                    ProvaObject[] tailFixed = ((ProvaList)newTail).getFixed();
                    ProvaObject[] newFixedExtended = new ProvaObject[fixedLength + tailFixed.length];
                    System.arraycopy(newFixed, 0, newFixedExtended, 0, newFixed.length);
                    System.arraycopy(tailFixed, 0, newFixedExtended, newFixed.length, tailFixed.length);
                    newTail = ((ProvaList)newTail).getTail();
                    newFixed = newFixedExtended;
                }
            }
        }
        if (changed) {
            return new ProvaListImpl(newFixed, newTail);
        }
        return this;
    }

    @Override
    public ProvaObject rebuild(ProvaUnification unification, int offset) {
        int fixedLength = this.fixed.length;
        if (offset < fixedLength) {
            ProvaObject[] newFixed = new ProvaObject[fixedLength - offset];
            for (int i = offset; i < fixedLength; ++i) {
                newFixed[i - offset] = this.fixed[i] instanceof ProvaVariablePtr ? unification.rebuild((ProvaVariablePtr)this.fixed[i]) : (this.fixed[i] instanceof ProvaList ? ((ProvaList)this.fixed[i]).rebuild(unification) : this.fixed[i]);
            }
            ProvaObject newTail = null;
            if (this.tail != null && (newTail = this.tail instanceof ProvaVariablePtr ? unification.rebuild((ProvaVariablePtr)this.tail) : (this.tail instanceof ProvaList ? ((ProvaList)this.tail).rebuild(unification) : this.tail)) instanceof ProvaList) {
                ProvaObject[] tailFixed = ((ProvaList)newTail).getFixed();
                ProvaObject[] newFixedExtended = new ProvaObject[fixedLength + tailFixed.length];
                System.arraycopy(newFixed, 0, newFixedExtended, 0, newFixed.length);
                System.arraycopy(tailFixed, 0, newFixedExtended, newFixed.length, tailFixed.length);
                newTail = ((ProvaList)newTail).getTail();
                newFixed = newFixedExtended;
            }
            return new ProvaListImpl(newFixed, newTail);
        }
        if (offset == fixedLength) {
            // empty if block
        }
        return null;
    }

    @Override
    public ProvaList rebuildSource(ProvaUnification unification) {
        if (this.ground || this == emptyRList) {
            return this;
        }
        ProvaObject[] newFixed = new ProvaObject[this.fixed.length];
        for (int i = 0; i < this.fixed.length; ++i) {
            newFixed[i] = this.fixed[i].getClass() == ProvaConstantImpl.class ? this.fixed[i] : (this.fixed[i] instanceof ProvaVariablePtr ? unification.rebuildSource((ProvaVariablePtr)this.fixed[i]) : (this.fixed[i] instanceof ProvaList ? ((ProvaList)this.fixed[i]).rebuildSource(unification) : (this.fixed[i] instanceof ProvaLiteral ? ((ProvaLiteral)this.fixed[i]).rebuildSource(unification) : (this.fixed[i] instanceof ProvaMapImpl ? ((ProvaMapImpl)this.fixed[i]).rebuildSource(unification) : this.fixed[i]))));
        }
        ProvaObject newTail = null;
        if (this.tail != null && (newTail = this.tail instanceof ProvaVariablePtr ? unification.rebuildSource((ProvaVariablePtr)this.tail) : (this.tail instanceof ProvaList ? ((ProvaList)this.tail).rebuildSource(unification) : this.tail)) instanceof ProvaList) {
            if (newTail == emptyRList) {
                newTail = null;
            } else {
                ProvaObject[] tailFixed = ((ProvaList)newTail).getFixed();
                ProvaObject[] newFixedExtended = new ProvaObject[this.fixed.length + tailFixed.length];
                System.arraycopy(newFixed, 0, newFixedExtended, 0, newFixed.length);
                System.arraycopy(tailFixed, 0, newFixedExtended, newFixed.length, tailFixed.length);
                newTail = ((ProvaList)newTail).getTail();
                newFixed = newFixedExtended;
            }
        }
        return new ProvaListImpl(newFixed, newTail);
    }

    @Override
    public ProvaObject rebuildSource(ProvaUnification unification, int offset) {
        int fixedLength = this.fixed.length;
        if (offset < fixedLength) {
            ProvaObject[] newFixed = new ProvaObject[fixedLength - offset];
            for (int i = offset; i < fixedLength; ++i) {
                newFixed[i - offset] = this.fixed[i] instanceof ProvaVariablePtr ? unification.rebuildSource((ProvaVariablePtr)this.fixed[i]) : (this.fixed[i] instanceof ProvaList ? ((ProvaList)this.fixed[i]).rebuildSource(unification) : this.fixed[i]);
            }
            ProvaObject newTail = null;
            if (this.tail != null && (newTail = this.tail instanceof ProvaVariablePtr ? unification.rebuildSource((ProvaVariablePtr)this.tail) : (this.tail instanceof ProvaList ? ((ProvaList)this.tail).rebuildSource(unification) : this.tail)) instanceof ProvaList) {
                ProvaObject[] tailFixed = ((ProvaList)newTail).getFixed();
                ProvaObject[] newFixedExtended = new ProvaObject[fixedLength + tailFixed.length];
                System.arraycopy(newFixed, 0, newFixedExtended, 0, newFixed.length);
                System.arraycopy(tailFixed, 0, newFixedExtended, newFixed.length, tailFixed.length);
                newTail = ((ProvaList)newTail).getTail();
                newFixed = newFixedExtended;
            }
            return new ProvaListImpl(newFixed, newTail);
        }
        if (offset == fixedLength) {
            // empty if block
        }
        return null;
    }

    public String toString() {
        if (this == emptyRList) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        int fixedLength = this.fixed.length;
        for (int i = 0; i < fixedLength; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.fixed[i]);
        }
        if (this.tail != null) {
            sb.append('|');
            sb.append(this.tail);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String toString(List<ProvaVariable> variables) {
        if (this == emptyRList) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        int fixedLength = this.fixed.length;
        for (int i = 0; i < fixedLength; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.fixed[i].toString(variables));
        }
        if (this.tail != null) {
            sb.append('|');
            sb.append(this.tail.toString(variables));
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String performative() {
        if (this.fixed.length < 4 || !(this.fixed[3] instanceof ProvaConstant)) {
            return null;
        }
        return ((ProvaConstant)this.fixed[3]).getObject().toString();
    }

    @Override
    public Object compute() {
        Object[] args = new Object[this.fixed.length - 1];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.fixed[i + 1].computeIfExpression();
        }
        return ((ProvaOperator)((ProvaConstant)this.fixed[0]).getObject()).evaluate(args);
    }

    @Override
    public Object computeIfExpression() {
        if (this.fixed.length >= 1 && this.fixed.length <= 3 && this.fixed[0] instanceof ProvaConstant && ((ProvaConstant)this.fixed[0]).getObject() instanceof ProvaOperator) {
            return this.compute();
        }
        ProvaObject[] newFixed = new ProvaObject[this.fixed.length];
        for (int i = 0; i < newFixed.length; ++i) {
            newFixed[i] = this.fixed[i].computeProvaIfExpression();
        }
        return ProvaListImpl.create(newFixed);
    }

    @Override
    public ProvaObject computeProvaIfExpression() {
        return this;
    }

    @Override
    public void setGround(boolean ground) {
        this.ground = ground;
    }
}

