/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.kernel2.cache.ProvaCacheState;
import org.provarules.kernel2.cache.ProvaCacheTablet;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaLiteralImpl;
import org.provarules.reference2.ProvaPredicateImpl;
import org.provarules.reference2.ProvaRuleImpl;
import org.provarules.reference2.builtins.ProvaBuiltinImpl;
import org.provarules.reference2.cache.ProvaCacheTabletImpl;
import org.provarules.reference2.cache.ProvaCachedLiteralImpl;
import org.provarules.reference2.cache.ProvaLocalAnswersImpl;
import org.provarules.reference2.cache.ProvaTabletKeyImpl;

public class ProvaCacheImpl
extends ProvaBuiltinImpl {
    private final Map<ProvaTabletKeyImpl, ProvaCacheTablet> caches = new HashMap<ProvaTabletKeyImpl, ProvaCacheTablet>();

    public ProvaCacheImpl(ProvaKnowledgeBase kb) {
        super(kb, "cache");
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node, ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        ProvaLiteral literal = goal.getGoal();
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = literal.getTerms();
        if (terms.getFixed().length == 0) {
            return false;
        }
        ProvaObject first = terms.getFixed()[0];
        if (!(first instanceof ProvaList)) {
            return false;
        }
        ProvaList firstList = (ProvaList)first;
        if (firstList == ProvaListImpl.emptyRList) {
            return false;
        }
        ProvaObject[] fixed = firstList.getFixed();
        ProvaObject first2 = fixed[0];
        if (!(first2 instanceof ProvaConstant) || !(((ProvaConstant)first2).getObject() instanceof String)) {
            return false;
        }
        int arity = fixed.length - 1;
        String symbol = (String)((ProvaConstant)first2).getObject();
        int numBound = 0;
        int mask = 0;
        for (int i = 1; i <= arity; ++i) {
            ProvaObject o = fixed[i];
            mask <<= 1;
            if (o instanceof ProvaVariablePtr) {
                ProvaVariablePtr ptr = (ProvaVariablePtr)o;
                ProvaVariable var = variables.get(ptr.getIndex());
                o = var.getAssigned();
            }
            if (o instanceof ProvaConstant) {
                ++numBound;
                mask |= 1;
                continue;
            }
            if (!(o instanceof ProvaVariable)) continue;
        }
        Object[] data = new Object[numBound];
        int j = 0;
        for (int i = 1; i <= arity; ++i) {
            ProvaObject o = fixed[i];
            if (o instanceof ProvaVariablePtr) {
                ProvaVariablePtr ptr = (ProvaVariablePtr)o;
                ProvaVariable var = variables.get(ptr.getIndex());
                o = var.getAssigned();
            }
            if (!(o instanceof ProvaConstant)) continue;
            data[j++] = ((ProvaConstant)o).getObject();
        }
        ProvaTabletKeyImpl key = new ProvaTabletKeyImpl(symbol, arity, mask);
        ProvaCacheTablet cacheTablet = this.caches.get(key);
        if (cacheTablet == null) {
            cacheTablet = new ProvaCacheTabletImpl(arity);
            this.caches.put(key, cacheTablet);
        }
        ProvaCacheState cacheState = cacheTablet.open(data);
        ProvaLocalAnswersImpl localAnswers = new ProvaLocalAnswersImpl();
        if (cacheState.isOpen()) {
            Collection<ProvaList> answers = cacheState.getSolutions();
            int numAnswers = answers.size();
            ProvaPredicateImpl pred = new ProvaPredicateImpl(symbol, arity, this.kb);
            if (numAnswers != 0) {
                for (ProvaList answer : answers) {
                    ProvaList ls = ProvaListImpl.create(answer.getFixed());
                    ProvaLiteralImpl lit = new ProvaLiteralImpl(pred, ls);
                    ProvaRule clause = ProvaRuleImpl.createVirtualRule(1L, lit, null);
                    pred.addClause(clause);
                }
            }
            ProvaGoal lastGoal = cacheState.getGoal();
            if (!cacheState.isComplete() && !lastGoal.isCut()) {
                Iterator<ProvaRule> iter = lastGoal.getIterator();
                while (iter.hasNext()) {
                    ProvaRule next = iter.next();
                    pred.addClause(next);
                }
            }
            if (pred.getClauseSet().getClauses().size() == 0) {
                return false;
            }
            ProvaObject[] newFixed = new ProvaObject[arity];
            System.arraycopy(fixed, 1, newFixed, 0, fixed.length - 1);
            ProvaList newTerms = ProvaListImpl.create(newFixed, firstList.getTail());
            ProvaCachedLiteralImpl newLiteral = new ProvaCachedLiteralImpl(pred, newTerms, cacheState, localAnswers);
            newLiterals.add(newLiteral);
            if (!lastGoal.isCut()) {
                ProvaList ltls = ProvaListImpl.create(fixed);
                ProvaObject[] newFixed2 = new ProvaObject[]{ProvaConstantImpl.create(cacheState), ltls, ProvaConstantImpl.create(localAnswers), newLiteral, ProvaConstantImpl.create(node)};
                ProvaList newTerms2 = ProvaListImpl.create(newFixed2);
                newLiterals.add(this.kb.generateLiteral("@update_cache", newTerms2));
            }
            return true;
        }
        cacheState.setOpen(true);
        ProvaObject[] newFixed = new ProvaObject[arity];
        System.arraycopy(fixed, 1, newFixed, 0, fixed.length - 1);
        ProvaList newTerms = ProvaListImpl.create(newFixed, firstList.getTail());
        ProvaLiteral newLiteral = this.kb.generateCachedLiteral(symbol, newTerms, cacheState, localAnswers);
        newLiterals.add(newLiteral);
        ProvaList ltls = ProvaListImpl.create(fixed);
        ProvaObject[] newFixed2 = new ProvaObject[]{ProvaConstantImpl.create(cacheState), ltls, ProvaConstantImpl.create(localAnswers), newLiteral, ProvaConstantImpl.create(node)};
        ProvaList newTerms2 = ProvaListImpl.create(newFixed2);
        newLiterals.add(this.kb.generateLiteral("@update_cache", newTerms2));
        return true;
    }
}

