/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.MethodUtils;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaMapImpl;
import org.provarules.reference2.builtins.ProvaBuiltinImpl;

public class ProvaJavaPredicateImpl
extends ProvaBuiltinImpl {
    public ProvaJavaPredicateImpl(ProvaKnowledgeBase kb) {
        super(kb, "pcalc");
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node, ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        Object rc;
        ProvaLiteral literal = goal.getGoal();
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = literal.getTerms();
        ProvaObject[] data = terms.getFixed();
        if (data.length != 3) {
            return false;
        }
        ProvaObject target = data[0];
        if (data[0] instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)data[0];
            target = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        if (!(target instanceof ProvaConstant && data[1] instanceof ProvaConstant && data[2] instanceof ProvaList)) {
            return false;
        }
        Object methodObject = ((ProvaConstant)data[1]).getObject();
        if (!(methodObject instanceof String)) {
            return false;
        }
        String method = (String)methodObject;
        ProvaList argsList = (ProvaList)data[2];
        ArrayList<Object> args = new ArrayList<Object>();
        for (ProvaObject argObject : argsList.getFixed()) {
            if (argObject instanceof ProvaVariablePtr) {
                ProvaVariablePtr varPtr = (ProvaVariablePtr)argObject;
                argObject = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
            }
            if (argObject instanceof ProvaMapImpl) {
                args.add(((ProvaMapImpl)argObject).unwrap());
                continue;
            }
            if (argObject instanceof ProvaConstant) {
                args.add(((ProvaConstant)argObject).getObject());
                continue;
            }
            args.add(argObject);
        }
        try {
            Object targetObject = ((ProvaConstant)target).getObject();
            rc = targetObject instanceof Class ? MethodUtils.invokeStaticMethod((Class)((Class)targetObject), (String)method, (Object[])args.toArray()) : MethodUtils.invokeMethod((Object)((ProvaConstant)target).getObject(), (String)method, (Object[])args.toArray());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        return rc instanceof Boolean ? (Boolean)rc : true;
    }
}

