/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaLiteralImpl;
import org.provarules.reference2.ProvaPredicateImpl;
import org.provarules.reference2.ProvaRuleImpl;
import org.provarules.reference2.builtins.ProvaBuiltinImpl;

public class ProvaReadEnumImpl
extends ProvaBuiltinImpl {
    public ProvaReadEnumImpl(ProvaKnowledgeBase kb) {
        super(kb, "read_enum");
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node, ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        ProvaLiteral literal = goal.getGoal();
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = literal.getTerms();
        ProvaObject[] data = terms.getFixed();
        if (data.length != 2) {
            return false;
        }
        ProvaObject lt = data[0];
        if (lt instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)lt;
            lt = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        if (!(lt instanceof ProvaConstant)) {
            return false;
        }
        Object o = ((ProvaConstant)lt).getObject();
        if (!(o instanceof BufferedReader)) {
            return false;
        }
        BufferedReader in = (BufferedReader)o;
        ProvaObject out = data[1];
        if (out instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)out;
            out = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        if (!(out instanceof ProvaVariable) && !(out instanceof ProvaConstant)) {
            return false;
        }
        String s = null;
        ProvaPredicateImpl pred = null;
        if (out instanceof ProvaVariable) {
            pred = new ProvaPredicateImpl("", 2, this.kb);
        } else if (out instanceof ProvaConstant) {
            s = out.toString();
        }
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if (pred != null) {
                    ProvaList ls = ProvaListImpl.create(new ProvaObject[]{data[0], ProvaConstantImpl.create(line)});
                    ProvaLiteralImpl lit = new ProvaLiteralImpl(pred, ls);
                    ProvaRule clause = ProvaRuleImpl.createVirtualRule(1L, lit, null);
                    pred.addClause(clause);
                    continue;
                }
                if (!line.equals(s)) continue;
                return true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ProvaLiteralImpl newLiteral = new ProvaLiteralImpl(pred, terms);
        newLiterals.add(newLiteral);
        return true;
    }
}

