/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.util.ArrayList;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaPredicate;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.builtins.ProvaSparqlQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaSparqlSelectImpl
extends ProvaSparqlQueryImpl {
    private static final Logger log = LoggerFactory.getLogger(ProvaSparqlSelectImpl.class);

    public ProvaSparqlSelectImpl(ProvaKnowledgeBase kb) {
        super(kb, "sparql_select");
    }

    @Override
    protected boolean processQuery(ProvaPredicate pred, ProvaConstant cqid, RepositoryConnection con, String sparql_query) {
        block14: {
            TupleQueryResult result;
            TupleQuery q;
            try {
                q = con.prepareTupleQuery(QueryLanguage.SPARQL, sparql_query);
            }
            catch (Exception e) {
                log.error("Could not prepare tuple query.");
                if (log.isDebugEnabled()) {
                    log.debug("Exception: ", (Throwable)e);
                }
                return false;
            }
            try {
                result = q.evaluate();
            }
            catch (QueryEvaluationException e) {
                log.error("Could not evaluate tuple query.");
                if (log.isDebugEnabled()) {
                    log.debug("Exception: ", (Throwable)e);
                }
                return false;
            }
            try {
                while (result.hasNext()) {
                    ArrayList<ProvaObject> newterms = new ArrayList<ProvaObject>();
                    for (Binding b : (BindingSet)result.next()) {
                        String val = b.getValue().stringValue();
                        newterms.add(ProvaConstantImpl.create(val));
                    }
                    if (pred == null) {
                        pred = this.kb.getOrGeneratePredicate("sparql_results", newterms.size() + 1);
                    }
                    ProvaSparqlSelectImpl.addFact(pred, cqid, newterms);
                }
            }
            catch (QueryEvaluationException e) {
                log.error("Error while fetching tuple query results.");
                if (log.isDebugEnabled()) {
                    log.debug("Exception: ", (Throwable)e);
                }
                return false;
            }
            try {
                result.close();
            }
            catch (QueryEvaluationException e) {
                log.warn("Could not close result set.");
                if (!log.isDebugEnabled()) break block14;
                log.debug("Exception: ", (Throwable)e);
            }
        }
        return true;
    }
}

