/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.util.List;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaLiteralImpl;
import org.provarules.reference2.ProvaPredicateImpl;
import org.provarules.reference2.ProvaRuleImpl;
import org.provarules.reference2.builtins.ProvaBuiltinImpl;

public class ProvaTokenizeEnumImpl
extends ProvaBuiltinImpl {
    public ProvaTokenizeEnumImpl(ProvaKnowledgeBase kb) {
        super(kb, "tokenize_enum");
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node, ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        ProvaObject lt;
        ProvaLiteral literal = goal.getGoal();
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = literal.getTerms();
        ProvaObject[] data = terms.getFixed();
        if (data.length != 2) {
            return false;
        }
        ProvaObject n_out = data[1];
        if (n_out instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)n_out;
            n_out = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        if ((lt = data[0]) instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)lt;
            lt = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        if (!(lt instanceof ProvaList)) {
            return false;
        }
        ProvaObject[] args = ((ProvaList)lt.cloneWithVariables(variables)).getFixed();
        if (args.length != 2) {
            return false;
        }
        String in = args[0].toString();
        ProvaObject sep = args[1];
        if (sep instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)sep;
            sep = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        String delim = sep.toString();
        String[] tokens = in.split(delim);
        ProvaPredicateImpl pred = new ProvaPredicateImpl("", 2, this.kb);
        for (String token : tokens) {
            ProvaList ls = ProvaListImpl.create(new ProvaObject[]{data[0], ProvaConstantImpl.create(token)});
            ProvaLiteralImpl lit = new ProvaLiteralImpl(pred, ls);
            ProvaRule clause = ProvaRuleImpl.createVirtualRule(1L, lit, null);
            pred.addClause(clause);
        }
        ProvaLiteralImpl newLiteral = new ProvaLiteralImpl(pred, terms);
        newLiterals.add(newLiteral);
        return true;
    }
}

