/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.util.List;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.builtins.ProvaBuiltinImpl;

public class ProvaUnescapeImpl
extends ProvaBuiltinImpl {
    public ProvaUnescapeImpl(ProvaKnowledgeBase kb) {
        super(kb, "unescape");
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node, ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        ProvaLiteral literal = goal.getGoal();
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = literal.getTerms();
        ProvaObject[] data = terms.getFixed();
        if (data.length != 2) {
            return false;
        }
        ProvaObject res = data[1];
        if (res instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)res;
            res = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        if (!(res instanceof ProvaVariable) && !(res instanceof ProvaConstant)) {
            return false;
        }
        ProvaObject lt = data[0];
        if (lt instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)lt;
            lt = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        if (!(lt instanceof ProvaConstant)) {
            return false;
        }
        String in = ((ProvaConstant)lt).getObject().toString();
        if (res instanceof ProvaVariable) {
            ((ProvaVariable)res).setAssigned(ProvaConstantImpl.create(this.unescape(in)));
        } else if (res instanceof ProvaConstant) {
            return ((ProvaConstant)res).getObject().toString().equals(this.unescape(in));
        }
        return true;
    }

    @Override
    public int getArity() {
        return 2;
    }

    private String unescape(String in) {
        int i;
        String metachars = "\"btrn'\\";
        String chars = "\"\b\t\r\n'\\";
        int escape = 92;
        StringBuilder out = new StringBuilder();
        int p = 0;
        int len = in.length();
        while ((i = in.indexOf(92, p)) != -1) {
            out.append(in.substring(p, i));
            if (i + 1 == len) break;
            char meta = in.charAt(i + 1);
            int k = "\"btrn'\\".indexOf(meta);
            if (k == -1) {
                out.append('\\');
                out.append(meta);
            } else {
                out.append("\"\b\t\r\n'\\".charAt(k));
            }
            p = i + 2;
        }
        if (p < len) {
            out.append(in.substring(p));
        }
        return out.toString();
    }
}

