/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.eventing;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.provarules.agent2.ProvaReagent;
import org.provarules.eventing.ProvaEventsAccumulator;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.eventing.ProvaBasicGroupImpl;
import org.provarules.reference2.eventing.ProvaGroup;
import org.provarules.reference2.messaging.RemoveList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaOrGroupImpl
extends ProvaBasicGroupImpl {
    private static final Logger log = LoggerFactory.getLogger((String)"prova.eventing");

    public ProvaOrGroupImpl(String dynamicGroup, String staticGroup) {
        super(dynamicGroup, staticGroup);
        this.results = new ArrayList();
    }

    public ProvaOrGroupImpl(ProvaGroup g) {
        super((ProvaBasicGroupImpl)g);
        g.setConcrete(this);
        this.results = new ArrayList();
    }

    @Override
    public ProvaGroup clone() {
        ProvaOrGroupImpl g = new ProvaOrGroupImpl((ProvaGroup)this);
        g.adjustClone(this);
        return g;
    }

    @Override
    public String getOperatorName() {
        return "or";
    }

    @Override
    public ProvaGroup.EventDetectionStatus eventDetected(ProvaKnowledgeBase kb, ProvaReagent prova, long ruleid, ProvaList reaction, Map<String, List<Object>> metadata, Map<Long, ProvaGroup> ruleid2Group) {
        String id;
        if (reaction == null && !this.removeMap.containsKey(ruleid)) {
            return ProvaGroup.EventDetectionStatus.preserved;
        }
        if (this.paused.contains(ruleid)) {
            this.results.remove(this.results.size() - 1);
            return ProvaGroup.EventDetectionStatus.preserved;
        }
        if (metadata != null && metadata.containsKey("size")) {
            ProvaEventsAccumulator acc;
            List<Object> sizeList = metadata.get("size");
            int size = Integer.parseInt(sizeList.get(0).toString());
            if (size == -1) {
                return ProvaGroup.EventDetectionStatus.preserved;
            }
            if (sizeList.size() > 2) {
                acc = (ProvaEventsAccumulator)sizeList.get(2);
                long totalCount = acc.totalCount();
                if (Long.parseLong(sizeList.get(1).toString()) == totalCount) {
                    sizeList.set(0, 0);
                    size = 0;
                }
            } else {
                sizeList.set(0, Integer.toString(--size));
            }
            if (log.isDebugEnabled()) {
                log.debug("size={}", (Object)size);
            }
            if (size != 0) {
                return ProvaGroup.EventDetectionStatus.preserved;
            }
            if (sizeList.size() > 1) {
                this.permanent = true;
                this.lastReaction = reaction;
                if (sizeList.size() > 2) {
                    acc = (ProvaEventsAccumulator)sizeList.get(2);
                    if (this.lastReaction == null) {
                        this.lastReaction = this.resultRemoveEntry.getReaction();
                    }
                    this.results.clear();
                    this.results.add(acc.clone());
                    acc.clear();
                }
                this.sendGroupResults(this.results, kb, prova);
                if (this.countMax > 0 && this.numEmitted == (long)this.countMax) {
                    return ProvaGroup.EventDetectionStatus.complete;
                }
                this.results = new ArrayList();
                sizeList.set(0, sizeList.get(1));
                this.lastReaction = null;
                return ProvaGroup.EventDetectionStatus.preserved;
            }
            ruleid2Group.remove(ruleid);
            RemoveList r = (RemoveList)this.removeMap.remove(ruleid);
            if (r != null) {
                r.getP1().getClauseSet().removeTemporalClause(ruleid);
                r.getP2().getClauseSet().removeTemporalClause(ruleid);
            }
            if (this.future != null) {
                this.future.cancel(true);
            }
        } else if (metadata != null && metadata.containsKey("timer")) {
            List<Object> timerList = metadata.get("timer");
            if (timerList.size() > 1) {
                this.permanent = true;
                if (reaction != null) {
                    this.lastReaction = reaction;
                    return ProvaGroup.EventDetectionStatus.preserved;
                }
                if (this.lastReaction == null) {
                    this.lastReaction = this.resultRemoveEntry.getReaction().shallowCopy();
                }
                if (log.isDebugEnabled()) {
                    log.debug("resultRemoveEntry.getReaction(): {}", (Object)this.resultRemoveEntry.getReaction());
                    log.debug("Set last reaction to: {}", (Object)this.lastReaction);
                }
                this.results.clear();
                if (timerList.size() > 2) {
                    ProvaEventsAccumulator acc = (ProvaEventsAccumulator)timerList.get(2);
                    this.results.add(acc.clone());
                    acc.clear();
                    Date now = new Date();
                    acc.setStartTime(now);
                } else {
                    this.results.add(ProvaListImpl.emptyRList);
                }
                this.sendGroupResults(this.results, kb, prova);
                if (this.countMax > 0 && this.numEmitted == (long)this.countMax) {
                    return ProvaGroup.EventDetectionStatus.complete;
                }
                this.results = new ArrayList();
                timerList.set(0, timerList.get(1));
                this.lastReaction = null;
                if (log.isDebugEnabled()) {
                    log.debug("resultRemoveEntry.getReaction(): {}", (Object)this.resultRemoveEntry.getReaction());
                }
                return ProvaGroup.EventDetectionStatus.preserved;
            }
        } else if (!this.isPermanent()) {
            ruleid2Group.remove(ruleid);
            RemoveList r = (RemoveList)this.removeMap.remove(ruleid);
            if (r != null && !this.isTemplate()) {
                r.getP1().getClauseSet().removeTemporalClause(ruleid);
                r.getP2().getClauseSet().removeTemporalClause(ruleid);
            }
        }
        if (metadata != null && metadata.containsKey("not")) {
            if (log.isDebugEnabled()) {
                log.debug("@or not complete {}", (Object)this.results);
            }
            return ProvaGroup.EventDetectionStatus.preserved;
        }
        boolean isControlChannel = false;
        if (metadata != null && metadata.containsKey("pause")) {
            List<Object> toPause = metadata.get("pause");
            if (toPause.size() != 0) {
                for (Object ido : toPause) {
                    if (!(ido instanceof String)) continue;
                    id = (String)ido;
                    long ruleidToPause = (Long)this.id2ruleid.get(id);
                    this.pause(ruleidToPause);
                }
            }
            isControlChannel = true;
        }
        if (metadata != null && metadata.containsKey("resume")) {
            List<Object> toResume = metadata.get("resume");
            if (toResume.size() != 0) {
                for (Object ido : toResume) {
                    if (!(ido instanceof String)) continue;
                    id = (String)ido;
                    long ruleidToResume = (Long)this.id2ruleid.get(id);
                    this.resume(ruleidToResume);
                }
            }
            isControlChannel = true;
        }
        if (metadata != null && metadata.containsKey("stop")) {
            List<Object> toStop = metadata.get("stop");
            if (toStop.size() != 0) {
                for (Object ido : toStop) {
                    if (!(ido instanceof String)) continue;
                    id = (String)ido;
                    long ruleidToStop = (Long)this.id2ruleid.get(id);
                    ruleid2Group.remove(ruleidToStop);
                    RemoveList r = (RemoveList)this.removeMap.remove(ruleidToStop);
                    if (r == null) continue;
                    r.getP1().getClauseSet().removeTemporalClause(ruleidToStop);
                    r.getP2().getClauseSet().removeTemporalClause(ruleidToStop);
                }
                if (log.isDebugEnabled()) {
                    log.debug("@or stop(id) complete");
                }
                if (isControlChannel) {
                    return ProvaGroup.EventDetectionStatus.preserved;
                }
                return ProvaGroup.EventDetectionStatus.incomplete;
            }
            this.failed = true;
            if (this.future != null) {
                this.future.cancel(true);
            }
            if (log.isDebugEnabled()) {
                log.debug("@or terminated by @stop");
            }
        } else if (!isControlChannel) {
            if (log.isDebugEnabled()) {
                log.debug("@or complete" + this.results);
                log.debug("Set lastReaction to " + this.lastReaction);
            }
            this.lastReaction = reaction;
        }
        if (isControlChannel || this.isPermanent() && !this.failed) {
            this.lastReaction = null;
            return ProvaGroup.EventDetectionStatus.preserved;
        }
        this.removeMap.clear();
        return ProvaGroup.EventDetectionStatus.complete;
    }

    @Override
    public boolean isOperatorConfigured() {
        return true;
    }

    @Override
    public void childFailed(ProvaGroup child, Map<Long, ProvaGroup> ruleid2Group, Map<String, ProvaGroup> dynamic2Group) {
        this.children.removeIf(provaGroup -> child == provaGroup);
        this.lastReaction = null;
    }
}

