/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.messaging.where;

import java.util.Map;
import org.provarules.reference2.messaging.where.WhereNode;

public class WhereComparison
implements WhereNode {
    private final String compare;
    private final String compareTo;
    private final Type type;

    WhereComparison(String param, String compareTo, Type type) {
        if (param == null) {
            throw new NullPointerException();
        }
        this.compare = param;
        this.compareTo = compareTo;
        this.type = type;
    }

    private Object data(String param, Map<Object, Object> vars, Map<Object, Object> vars2) {
        Object value = vars.get(param);
        return value != null ? value : vars2.get(param);
    }

    @Override
    public boolean evaluate(Map<Object, Object> vars, Map<Object, Object> vars2) {
        Object value = this.data(this.compare, vars, vars2);
        Object other = this.data(this.compareTo, vars, vars2);
        if (value != null) {
            if (value instanceof Number) {
                try {
                    double numval = Double.parseDouble(value.toString());
                    double numother = Double.parseDouble(other.toString());
                    switch (this.type) {
                        case NotEqual: {
                            return numval != numother;
                        }
                        case GreaterThan: {
                            return numval > numother;
                        }
                        case GreaterThanOrEqual: {
                            return numval >= numother;
                        }
                        case LessThan: {
                            return numval < numother;
                        }
                        case LessThanOrEqual: {
                            return numval <= numother;
                        }
                    }
                    return false;
                }
                catch (Exception ex) {
                    return false;
                }
            }
            if (value instanceof String) {
                if (!(other instanceof String)) {
                    return false;
                }
                int result = ((String)value).compareTo((String)other);
                switch (this.type) {
                    case NotEqual: {
                        return result != 0;
                    }
                    case GreaterThan: {
                        return result > 0;
                    }
                    case GreaterThanOrEqual: {
                        return result >= 0;
                    }
                    case LessThan: {
                        return result < 0;
                    }
                    case LessThanOrEqual: {
                        return result <= 0;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public String toString() {
        return this.compare + " " + this.type.toString() + " " + this.compareTo;
    }

    public static enum Type {
        LessThan,
        LessThanOrEqual,
        NotEqual,
        GreaterThan,
        GreaterThanOrEqual,
        In;


        public String toString() {
            switch (this) {
                case NotEqual: {
                    return "!=";
                }
                case GreaterThan: {
                    return ">";
                }
                case GreaterThanOrEqual: {
                    return ">=";
                }
                case LessThan: {
                    return "<";
                }
                case LessThanOrEqual: {
                    return "<=";
                }
                case In: {
                    return " in ";
                }
            }
            return "";
        }
    }
}

