/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.operators;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaObject;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.ProvaMapImpl;
import org.provarules.reference2.operators.ProvaOperator;

public final class ProvaFcalcImpl
implements ProvaOperator {
    private String type;
    private String method;

    ProvaFcalcImpl(String type, String method) {
        this.type = type;
        this.method = method;
    }

    @Override
    public Object evaluate(Object ... na) {
        Object ret;
        ProvaList argsList = (ProvaList)na[1];
        ArrayList<Object> args = new ArrayList<Object>();
        boolean provaMapPresent = false;
        for (ProvaObject po : argsList.getFixed()) {
            if (po instanceof ProvaMapImpl) {
                args.add(((ProvaMapImpl)po).unwrap());
                provaMapPresent = true;
                continue;
            }
            if (po instanceof ProvaConstantImpl) {
                args.add(((ProvaConstant)po).getObject());
                continue;
            }
            args.add(po);
        }
        if (this.type.equals("s")) {
            Class targetClass = (Class)na[0];
            try {
                ret = MethodUtils.invokeStaticMethod((Class)targetClass, (String)this.method, (Object[])args.toArray());
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
            if (provaMapPresent && ret instanceof Map) {
                return ProvaMapImpl.wrapValues((Map)ret);
            }
            return ret;
        }
        Object oTarget = na[0];
        try {
            ret = MethodUtils.invokeMethod((Object)oTarget, (String)this.method, (Object[])args.toArray());
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        if (provaMapPresent && ret instanceof Map) {
            return ProvaMapImpl.wrapValues((Map)ret);
        }
        return ret;
    }

    public String toString() {
        return "f";
    }
}

