/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package adalid.commons.list;

import java.util.Comparator;

/**
 * @author Jorge Campins
 */
public class ListOptionValueComparator implements Comparator<ListOption> {

    @Override
    public int compare(ListOption opt1, ListOption opt2) {
        Long val1 = null;
        Long val2 = null;

        if (opt1.getOptionValue() instanceof Integer) {
            val1 = new Long((Integer) opt1.getOptionValue());
        } else if (opt1.getOptionValue() instanceof Long) {
            val1 = (Long) opt1.getOptionValue();
        }

        if (opt2.getOptionValue() instanceof Integer) {
            val2 = new Long((Integer) opt2.getOptionValue());
        } else if (opt2.getOptionValue() instanceof Long) {
            val2 = (Long) opt2.getOptionValue();
        }

        if (val1 == null && val2 == null) {
            return 0;
        }

        if (val1 == null) {
            return -1;
        }

        if (val2 == null) {
            return 1;
        }

        return val1.compareTo(val2);
    }

}
