/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package adalid.core;

import adalid.core.enums.SortOption;

/**
 * @author Jorge Campins
 */
public class Constants {

    public static final int DEFAULT_ROWS_PER_PAGE = 10;

    public static final int DEFAULT_ROWS_PER_PAGE_LIMIT = 100;

    public static final int MINIMUM_ROWS_PER_PAGE_LIMIT = DEFAULT_ROWS_PER_PAGE / 2;

    public static final int MAXIMUM_ROWS_PER_PAGE_LIMIT = 10 * DEFAULT_ROWS_PER_PAGE_LIMIT;

    public static final int DEFAULT_SELECT_ROWS_LIMIT = 100;

    public static final int MAXIMUM_SELECT_ROWS_LIMIT = 10000; // tree-views could select more rows than table-views

    public static final SortOption DEFAULT_SELECT_SORT_OPTION = SortOption.ASC;

    public static final int DEFAULT_REPORT_ROWS_LIMIT = 10000;

    public static final int MAXIMUM_REPORT_ROWS_LIMIT = 1000000;

    public static final SortOption DEFAULT_REPORT_SORT_OPTION = SortOption.ASC;

    public static final int DEFAULT_EXPORT_ROWS_LIMIT = 10000;

    public static final int MAXIMUM_EXPORT_ROWS_LIMIT = 1000000;

    public static final SortOption DEFAULT_EXPORT_SORT_OPTION = SortOption.ASC;

    public static final int DEFAULT_CHARACTER_KEY_MAX_LENGTH = 30;

    public static final int DEFAULT_NAME_PROPERTY_MAX_LENGTH = 100;

    public static final int DEFAULT_MAX_INPUT_FILE_SIZE = 1000000;

    public static final int DEFAULT_NUMERIC_DIVISOR = 100;

    public static final int DEFAULT_DECIMAL_PRECISION = 16;

    public static final int DEFAULT_DECIMAL_SCALE = 2;

    public static final int DEFAULT_TIME_PRECISION = 3;

    public static final int DEFAULT_YEAR_RANGE = 5;

    public static final int MAX_DECIMAL_PRECISION = 60; // Decillion (Novemdecillion @ USA & Canada)

    public static final int MAX_BYTE_DIVISOR = 100;

    public static final int MAX_SHORT_DIVISOR = 10000;

    public static final int MAX_INTEGER_DIVISOR = 1000000;

    public static final int MAX_STRING_LENGTH = 4000;

    public static final int MAX_TIME_PRECISION = 6;

    public static final int MAX_YEAR_RANGE = 100;

    public static final int MAX_SERIES_START = 2000000000; // 1000000000

    public static final int MAX_SERIES_STOP = 2100000000; // 2000000000

    public static final int MAX_SERIES_STEP = 1000000; // 1000000000

    public static final int MAX_ENTITY_SERIES_START = 2000000000; // 1000000000

    public static final int MAX_ENTITY_SERIES_STOP = 2100000000; // 2000000000

    public static final int MAX_ENTITY_SERIES_STEP = 1000000; // 1000000000

    public static final String SERIES_BY_AGGREGATE = "seriesByAggregate";

    public static final String SERIES_BY_GROUP = "seriesByGroup";

    /**
     * Java email validation using regex. https://howtodoinjava.com/regex/java-regex-validate-email-address/
     */
    public static final String EMAIL_REGEX = "^[\\w!#$%&’*+/=?`{|}~^-]+(?:\\.[\\w!#$%&’*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$";

    /**
     * DEFAULT_ROWS_PER_PAGE getter (for velocity templates)
     *
     * @return DEFAULT_ROWS_PER_PAGE
     */
    public static int getDefaultRowsPerPage() {
        return DEFAULT_ROWS_PER_PAGE;
    }

    /**
     * DEFAULT_ROWS_PER_PAGE_LIMIT getter (for velocity templates)
     *
     * @return DEFAULT_ROWS_PER_PAGE_LIMIT
     */
    public static int getDefaultRowsPerPageLimit() {
        return DEFAULT_ROWS_PER_PAGE_LIMIT;
    }

    /**
     * MAXIMUM_ROWS_PER_PAGE_LIMIT getter (for velocity templates)
     *
     * @return MAXIMUM_ROWS_PER_PAGE_LIMIT
     */
    public static int getMaximumRowsPerPageLimit() {
        return MAXIMUM_ROWS_PER_PAGE_LIMIT;
    }

    /**
     * MINIMUM_ROWS_PER_PAGE_LIMIT getter (for velocity templates)
     *
     * @return MINIMUM_ROWS_PER_PAGE_LIMIT
     */
    public static int getMinimumRowsPerPageLimit() {
        return MINIMUM_ROWS_PER_PAGE_LIMIT;
    }

    /**
     * DEFAULT_SELECT_ROWS_LIMIT getter (for velocity templates)
     *
     * @return DEFAULT_SELECT_ROWS_LIMIT
     */
    public static int getDefaultSelectRowsLimit() {
        return DEFAULT_SELECT_ROWS_LIMIT;
    }

    /**
     * DEFAULT_SELECT_SORT_OPTION getter (for velocity templates)
     *
     * @return DEFAULT_SELECT_SORT_OPTION
     */
    public static SortOption getDefaultSelectSortOption() {
        return DEFAULT_SELECT_SORT_OPTION;
    }

    /**
     * DEFAULT_REPORT_ROWS_LIMIT getter (for velocity templates)
     *
     * @return DEFAULT_REPORT_ROWS_LIMIT
     */
    public static int getDefaultReportRowsLimit() {
        return DEFAULT_REPORT_ROWS_LIMIT;
    }

    /**
     * DEFAULT_REPORT_SORT_OPTION getter (for velocity templates)
     *
     * @return DEFAULT_REPORT_SORT_OPTION
     */
    public static SortOption getDefaultReportSortOption() {
        return DEFAULT_REPORT_SORT_OPTION;
    }

    /**
     * DEFAULT_EXPORT_ROWS_LIMIT getter (for velocity templates)
     *
     * @return DEFAULT_EXPORT_ROWS_LIMIT
     */
    public static int getDefaultExportRowsLimit() {
        return DEFAULT_EXPORT_ROWS_LIMIT;
    }

    /**
     * DEFAULT_EXPORT_SORT_OPTION getter (for velocity templates)
     *
     * @return DEFAULT_EXPORT_SORT_OPTION
     */
    public static SortOption getDefaultExportSortOption() {
        return DEFAULT_EXPORT_SORT_OPTION;
    }

}
