/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package adalid.core.annotations;

import adalid.core.enums.Kleenean;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * La anotación EntityClass se utiliza para establecer atributos básicos de la entidad.
 *
 * @author Jorge Campins
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface EntityClass {

    /**
     * base indica si la entidad es, o no, una entidad de la base operativa de la aplicación. La base operativa es el conjunto de entidades necesarias
     * para la prestación de los servicios básicos de la aplicación. Su valor es uno de los elementos de la enumeración Kleenean. Seleccione TRUE si
     * la entidad es una entidad de la base operativa; en caso contrario, seleccione FALSE. Alternativamente, omita el elemento o seleccione
     * UNSPECIFIED para utilizar el valor predeterminado del atributo. El valor predeterminado del atributo es FALSE.
     *
     * @return base
     */
    Kleenean base() default Kleenean.UNSPECIFIED; // FALSE

    /**
     * catalog indica si la entidad es, o no, una entidad del catálogo de la aplicación. El catálogo es el conjunto de entidades de configuración
     * básica (netadata) de la aplicación. Su valor es uno de los elementos de la enumeración Kleenean. Seleccione TRUE si la entidad es una entidad
     * del catálogo; en caso contrario, seleccione FALSE. Alternativamente, omita el elemento o seleccione UNSPECIFIED para utilizar el valor
     * predeterminado del atributo. El valor predeterminado del atributo es FALSE.
     *
     * @return catalog
     */
    Kleenean catalog() default Kleenean.UNSPECIFIED; // FALSE

    /**
     * independent indica si la entidad es, o no, existencialmente independiente. Su valor es uno de los elementos de la enumeración Kleenean.
     * Seleccione TRUE si la entidad es existencialmente independiente; en caso contrario, seleccione FALSE. Alternativamente, omita el elemento o
     * seleccione UNSPECIFIED para utilizar el valor predeterminado del atributo. El valor predeterminado del atributo es TRUE.
     *
     * @return independent
     */
    Kleenean independent() default Kleenean.UNSPECIFIED; // TRUE

    /**
     * variant indica si la entidad es, o no, una entidad variante. Su valor es uno de los elementos de la enumeración Kleenean. Seleccione TRUE si la
     * entidad es variante; en caso contrario, seleccione FALSE. Alternativamente, omita el elemento o seleccione UNSPECIFIED para utilizar el valor
     * predeterminado del atributo. El valor predeterminado del atributo es FALSE.
     *
     * @return variant
     */
    Kleenean variant() default Kleenean.UNSPECIFIED; // FALSE

    /**
     * resourceType especifica el tipo de recurso de la entidad. Su valor es uno de los elementos de la enumeración ResourceType. Seleccione
     * CONFIGURATION, TESTING u OPERATION si la entidad es de configuración, prueba u operación, respectivamente. Alternativamente, omita el elemento
     * o seleccione UNSPECIFIED si el tipo de recurso es indeterminado.
     *
     * @return resourceType
     */
    ResourceType resourceType() default ResourceType.UNSPECIFIED;

    /**
     * resourceGender especifica el género gramatical de la entidad. Su valor es uno de los elementos de la enumeración ResourceGender. Seleccione
     * MASCULINE, FEMININE, COMMON o NEUTER si la entidad es de género masculino, femenino, común o neutro, respectivamente. Alternativamente, omita
     * el elemento o seleccione UNSPECIFIED para utilizar el valor predeterminado del atributo. El valor predeterminado es NEUTER.
     *
     * @return resourceGender
     */
    ResourceGender resourceGender() default ResourceGender.UNSPECIFIED;

//  String propertiesPrefix() default "";
//
//  String propertiesSuffix() default "";
//
    /**
     * helpFile especifica el nombre del archivo de ayuda de la entidad, sin la ruta. Si utiliza la plataforma jee2, el archivo debe estar almacenado
     * en el subdirectorio resources/media/custom-made del módulo Web de la aplicación.
     *
     * @return helpFile
     */
    String helpFile() default "";

    /**
     * startWith específica el valor de la clave primaria de la primera instancia definida en la meta entidad. Su valor debe ser un número entero
     * entre 0 y 2.147.483.647. El valor predeterminado es 1.
     *
     * @return startWith
     */
    int startWith() default 1;

}
