/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package adalid.core.annotations;

import adalid.core.Constants;
import adalid.core.enums.Kleenean;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * La anotación EntityTableView se utiliza para controlar la generación de las vistas (páginas) de consulta y/o registro tabular de la entidad,
 * conocidas como Tablas de Consulta y/o Tablas de Registro, respectivamente.
 *
 * @author Jorge Campins
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface EntityTableView {

    /**
     * enabled indica si se debe, o no, generar las vistas. Su valor es uno de los elementos de la enumeración Kleenean. Seleccione TRUE para generar
     * las vistas; en caso contrario, seleccione FALSE. Alternativamente, omita el elemento o seleccione UNSPECIFIED para utilizar el valor
     * predeterminado del atributo. El valor predeterminado del atributo es TRUE.
     *
     * @return enabled
     */
    Kleenean enabled() default Kleenean.UNSPECIFIED; // TRUE

    /**
     * inserts indica si las vistas deben permitir, o no, agregar nuevas instancias de la entidad, es decir, insertar nuevas filas a la tabla de la
     * base de datos correspondiente a la entidad. Este elemento es relevante solo si el valor especificado, o determinado, para el elemento enabled
     * es TRUE. Su valor es uno de los elementos de la enumeración Kleenean. Seleccione TRUE para permitir agregar; en caso contrario, seleccione
     * FALSE. Alternativamente, omita el elemento o seleccione UNSPECIFIED para utilizar el valor predeterminado del atributo. El valor predeterminado
     * del atributo es TRUE.
     *
     * @return inserts
     */
    Kleenean inserts() default Kleenean.UNSPECIFIED; // TRUE

    /**
     * updates indica si las vistas deben permitir, o no, modificar instancias de la entidad, es decir, actualizar filas de la tabla de la base de
     * datos correspondiente a la entidad. Este elemento es relevante solo si el valor especificado, o determinado, para el elemento enabled es TRUE.
     * Su valor es uno de los elementos de la enumeración Kleenean. Seleccione TRUE para permitir modificar; en caso contrario, seleccione FALSE.
     * Alternativamente, omita el elemento o seleccione UNSPECIFIED para utilizar el valor predeterminado del atributo. El valor predeterminado del
     * atributo es TRUE.
     *
     * @return updates
     */
    Kleenean updates() default Kleenean.UNSPECIFIED; // TRUE

    /**
     * deletes indica si las vistas deben permitir, o no, eliminar instancias de la entidad, es decir, eliminar filas de la tabla de la base de datos
     * correspondiente a la entidad. Este elemento es relevante solo si el valor especificado, o determinado, para el elemento enabled es TRUE. Su
     * valor es uno de los elementos de la enumeración Kleenean. Seleccione TRUE para permitir eliminar; en caso contrario, seleccione FALSE.
     * Alternativamente, omita el elemento o seleccione UNSPECIFIED para utilizar el valor predeterminado del atributo. El valor predeterminado del
     * atributo es TRUE.
     *
     * @return deletes
     */
    Kleenean deletes() default Kleenean.UNSPECIFIED; // TRUE

    /**
     * heading indica si las vistas Maestro/Detalle, donde la entidad es el detalle, muestran, o no, un encabezado con propiedades del maestro. Este
     * elemento es relevante solo si el valor especificado, o determinado, para el elemento enabled es TRUE. Su valor es uno de los elementos de la
     * enumeración Kleenean. Seleccione TRUE para mostrar el encabezado; en caso contrario, seleccione FALSE. Alternativamente, omita el elemento o
     * seleccione UNSPECIFIED para utilizar el valor predeterminado del atributo. El valor predeterminado del atributo es TRUE.
     *
     * @return heading
     */
    Kleenean heading() default Kleenean.UNSPECIFIED; // FALSE

    /**
     * rowsLimit específica el máximo número de filas por página que muestra la vista. Este elemento es relevante solo si el valor especificado, o
     * determinado, para el elemento enabled es TRUE. Su valor debe ser un número entero entre 5 y 1000. El valor predeterminado es 100.
     *
     * @return rowsLimit
     */
    int rowsLimit() default Constants.DEFAULT_ROWS_PER_PAGE_LIMIT;

    /**
     * rows específica el número inicial de filas por página que muestra la vista. Este elemento es relevante solo si el valor especificado, o
     * determinado, para el elemento enabled es TRUE. Su valor debe ser un número entero entre 1 y el valor del elemento rowsLimit. El valor
     * predeterminado es 10
     *
     * @return rows
     */
    int rows() default Constants.DEFAULT_ROWS_PER_PAGE;
//
//  int width() default 1200; // 800 <= width <= 2400

}
