/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package adalid.core.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * La anotación MasterProject se utiliza para establecer atributos del proyecto maestro.
 *
 * @author Jorge Campins
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.FIELD})
public @interface MasterProject {

    /**
     * alias especifica el código alterno del proyecto. El alias solo puede contener letras minúsculas y números, debe comenzar por una letra, y no
     * puede ser jee2ap101, meta o workspace. Se recomienda utilizar un alias que tenga el nombre de su proyecto como prefijo.
     *
     * @return alias
     */
    String alias() default "";

    /**
     * helpFile especifica el nombre del archivo de ayuda del proyecto, sin la ruta. Si utiliza la plataforma jee2, el archivo debe estar almacenado
     * en el subdirectorio resources/media/custom-made del módulo Web de la aplicación. Cada módulo y cada entidad pueden tener su propio archivo de
     * ayuda, establecido mediante el elemento helpFile de las anotaciones ProjectModule y EntityClass, respectivamente. Las vistas (páginas) de la
     * interfaz utilizarán el archivo de ayuda de la entidad de la vista, si existe; si no existe entonces utilizarán el archivo de ayuda del módulo
     * al que pertenece la entidad de la vista, si existe; si tampoco existe entonces utilizarán el archivo de ayuda del proyecto maestro, si existe;
     * si tampoco existe entonces la página de ayuda no estará disponible para la vista.
     *
     * @return helpFile
     */
    String helpFile() default "";

}
