/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package adalid.core.annotations;

import adalid.core.enums.Kleenean;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * La anotación ProcessOperationClass se utiliza para establecer atributos de meta operaciones que extienden la clase ProcessOperation.
 *
 * @author Jorge Campins
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface ProcessOperationClass {

    /**
     * name especifica el nombre alterno del procedimiento.
     *
     * @return name
     */
    String name() default "";

    /**
     * processingGroup especifica el código que identifica el grupo de procesamiento al que pertenece la operación. Las aplicaciones generadas con la
     * plataforma jee2 no permiten la ejecución simultánea de operaciones de un mismo grupo.
     *
     * @return processingGroup
     */
    String processingGroup() default "";

    /**
     * overloading indica si al generar procedimientos SQL de la operación se puede, o no, sobrecargar (overload) el nombre del procedimiento. Su
     * valor es uno de los elementos de la enumeración Kleenean. Seleccione TRUE si se puede sobrecargar el nombre; en caso contrario, seleccione
     * FALSE. Alternativamente, omita el elemento o seleccione UNSPECIFIED para utilizar el valor predeterminado del atributo. El valor predeterminado
     * del atributo es TRUE.
     *
     * @return overloading
     */
    Kleenean overloading() default Kleenean.UNSPECIFIED;

    /**
     * serviceable indica si se debe, o no, generar código BWS (Business Web Service) para la operación. Su valor es uno de los elementos de la
     * enumeración Kleenean. Seleccione TRUE para generar código BWS; en caso contrario, seleccione FALSE. Alternativamente, omita el elemento o
     * seleccione UNSPECIFIED para utilizar el valor predeterminado del atributo. El valor predeterminado del atributo es FALSE.
     *
     * @return serviceable
     */
    Kleenean serviceable() default Kleenean.UNSPECIFIED;

}
