/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package adalid.core.annotations;

import adalid.core.enums.Kleenean;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * La anotación ProjectModule se utiliza para establecer atributos de módulos en un proyecto maestro.
 *
 * @author Jorge Campins
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.FIELD})
public @interface ProjectModule {

    /**
     * menu indica si las vistas (páginas) generadas para las entidades que integran el módulo deben ser, o no, accesibles desde el menú principal de
     * la aplicación. Su valor es uno de los elementos de la enumeración Kleenean. Seleccione TRUE si las vistas (páginas) deben ser accesibles desde
     * el menú; en caso contrario, seleccione FALSE. Alternativamente, omita el elemento o seleccione UNSPECIFIED para utilizar el valor
     * predeterminado del atributo. El valor predeterminado del atributo es FALSE.
     *
     * @return menu
     */
    Kleenean menu() default Kleenean.UNSPECIFIED; // FALSE

    /**
     * role indica si se deben generar, o no, roles específicos para las operaciones de las entidades que integran el módulo. Su valor es uno de los
     * elementos de la enumeración Kleenean. Seleccione TRUE para generar roles específicos; en caso contrario, seleccione FALSE. Alternativamente,
     * omita el elemento o seleccione UNSPECIFIED para utilizar el valor predeterminado del atributo. El valor predeterminado del atributo es FALSE.
     *
     * @return role
     */
    Kleenean role() default Kleenean.UNSPECIFIED; // FALSE

    /**
     * foreign indica si las entidades que integran el módulo se deben agregar, o no, al conjunto de entidades foráneas de la aplicación. Las
     * entidades foráneas son entidades cuyas correspondientes tablas no están definidas en la base de datos de la aplicación, sino en otra que
     * tipicamente reside en un servidor diferente. Su valor es uno de los elementos de la enumeración Kleenean. Seleccione TRUE si las entidades se
     * deben agregar al conjunto de entidades foráneas; en caso contrario, seleccione FALSE. Alternativamente, omita el elemento o seleccione
     * UNSPECIFIED para utilizar el valor predeterminado del atributo. El valor predeterminado del atributo es FALSE.
     *
     * @return foreign
     */
    Kleenean foreign() default Kleenean.UNSPECIFIED; // FALSE

    /**
     * privacy indica si las entidades que integran el módulo se deben agregar, o no, al conjunto de entidades privadas de la aplicación. Las
     * entidades privadas son entidades para las que no se deben generar vistas. Su valor es uno de los elementos de la enumeración Kleenean.
     * Seleccione TRUE si las entidades se deben agregar al conjunto de entidades privadas; en caso contrario, seleccione FALSE. Alternativamente,
     * omita el elemento o seleccione UNSPECIFIED para utilizar el valor predeterminado del atributo. El valor predeterminado del atributo es FALSE.
     *
     * @return privacy
     */
    Kleenean privacy() default Kleenean.UNSPECIFIED; // FALSE

    /**
     * helpFile especifica el nombre del archivo de ayuda del módulo, sin la ruta. Si utiliza la plataforma jee2, el archivo debe estar almacenado en
     * el subdirectorio resources/media/custom-made del módulo Web de la aplicación.
     *
     * @return helpFile
     */
    String helpFile() default "";

}
